/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.storage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import java.util.Collection;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.0")
public class StorageImpl
implements Storage {
    private final MutableResourceList list;
    private long stored;

    public StorageImpl(MutableResourceList list) {
        this.list = list;
    }

    public StorageImpl() {
        this(MutableResourceListImpl.create());
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        ResourceAmount.validate(resource, amount);
        long availableAmount = this.list.get(resource);
        if (availableAmount == 0L) {
            return 0L;
        }
        long maxExtract = Math.min(availableAmount, amount);
        return this.doExtract(resource, maxExtract, action);
    }

    private long doExtract(ResourceKey resource, long amount, Action action) {
        if (action == Action.EXECUTE) {
            this.list.remove(resource, amount);
            this.stored -= amount;
        }
        return amount;
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        ResourceAmount.validate(resource, amount);
        if (action == Action.EXECUTE) {
            this.stored += amount;
            this.list.add(resource, amount);
        }
        return amount;
    }

    @Override
    public Collection<ResourceAmount> getAll() {
        return this.list.copyState();
    }

    @Override
    public long getStored() {
        return this.stored;
    }
}

