/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.storage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.StorageState;
import com.refinedmods.refinedstorage.api.storage.limited.LimitedStorage;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedStorage;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;

public class StateTrackedStorage
implements TrackedStorage,
LimitedStorage {
    private static final double NEAR_CAPACITY_THRESHOLD = 0.75;
    private final Storage delegate;
    @Nullable
    private final Listener listener;
    private StorageState state;

    public StateTrackedStorage(Storage delegate, @Nullable Listener listener) {
        this.delegate = delegate;
        this.listener = listener;
        this.state = this.computeState();
    }

    public Storage getDelegate() {
        return this.delegate;
    }

    public StorageState getState() {
        return this.state;
    }

    private StorageState computeState() {
        Storage storage = this.delegate;
        if (storage instanceof LimitedStorage) {
            LimitedStorage limitedStorage = (LimitedStorage)storage;
            return StateTrackedStorage.computeState(limitedStorage.getCapacity(), this.delegate.getStored());
        }
        return StorageState.NORMAL;
    }

    public static StorageState computeState(long capacity, long stored) {
        double fullness = (double)stored / (double)capacity;
        if (fullness >= 1.0) {
            return StorageState.FULL;
        }
        if (fullness >= 0.75) {
            return StorageState.NEAR_CAPACITY;
        }
        return StorageState.NORMAL;
    }

    private void checkStateChanged() {
        StorageState currentState = this.computeState();
        if (this.state != currentState) {
            this.state = currentState;
            this.notifyListener();
        }
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.onStorageStateChanged();
        }
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        long extracted = this.delegate.extract(resource, amount, action, actor);
        if (extracted > 0L && action == Action.EXECUTE) {
            this.checkStateChanged();
        }
        return extracted;
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        long inserted = this.delegate.insert(resource, amount, action, actor);
        if (inserted > 0L && action == Action.EXECUTE) {
            this.checkStateChanged();
        }
        return inserted;
    }

    @Override
    public Collection<ResourceAmount> getAll() {
        return this.delegate.getAll();
    }

    @Override
    public long getStored() {
        return this.delegate.getStored();
    }

    @Override
    public Optional<TrackedResource> findTrackedResourceByActorType(ResourceKey resource, Class<? extends Actor> actorType) {
        Optional<TrackedResource> optional;
        Storage storage = this.delegate;
        if (storage instanceof TrackedStorage) {
            TrackedStorage trackedStorage = (TrackedStorage)storage;
            optional = trackedStorage.findTrackedResourceByActorType(resource, actorType);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public long getCapacity() {
        long l;
        Storage storage = this.delegate;
        if (storage instanceof LimitedStorage) {
            LimitedStorage limitedStorage = (LimitedStorage)storage;
            l = limitedStorage.getCapacity();
        } else {
            l = 0L;
        }
        return l;
    }

    @FunctionalInterface
    public static interface Listener {
        public void onStorageStateChanged();
    }
}

