/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.relay;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.autocrafting.task.StepBehavior;
import com.refinedmods.refinedstorage.api.autocrafting.task.Task;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskListener;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.autocrafting.ParentContainer;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternListener;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProvider;
import com.refinedmods.refinedstorage.api.network.impl.autocrafting.TaskContainer;
import com.refinedmods.refinedstorage.api.network.impl.node.relay.RelayOutputNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.Filter;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

class RelayOutputPatternProvider
implements PatternProvider,
PatternListener,
TaskListener {
    private final RelayOutputNetworkNode outputNode;
    private final Filter filter = new Filter();
    private final Set<ParentContainer> parents = new HashSet<ParentContainer>();
    private final TaskContainer tasks = new TaskContainer(this);
    @Nullable
    private AutocraftingNetworkComponent delegate;
    private StepBehavior stepBehavior = StepBehavior.DEFAULT;

    RelayOutputPatternProvider(RelayOutputNetworkNode outputNode) {
        this.outputNode = outputNode;
    }

    List<Task> getTasks() {
        return this.tasks.getAll();
    }

    void setFilters(Set<ResourceKey> filters) {
        this.reset(() -> this.filter.setFilters(filters));
    }

    void setFilterMode(FilterMode filterMode) {
        this.reset(() -> this.filter.setMode(filterMode));
    }

    void setFilterNormalizer(UnaryOperator<ResourceKey> normalizer) {
        this.reset(() -> this.filter.setNormalizer(normalizer));
    }

    private void reset(Runnable action) {
        AutocraftingNetworkComponent oldDelegate = this.delegate;
        this.setDelegate(null);
        action.run();
        this.setDelegate(oldDelegate);
    }

    void setDelegate(@Nullable AutocraftingNetworkComponent delegate) {
        if (this.delegate != null) {
            this.parents.forEach(parent -> this.getPatterns().forEach(pattern -> parent.remove(this, (Pattern)pattern)));
            this.delegate.removeListener(this);
        }
        this.delegate = delegate;
        if (delegate != null) {
            this.parents.forEach(parent -> this.getPatterns().forEach(pattern -> parent.add(this, (Pattern)pattern, 0)));
            delegate.addListener(this);
        }
    }

    boolean hasDelegate() {
        return this.delegate != null;
    }

    private Set<Pattern> getPatterns() {
        if (this.delegate == null) {
            return Collections.emptySet();
        }
        return this.delegate.getPatterns().stream().filter(this::isPatternAllowed).collect(Collectors.toSet());
    }

    private boolean isPatternAllowed(Pattern pattern) {
        return pattern.layout().outputs().stream().map(ResourceAmount::resource).anyMatch(this.filter::isAllowed);
    }

    @Override
    public void onAdded(Pattern pattern) {
        if (this.delegate == null || !this.isPatternAllowed(pattern) || this.delegate.contains(this.delegate)) {
            return;
        }
        this.parents.forEach(parent -> parent.add(this, pattern, 0));
    }

    @Override
    public void onRemoved(Pattern pattern) {
        if (this.delegate == null || !this.isPatternAllowed(pattern) || this.delegate.contains(this.delegate)) {
            return;
        }
        this.parents.forEach(parent -> parent.remove(this, pattern));
    }

    @Override
    public boolean contains(AutocraftingNetworkComponent component) {
        return component == this.delegate || this.delegate != null && this.delegate.contains(component);
    }

    @Override
    public void addTask(Task task) {
        this.tasks.add(task, this.outputNode.getNetwork());
        this.parents.forEach(parent -> parent.taskAdded(this, task));
    }

    void doWork() {
        if (this.outputNode.getNetwork() == null) {
            return;
        }
        this.tasks.step(this.outputNode.getNetwork(), this.stepBehavior, this);
    }

    void setStepBehavior(StepBehavior stepBehavior) {
        this.stepBehavior = stepBehavior;
    }

    @Override
    public void cancelTask(TaskId taskId) {
        this.tasks.cancel(taskId);
    }

    @Override
    public List<TaskStatus> getTaskStatuses() {
        return this.tasks.getStatuses();
    }

    @Override
    public long getAmount(ResourceKey resource) {
        return this.tasks.getAmount(resource);
    }

    @Override
    public void receivedExternalIteration() {
    }

    @Override
    public void receivedExternalIteration(Pattern pattern) {
        if (this.delegate == null) {
            return;
        }
        PatternProvider patternProvider = this.delegate.getProviderByPattern(pattern);
        if (patternProvider == null) {
            return;
        }
        patternProvider.receivedExternalIteration();
    }

    @Override
    public void onAddedIntoContainer(ParentContainer parentContainer) {
        if (this.delegate != null) {
            this.delegate.getPatterns().forEach(pattern -> parentContainer.add(this, (Pattern)pattern, 0));
        }
        this.tasks.onAddedIntoContainer(parentContainer);
        this.parents.add(parentContainer);
    }

    @Override
    public void onRemovedFromContainer(ParentContainer parentContainer) {
        if (this.delegate != null) {
            this.delegate.getPatterns().forEach(pattern -> parentContainer.remove(this, (Pattern)pattern));
        }
        this.tasks.onRemovedFromContainer(parentContainer);
        this.parents.remove(parentContainer);
    }

    @Override
    public ExternalPatternSink.Result accept(Pattern pattern, Collection<ResourceAmount> resources, Action action) {
        if (this.delegate == null) {
            return ExternalPatternSink.Result.SKIPPED;
        }
        PatternProvider patternProvider = this.delegate.getProviderByPattern(pattern);
        if (patternProvider == null) {
            return ExternalPatternSink.Result.SKIPPED;
        }
        return patternProvider.accept(pattern, resources, action);
    }

    void detachAll(Network network) {
        this.tasks.detachAll(network);
    }

    void attachAll(Network network) {
        this.tasks.attachAll(network);
    }
}

