/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.grid;

import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridWatcherRootStorageListener;
import com.refinedmods.refinedstorage.api.network.node.grid.GridWatcher;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.api.storage.root.RootStorageListener;
import javax.annotation.Nullable;

class GridWatcherRegistration {
    private final GridWatcher watcher;
    private final Class<? extends Actor> actorType;
    @Nullable
    private RootStorageListener listener;

    GridWatcherRegistration(GridWatcher watcher, Class<? extends Actor> actorType) {
        this.watcher = watcher;
        this.actorType = actorType;
    }

    void attach(RootStorage rootStorage, boolean replay) {
        this.listener = new GridWatcherRootStorageListener(this.watcher, rootStorage, this.actorType);
        rootStorage.addListener(this.listener);
        if (replay) {
            rootStorage.getAll().forEach(resourceAmount -> this.watcher.onChanged(resourceAmount.resource(), resourceAmount.amount(), rootStorage.findTrackedResourceByActorType(resourceAmount.resource(), this.actorType).orElse(null)));
        }
    }

    void detach(RootStorage rootStorage) {
        if (this.listener == null) {
            return;
        }
        rootStorage.removeListener(this.listener);
        this.listener = null;
    }
}

