/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.core.component;

import com.refinedmods.refinedstorage.api.core.component.ComponentMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.4")
public class ComponentMapFactory<C, X> {
    private final Map<Class<? extends C>, Function<X, C>> factories;

    public ComponentMapFactory() {
        this(new LinkedHashMap<Class<? extends C>, Function<X, C>>());
    }

    private ComponentMapFactory(Map<Class<? extends C>, Function<X, C>> factories) {
        this.factories = factories;
    }

    public void addFactory(Class<? extends C> componentType, Function<X, C> factory) {
        this.factories.put(componentType, factory);
    }

    public ComponentMapFactory<C, X> copy() {
        return new ComponentMapFactory<C, X>(new LinkedHashMap<Class<? extends C>, Function<X, C>>(this.factories));
    }

    public ComponentMap<C> buildComponentMap(X context) {
        LinkedHashMap components = new LinkedHashMap();
        this.factories.forEach((componentType, factory) -> {
            Object component = factory.apply(context);
            components.put(componentType, component);
        });
        return new ComponentMap(components);
    }
}

