/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.calculation;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.PatternRepository;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.Amount;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CalculationException;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculator;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculatorListener;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingTree;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.MissingResourcesCraftingCalculatorListener;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.NumberOverflowDuringCalculationException;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CraftingCalculatorImpl
implements CraftingCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CraftingCalculatorImpl.class);
    private final PatternRepository patternRepository;
    private final RootStorage rootStorage;

    public CraftingCalculatorImpl(PatternRepository patternRepository, RootStorage rootStorage) {
        this.patternRepository = patternRepository;
        this.rootStorage = rootStorage;
    }

    @Override
    public <T> void calculate(ResourceKey resource, long amount, CraftingCalculatorListener<T> listener) {
        CoreValidations.validateLargerThanZero(amount, "Requested amount must be greater than 0");
        Collection<Pattern> patterns = this.patternRepository.getByOutput(resource);
        CraftingCalculatorListener<T> lastChildListener = null;
        for (Pattern pattern : patterns) {
            Amount patternAmount = Amount.of(pattern, resource, amount);
            if (patternAmount.getTotal() < 0L) {
                throw new NumberOverflowDuringCalculationException();
            }
            CraftingCalculatorListener<T> childListener = listener.childCalculationStarted(pattern, resource, patternAmount);
            CraftingTree<T> tree = CraftingTree.root(pattern, this.rootStorage, patternAmount, this.patternRepository, childListener);
            CraftingTree.CalculationResult calculationResult = tree.calculate();
            if (calculationResult == CraftingTree.CalculationResult.MISSING_RESOURCES) {
                lastChildListener = childListener;
                continue;
            }
            listener.childCalculationCompleted(childListener);
            return;
        }
        if (lastChildListener == null) {
            throw new IllegalStateException("No pattern found for " + String.valueOf(resource));
        }
        listener.childCalculationCompleted(lastChildListener);
    }

    private boolean isCraftable(ResourceKey resource, long amount) {
        MissingResourcesCraftingCalculatorListener listener = new MissingResourcesCraftingCalculatorListener();
        this.calculate(resource, amount, listener);
        return !listener.isMissingResources();
    }

    @Override
    public long getMaxAmount(ResourceKey resource) {
        try {
            LOGGER.debug("Finding max amount for {} starting from 1", (Object)resource);
            long low = 1L;
            long high = 1L;
            int calculationCount = 1;
            while (this.isCraftable(resource, high)) {
                low = high;
                LOGGER.debug("Finding low and high for the craftable amount, currently between {} and {}", (Object)low, (Object)(high *= 2L));
                ++calculationCount;
            }
            if (low == high) {
                return 0L;
            }
            LOGGER.debug("Our craftable amount is between {} and {}", (Object)low, (Object)high);
            while (low < high) {
                long amount = low + (high - low + 1L) / 2L;
                LOGGER.debug("Trying {} (between {} and {})", new Object[]{amount, low, high});
                ++calculationCount;
                if (this.isCraftable(resource, amount)) {
                    LOGGER.debug("{} was craftable, increasing our low amount", (Object)amount);
                    low = amount;
                    continue;
                }
                LOGGER.debug("{} is not craftable, decreasing our high amount", (Object)amount);
                high = amount - 1L;
            }
            LOGGER.debug("Found the maximum amount of {} in {} tries", (Object)low, (Object)calculationCount);
            return low;
        }
        catch (CalculationException e) {
            LOGGER.debug("Failed to calculate the maximum amount", (Throwable)e);
            return 0L;
        }
    }
}

