/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.elytraslot.common;

import com.illusivesoulworks.elytraslot.client.ElytraRenderResult;
import com.illusivesoulworks.elytraslot.common.IElytraProvider;
import com.illusivesoulworks.elytraslot.platform.Services;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class SimpleCompatibilityProvider
implements IElytraProvider {
    private static final Map<String, ResourceLocation> ID_TO_TEXTURE = new HashMap<String, ResourceLocation>();
    private static boolean init = false;

    @Override
    public boolean matches(ItemStack stack) {
        if (!init) {
            Predicate<String> isLoaded = Services.PLATFORM::isModLoaded;
            if (isLoaded.test("deeperdarker")) {
                ID_TO_TEXTURE.put("deeperdarker:soul_elytra", ResourceLocation.parse((String)"deeperdarker:textures/entity/soul_elytra.png"));
            }
            if (isLoaded.test("enderitemod")) {
                ID_TO_TEXTURE.put("enderitemod:enderite_elytra_seperated", ResourceLocation.parse((String)"minecraft:textures/entity/enderite_elytra.png"));
            }
            if (isLoaded.test("mythicmetals")) {
                ID_TO_TEXTURE.put("mythicmetals:celestium_elytra", ResourceLocation.parse((String)"mythicmetals:textures/models/celestium_elytra.png"));
            }
            if (isLoaded.test("mekanism")) {
                ID_TO_TEXTURE.put("mekanism:hdpe_elytra", ResourceLocation.parse((String)"mekanism:textures/entity/hdpe_elytra.png"));
            }
            if (isLoaded.test("alexsmobs")) {
                ID_TO_TEXTURE.put("alexsmobs:tarantula_hawk_elytra", ResourceLocation.parse((String)""));
            }
            if (isLoaded.test("mna")) {
                ID_TO_TEXTURE.put("mna:spectral_elytra", ResourceLocation.parse((String)"mna:textures/entity/elytra.png"));
            }
            if (isLoaded.test("wooden_elytra")) {
                ID_TO_TEXTURE.put("wooden_elytra:wooden_elytra", ResourceLocation.parse((String)"wooden_elytra:textures/entities/wooden_elytra.png"));
            }
            if (isLoaded.test("lolenderite")) {
                ID_TO_TEXTURE.put("lolenderite:enderite_plated_elytra", ResourceLocation.parse((String)"lolenderite:textures/entity/enderite_plated_elytra.png"));
            }
            if (isLoaded.test("netherelytra")) {
                ID_TO_TEXTURE.put("netherelytra:netherite_elytra", ResourceLocation.parse((String)"netherelytra:textures/entity/netherite_elytra.png"));
            }
            if (isLoaded.test("crystalmod")) {
                ID_TO_TEXTURE.put("crystalmod:sapphire_elytra", ResourceLocation.parse((String)"crystalmod:textures/entity/sapphire_elytra.png"));
                ID_TO_TEXTURE.put("crystalmod:black_tourmaline_elytra", ResourceLocation.parse((String)"crystalmod:textures/entity/black_tourmaline_elytra.png"));
            }
            if (isLoaded.test("lilwings")) {
                Set<ResourceLocation> entityTypes = Services.PLATFORM.getEntityTypes();
                for (ResourceLocation entityType : entityTypes) {
                    if (!entityType.getNamespace().equals("lilwings")) continue;
                    String name = entityType.getPath().substring(0, entityType.getPath().lastIndexOf("_")) + "_elytra";
                    ID_TO_TEXTURE.put("lilwings:" + name, ResourceLocation.fromNamespaceAndPath((String)"lilwings", (String)("textures/elytra/" + name + ".png")));
                }
            }
            init = true;
        }
        return ID_TO_TEXTURE.containsKey(Services.PLATFORM.getId(stack.getItem()).toString());
    }

    @Override
    public ElytraRenderResult getRender(ItemStack stack) {
        return new ElytraRenderResult(COLOR, ID_TO_TEXTURE.get(Services.PLATFORM.getId(stack.getItem()).toString()), stack.isEnchanted(), stack, this.hasCapeTexture(stack));
    }

    @Override
    public boolean hasCapeTexture(ItemStack stack) {
        ResourceLocation rl = Services.PLATFORM.getId(stack.getItem());
        if (rl != null) {
            if (Services.PLATFORM.isModLoaded("deeperdarker") && rl.toString().equals("deeperdarker:soul_elytra")) {
                return false;
            }
            if (Services.PLATFORM.isModLoaded("lilwings") && rl.getNamespace().equals("lilwings")) {
                return false;
            }
        }
        return true;
    }
}

