/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.IInputResourceTracker;
import ca.teamdman.sfm.common.program.LimitedSlot;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.Stored;
import ca.teamdman.sfml.ast.Label;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public class LimitedInputSlot<STACK, ITEM, CAP>
implements LimitedSlot<STACK, ITEM, CAP> {
    public ResourceType<STACK, ITEM, CAP> type;
    public CAP handler;
    public BlockPos pos;
    public Label label;
    public Direction direction;
    public int slot;
    public boolean freed;
    public IInputResourceTracker tracker;
    @Nullable
    private STACK extractSimulateCache = null;
    private boolean done = false;

    public LimitedInputSlot(Label label, BlockPos pos, Direction direction, int slot, CAP handler, IInputResourceTracker tracker, STACK stackCache, ResourceType<STACK, ITEM, CAP> type) {
        this.init(handler, label, pos, direction, slot, tracker, stackCache, type);
    }

    public boolean isDone() {
        if (this.done) {
            return true;
        }
        if (this.slot > this.type.getSlots(this.handler) - 1) {
            return true;
        }
        STACK stack = this.peekExtractPotential();
        if (this.type.isEmpty(stack)) {
            return true;
        }
        if (!this.tracker.matchesStack(stack)) {
            return true;
        }
        return this.tracker.isDone(this.type, stack);
    }

    public void setDone() {
        this.done = true;
    }

    public STACK extract(long amount) {
        this.extractSimulateCache = null;
        return this.type.extract(this.handler, this.slot, amount, false);
    }

    public STACK peekExtractPotential() {
        if (this.extractSimulateCache == null) {
            this.extractSimulateCache = this.type.extract(this.handler, this.slot, Long.MAX_VALUE, true);
        }
        return this.extractSimulateCache;
    }

    public void init(CAP handler, Label label, @Stored BlockPos pos, Direction direction, int slot, IInputResourceTracker tracker, STACK stackCache, ResourceType<STACK, ITEM, CAP> type) {
        this.done = false;
        this.extractSimulateCache = stackCache;
        this.handler = handler;
        this.tracker = tracker;
        this.slot = slot;
        this.pos = pos;
        this.label = label;
        this.direction = direction;
        this.freed = false;
        this.type = type;
    }

    public String toString() {
        return "LimitedInputSlot{label=" + String.valueOf(this.label) + ", pos=" + String.valueOf(this.pos) + ", direction=" + String.valueOf(this.direction) + ", slot=" + this.slot + ", cap=" + this.type.displayAsCapabilityClass() + ", tracker=" + String.valueOf(this.tracker) + "}";
    }

    @Override
    public ResourceType<STACK, ITEM, CAP> getType() {
        return this.type;
    }

    @Override
    public CAP getHandler() {
        return this.handler;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public int getSlot() {
        return this.slot;
    }
}

