/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMDataComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record LabelPositionHolder(Map<String, HashSet<BlockPos>> labels) {
    public static final StreamCodec<FriendlyByteBuf, LabelPositionHolder> STREAM_CODEC = StreamCodec.ofMember(LabelPositionHolder::encode, LabelPositionHolder::decode);
    public static final MapCodec<LabelPositionHolder> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)BlockPos.CODEC.listOf().xmap(HashSet::new, ArrayList::new)).fieldOf("labels").forGetter(LabelPositionHolder::labels)).apply((Applicative)builder, LabelPositionHolder::new));
    private static final WeakHashMap<ItemStack, LabelPositionHolder> CACHE = new WeakHashMap();

    private LabelPositionHolder() {
        this(new HashMap<String, HashSet<BlockPos>>());
    }

    private LabelPositionHolder(LabelPositionHolder other) {
        this();
        other.labels().forEach((? super K key, ? super V value) -> this.labels().put((String)key, new HashSet(value)));
    }

    public static void encode(LabelPositionHolder labelPositionHolder, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeVarInt(labelPositionHolder.labels().size());
        for (Map.Entry<String, HashSet<BlockPos>> entry : labelPositionHolder.labels().entrySet()) {
            String label = entry.getKey();
            Set positions = entry.getValue();
            friendlyByteBuf.writeUtf(label);
            friendlyByteBuf.writeVarInt(positions.size());
            positions.forEach(arg_0 -> ((FriendlyByteBuf)friendlyByteBuf).writeBlockPos(arg_0));
        }
    }

    public static LabelPositionHolder decode(FriendlyByteBuf friendlyByteBuf) {
        LabelPositionHolder rtn = LabelPositionHolder.empty();
        int size = friendlyByteBuf.readVarInt();
        for (int i = 0; i < size; ++i) {
            String label = friendlyByteBuf.readUtf();
            int positionsSize = friendlyByteBuf.readVarInt();
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            for (int j = 0; j < positionsSize; ++j) {
                positions.add(friendlyByteBuf.readBlockPos());
            }
            rtn.labels().put(label, positions);
        }
        return rtn;
    }

    public static LabelPositionHolder from(ItemStack stack) {
        return CACHE.computeIfAbsent(stack, s -> {
            LabelPositionHolder immutableLabelPositionHolder = (LabelPositionHolder)stack.get(SFMDataComponents.LABEL_POSITION_HOLDER);
            if (immutableLabelPositionHolder == null) {
                return new LabelPositionHolder();
            }
            return new LabelPositionHolder(immutableLabelPositionHolder);
        });
    }

    public static LabelPositionHolder empty() {
        return new LabelPositionHolder();
    }

    public LabelPositionHolder save(ItemStack stack) {
        LabelPositionHolder copy = new LabelPositionHolder(this);
        stack.set(SFMDataComponents.LABEL_POSITION_HOLDER, (Object)copy);
        CACHE.put(stack, copy);
        return this;
    }

    public static void clear(ItemStack stack) {
        stack.remove(SFMDataComponents.LABEL_POSITION_HOLDER);
        CACHE.remove(stack);
    }

    public boolean contains(String label, BlockPos pos) {
        HashSet<BlockPos> positionsForLabel = this.labels().get(label);
        if (positionsForLabel == null) {
            return false;
        }
        return positionsForLabel.contains(pos);
    }

    public LabelPositionHolder toggle(String label, BlockPos pos) {
        if (this.contains(label, pos)) {
            this.remove(label, pos);
        } else {
            this.add(label, pos);
        }
        return this;
    }

    public Set<BlockPos> getPositions(String label) {
        return this.labels().getOrDefault(label, new HashSet());
    }

    public Set<BlockPos> getPositionsMut(String label) {
        return this.labels().computeIfAbsent(label, s -> new HashSet());
    }

    public LabelPositionHolder addAll(String label, Collection<BlockPos> positions) {
        this.getPositionsMut(label).addAll(positions);
        return this;
    }

    public LabelPositionHolder addReferencedLabel(String label) {
        this.getPositionsMut(label);
        return this;
    }

    public List<Component> asHoverText() {
        ArrayList<Component> rtn = new ArrayList<Component>();
        if (this.labels().isEmpty()) {
            return rtn;
        }
        rtn.add((Component)LocalizationKeys.DISK_ITEM_TOOLTIP_LABEL_HEADER.getComponent().withStyle(ChatFormatting.UNDERLINE));
        for (Map.Entry<String, HashSet<BlockPos>> entry : this.labels().entrySet()) {
            rtn.add((Component)LocalizationKeys.DISK_ITEM_TOOLTIP_LABEL.getComponent(entry.getKey(), entry.getValue().size()).withStyle(ChatFormatting.GRAY));
        }
        return rtn;
    }

    public String toDebugString() {
        int total = 0;
        StringBuilder rtn = new StringBuilder();
        for (Map.Entry<String, HashSet<BlockPos>> entry : this.labels().entrySet()) {
            rtn.append("-- * ").append(entry.getKey()).append(" - ").append(entry.getValue().size()).append(" positions\n");
            total += entry.getValue().size();
        }
        return "-- LabelPositionHolder - " + total + " total labels\n" + String.valueOf(rtn);
    }

    public LabelPositionHolder removeAll(BlockPos value) {
        this.labels().values().forEach((? super T list) -> list.remove(value));
        return this;
    }

    public LabelPositionHolder prune() {
        this.labels().entrySet().removeIf((? super E entry) -> ((HashSet)entry.getValue()).isEmpty());
        return this;
    }

    public LabelPositionHolder clear() {
        this.labels().clear();
        return this;
    }

    public LabelPositionHolder add(String label, BlockPos position) {
        this.getPositionsMut(label).add(position);
        return this;
    }

    public LabelPositionHolder remove(String label, BlockPos pos) {
        this.getPositionsMut(label).remove(pos);
        return this;
    }

    public LabelPositionHolder removeIf(BiPredicate<String, BlockPos> predicate) {
        this.labels().forEach((? super K key, ? super V value) -> value.removeIf((? super E pos) -> predicate.test((String)key, (BlockPos)pos)));
        return this;
    }

    public LabelPositionHolder removeIf(Predicate<String> predicate) {
        this.labels().keySet().removeIf(predicate);
        return this;
    }

    public LabelPositionHolder forEach(BiConsumer<String, BlockPos> consumer) {
        this.labels().forEach((? super K key, ? super V value) -> value.forEach((? super T pos) -> consumer.accept((String)key, (BlockPos)pos)));
        return this;
    }

    @Override
    public String toString() {
        return "LabelPositionHolder{size=" + this.labels().values().stream().mapToInt(Set::size).sum() + "; " + this.labels().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + ((HashSet)entry.getValue()).size()).collect(Collectors.joining(", ")) + "}";
    }

    public LabelPositionHolder toOwned() {
        return new LabelPositionHolder(this);
    }

    public Set<String> getLabels(BlockPos pos) {
        return this.labels().entrySet().stream().filter(entry -> ((HashSet)entry.getValue()).contains(pos)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public boolean isEmpty() {
        return this.labels().isEmpty();
    }
}

