/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.IOutputResourceTracker;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceLimit;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.resources.ResourceLocation;

public class ExpandedQuantityExpandedRetentionOutputResourceTracker
implements IOutputResourceTracker {
    private final ResourceLimit resource_limit;
    private final ResourceIdSet exclusions;
    private final Object2ObjectOpenHashMap<ResourceType<?, ?, ?>, Object2LongOpenHashMap<ResourceLocation>> retention_obligations_by_item = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<ResourceType<?, ?, ?>, Object2LongOpenHashMap<ResourceLocation>> transferred_by_item = new Object2ObjectOpenHashMap();

    public ExpandedQuantityExpandedRetentionOutputResourceTracker(ResourceLimit resourceLimit, ResourceIdSet exclusions) {
        this.resource_limit = resourceLimit;
        this.exclusions = exclusions;
    }

    @Override
    public <STACK, CAP, ITEM> boolean isDone(ResourceType<STACK, ITEM, CAP> type, STACK stack) {
        long can_transfer = this.resource_limit.limit().quantity().number().value();
        long max_put = this.resource_limit.limit().retention().number().value();
        long transferred_for_item = 0L;
        Object2LongOpenHashMap transferred_for_resource_type = (Object2LongOpenHashMap)this.transferred_by_item.get(type);
        if (transferred_for_resource_type != null) {
            ResourceLocation item_id = type.getRegistryKeyForStack(stack);
            transferred_for_item = transferred_for_resource_type.getLong((Object)item_id);
        }
        if (transferred_for_item >= can_transfer) {
            return true;
        }
        long retained_for_item = 0L;
        Object2LongOpenHashMap retained_for_resource_type = (Object2LongOpenHashMap)this.retention_obligations_by_item.get(type);
        if (retained_for_resource_type != null) {
            ResourceLocation item_id = type.getRegistryKeyForStack(stack);
            retained_for_item = retained_for_resource_type.getLong((Object)item_id);
        }
        return retained_for_item >= max_put;
    }

    @Override
    public ResourceLimit getResourceLimit() {
        return this.resource_limit;
    }

    @Override
    public ResourceIdSet getExclusions() {
        return this.exclusions;
    }

    @Override
    public <STACK, ITEM, CAP> void updateRetentionObservation(ResourceType<STACK, ITEM, CAP> type, STACK stack) {
        if (this.matchesStack(stack)) {
            ResourceLocation item_id = type.getRegistryKeyForStack(stack);
            ((Object2LongOpenHashMap)this.retention_obligations_by_item.computeIfAbsent(type, k -> new Object2LongOpenHashMap())).addTo((Object)item_id, type.getAmount(stack));
        }
    }

    @Override
    public <STACK, ITEM, CAP> long getMaxTransferable(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack) {
        long max_transfer = this.resource_limit.limit().quantity().number().value();
        long transferred_for_item = 0L;
        Object2LongOpenHashMap transferred_for_resource_type = (Object2LongOpenHashMap)this.transferred_by_item.get(resourceType);
        if (transferred_for_resource_type != null) {
            ResourceLocation item_id = resourceType.getRegistryKeyForStack(stack);
            transferred_for_item = transferred_for_resource_type.getLong((Object)item_id);
        }
        long unusedQuantity = max_transfer - transferred_for_item;
        long max_retain = this.resource_limit.limit().retention().number().value();
        long retained_for_item = 0L;
        Object2LongOpenHashMap retained_for_resource_type = (Object2LongOpenHashMap)this.retention_obligations_by_item.get(resourceType);
        if (retained_for_resource_type != null) {
            ResourceLocation item_id = resourceType.getRegistryKeyForStack(stack);
            retained_for_item = retained_for_resource_type.getLong((Object)item_id);
        }
        long remainingRetentionRoom = max_retain - retained_for_item;
        return Math.min(unusedQuantity, remainingRetentionRoom);
    }

    @Override
    public <STACK, ITEM, CAP> void trackTransfer(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack, long amount) {
        ResourceLocation item_id = resourceType.getRegistryKeyForStack(stack);
        ((Object2LongOpenHashMap)this.transferred_by_item.computeIfAbsent(resourceType, k -> new Object2LongOpenHashMap())).addTo((Object)item_id, amount);
        ((Object2LongOpenHashMap)this.retention_obligations_by_item.computeIfAbsent(resourceType, k -> new Object2LongOpenHashMap())).addTo((Object)item_id, amount);
    }

    public String toString() {
        return "ExpandedQuantityExpandedRetentionOutputResourceTracker{resource_limit=" + String.valueOf(this.resource_limit) + ", exclusions=" + String.valueOf(this.exclusions) + ", retention_obligations_by_item=" + String.valueOf(this.retention_obligations_by_item) + ", transferred_by_item=" + String.valueOf(this.transferred_by_item) + "}";
    }
}

