/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public record ServerboundLabelGunUpdatePacket(String label, InteractionHand hand) implements SFMPacket
{
    public static final int MAX_LABEL_LENGTH = 80;

    public static class Daddy
    implements SFMPacketDaddy<ServerboundLabelGunUpdatePacket> {
        @Override
        public SFMPacketDaddy.PacketDirection getPacketDirection() {
            return SFMPacketDaddy.PacketDirection.SERVERBOUND;
        }

        @Override
        public void encode(ServerboundLabelGunUpdatePacket msg, RegistryFriendlyByteBuf buf) {
            buf.writeUtf(msg.label, 80);
            buf.writeEnum((Enum)msg.hand);
        }

        @Override
        public ServerboundLabelGunUpdatePacket decode(RegistryFriendlyByteBuf buf) {
            return new ServerboundLabelGunUpdatePacket(buf.readUtf(80), (InteractionHand)buf.readEnum(InteractionHand.class));
        }

        @Override
        public void handle(ServerboundLabelGunUpdatePacket msg, SFMPacketHandlingContext context) {
            ServerPlayer sender = context.sender();
            if (sender == null) {
                return;
            }
            ItemStack stack = sender.getItemInHand(msg.hand);
            if (stack.getItem() instanceof LabelGunItem) {
                LabelGunItem.setActiveLabel(stack, msg.label);
            }
        }

        @Override
        public Class<ServerboundLabelGunUpdatePacket> getPacketClass() {
            return ServerboundLabelGunUpdatePacket.class;
        }
    }
}

