/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.handler;

import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.config.SFMServerConfig;
import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.recipe.PrintingPressRecipe;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMRecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;

@EventBusSubscriber(modid="sfm", bus=EventBusSubscriber.Bus.GAME)
public class FallingAnvilHandler {
    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public static void onLeave(EntityLeaveLevelEvent event) {
        FallingBlockEntity fbe;
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlockEntity && (fbe = (FallingBlockEntity)entity).getBlockState().getBlock() instanceof AnvilBlock) {
            BlockPos landPosition = fbe.blockPosition();
            Level level = event.getLevel();
            if (!level.isLoaded(landPosition.below())) {
                return;
            }
            Block block = level.getBlockState(landPosition.below()).getBlock();
            if (block == Blocks.IRON_BLOCK) {
                boolean bl;
                List recipes = level.getRecipeManager().getAllRecipesFor(SFMRecipeTypes.PRINTING_PRESS.get());
                ArrayList<ItemEntity> items = new ArrayList<ItemEntity>();
                for (ItemEntity itemEntity : level.getEntitiesOfClass(ItemEntity.class, new AABB(landPosition))) {
                    if (!itemEntity.isAlive() || itemEntity.getItem().isEmpty()) continue;
                    items.add(itemEntity);
                }
                boolean bl2 = false;
                block7: for (ItemEntity itemEntity : items) {
                    for (RecipeHolder recipe : recipes) {
                        if (!((PrintingPressRecipe)recipe.value()).form().test(itemEntity.getItem())) continue;
                        bl = true;
                        itemEntity.setItem(FormItem.getForm(itemEntity.getItem()));
                        continue block7;
                    }
                }
                if (bl) {
                    level.setBlockAndUpdate(landPosition.below(), Blocks.AIR.defaultBlockState());
                }
            } else if (block == Blocks.OBSIDIAN) {
                void var7_19;
                ArrayList<ItemEntity> items = new ArrayList<ItemEntity>();
                for (ItemEntity itemEntity : level.getEntitiesOfClass(ItemEntity.class, new AABB(landPosition))) {
                    if (!itemEntity.isAlive() || itemEntity.getItem().isEmpty()) continue;
                    items.add(itemEntity);
                }
                for (ItemEntity itemEntity : items) {
                    if (!itemEntity.getItem().is(Items.ENCHANTED_BOOK)) continue;
                    ItemStack itemStack = itemEntity.getItem();
                    ItemEnchantments itemEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemStack);
                    long l = switch ((SFMServerConfig.LevelsToShards)((Object)SFMConfig.SERVER.levelsToShards.get())) {
                        default -> throw new MatchException(null, null);
                        case SFMServerConfig.LevelsToShards.JustOne -> 1L;
                        case SFMServerConfig.LevelsToShards.EachOne -> itemEnchantments.size();
                        case SFMServerConfig.LevelsToShards.SumLevels -> {
                            int sum = 0;
                            for (Object2IntMap.Entry holderEntry : itemEnchantments.entrySet()) {
                                sum += holderEntry.getIntValue();
                            }
                            yield sum;
                        }
                        case SFMServerConfig.LevelsToShards.SumLevelsScaledExponentially -> {
                            int sum = 0;
                            for (Object2IntMap.Entry holderEntry : itemEnchantments.entrySet()) {
                                int incr = 1 << Math.max(0, holderEntry.getIntValue() - 1);
                                if (sum + incr > 0) {
                                    sum += incr;
                                    continue;
                                }
                                sum = Integer.MAX_VALUE;
                            }
                            yield sum;
                        }
                    };
                    long count = (long)itemStack.getCount() * l;
                    itemEntity.setItem(new ItemStack((ItemLike)SFMItems.EXPERIENCE_SHARD_ITEM.get(), (int)Math.min(64L, count)));
                    count -= 64L;
                    while (count > 0L) {
                        itemEntity.spawnAtLocation(new ItemStack((ItemLike)SFMItems.EXPERIENCE_SHARD_ITEM.get(), (int)Math.min(64L, count)));
                        count -= 64L;
                    }
                }
                ArrayList<ItemEntity> bookEntities = new ArrayList<ItemEntity>();
                for (ItemEntity itemEntity : items) {
                    if (!itemEntity.getItem().is(Items.BOOK)) continue;
                    bookEntities.add(itemEntity);
                }
                boolean bl = false;
                for (ItemEntity itemEntity : bookEntities) {
                    int n = itemEntity.getItem().getCount();
                    var7_17 += n;
                }
                ArrayList<ItemEntity> arrayList = new ArrayList<ItemEntity>(items.size());
                for (ItemEntity itemEntity : items) {
                    if (EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemEntity.getItem()).isEmpty()) continue;
                    arrayList.add(itemEntity);
                }
                for (ItemEntity itemEntity : arrayList) {
                    ItemStack enchStack = itemEntity.getItem();
                    int enchStackSize = enchStack.getCount();
                    ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)enchStack));
                    Iterator enchIter = enchantments.keySet().iterator();
                    while (enchIter.hasNext()) {
                        void var7_18;
                        Holder key = (Holder)enchIter.next();
                        int value = enchantments.getLevel(key);
                        if (var7_18 < enchStackSize) break;
                        ItemStack toSpawn = new ItemStack((ItemLike)Items.ENCHANTED_BOOK, enchStackSize);
                        toSpawn.enchant(key, value);
                        level.addFreshEntity((Entity)new ItemEntity(level, (double)landPosition.getX(), (double)landPosition.getY(), (double)landPosition.getZ(), toSpawn));
                        enchIter.remove();
                        var7_18 -= enchStackSize;
                    }
                    EnchantmentHelper.setEnchantments((ItemStack)enchStack, (ItemEnchantments)enchantments.toImmutable());
                }
                for (ItemEntity itemEntity : bookEntities) {
                    itemEntity.kill();
                }
                while (var7_19 > 0) {
                    int n = Math.min((int)var7_19, 64);
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)landPosition.getX(), (double)landPosition.getY(), (double)landPosition.getZ(), new ItemStack((ItemLike)Items.BOOK, n)));
                    var7_19 -= n;
                }
            }
        }
    }
}

