/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.block;

import ca.teamdman.sfm.common.block.CableBlock;
import ca.teamdman.sfm.common.block.IFacadableBlock;
import ca.teamdman.sfm.common.facade.FacadeTransparency;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.registry.SFMBlocks;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.Stored;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CableFacadeBlock
extends CableBlock
implements EntityBlock,
IFacadableBlock {
    public CableFacadeBlock() {
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FacadeTransparency.FACADE_TRANSPARENCY_PROPERTY, (Comparable)((Object)FacadeTransparency.OPAQUE)));
    }

    @Nullable
    public BlockEntity newBlockEntity(@Stored BlockPos blockPos, BlockState blockState) {
        return SFMBlockEntities.CABLE_FACADE_BLOCK_ENTITY.get().create(blockPos, blockState);
    }

    public VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, @NotStored BlockPos pPos) {
        return pState.getValue(FacadeTransparency.FACADE_TRANSPARENCY_PROPERTY) == FacadeTransparency.TRANSLUCENT ? Shapes.empty() : Shapes.block();
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, @NotStored BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)SFMBlocks.CABLE_BLOCK.get());
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pLevel, @NotStored BlockPos pPos) {
        return pState.getValue(FacadeTransparency.FACADE_TRANSPARENCY_PROPERTY) == FacadeTransparency.TRANSLUCENT;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FacadeTransparency.FACADE_TRANSPARENCY_PROPERTY});
    }

    @Override
    public BlockState getStateForPlacementByFacadePlan(LevelAccessor level, @NotStored BlockPos pos, @Nullable FacadeTransparency facadeTransparency) {
        BlockState blockState = super.getStateForPlacementByFacadePlan(level, pos, facadeTransparency);
        if (facadeTransparency == null) {
            return blockState;
        }
        return (BlockState)blockState.setValue(FacadeTransparency.FACADE_TRANSPARENCY_PROPERTY, (Comparable)((Object)facadeTransparency));
    }
}

