/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.render;

import ca.teamdman.sfm.client.ClientKeyHelpers;
import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="sfm", value={Dist.CLIENT})
public class FormItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ModelResourceLocation BASE_MODEL = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sfm", (String)"item/form_base"));

    public FormItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        event.register(BASE_MODEL);
    }

    public void renderByItem(ItemStack stack, @MCVersionDependentBehaviour ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource multiBuffer, int packedLight, int packedOverlay) {
        if (!(stack.getItem() instanceof FormItem)) {
            return;
        }
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        BakedModel baseModel = renderer.getItemModelShaper().getModelManager().getModel(BASE_MODEL);
        RenderType renderType = ItemBlockRenderTypes.getRenderType((ItemStack)stack, (boolean)true);
        VertexConsumer buffer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)multiBuffer, (RenderType)renderType, (boolean)true, (boolean)stack.hasFoil());
        poseStack.pushPose();
        if (transformType != ItemDisplayContext.FIXED && transformType != ItemDisplayContext.GUI) {
            poseStack.scale(0.5f, 0.5f, 1.0f);
            poseStack.translate(0.5, 0.5, 0.0);
        }
        if (ClientKeyHelpers.isKeyDownInScreenOrWorld(SFMKeyMappings.MORE_INFO_TOOLTIP_KEY)) {
            BakedModel model;
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.5f, 0.3f);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            renderer.renderModelLists(baseModel, stack, packedLight, packedOverlay, poseStack, buffer);
            poseStack.popPose();
            ItemStack reference = FormItem.getReference(stack);
            if (!reference.isEmpty() && (model = renderer.getItemModelShaper().getItemModel(reference.getItem())) != null) {
                renderer.renderModelLists(model, stack, packedLight, packedOverlay, poseStack, buffer);
            }
        } else {
            renderer.renderModelLists(baseModel, stack, packedLight, packedOverlay, poseStack, buffer);
        }
        poseStack.popPose();
    }
}

