/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.widget;

import ca.teamdman.sfm.client.gui.widget.SFMExtendedButton;
import ca.teamdman.sfm.client.gui.widget.SFMExtendedButtonWithTooltip;
import ca.teamdman.sfm.common.localization.LocalizationEntry;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class SFMButtonBuilder {
    @Nullable
    private Component text = null;
    private int x = 0;
    private int y = 0;
    private int width = 150;
    private int height = 20;
    @Nullable
    private Button.OnPress onPress = null;
    @MCVersionDependentBehaviour
    @Nullable
    private Tooltip tooltip = null;

    public SFMButtonBuilder setText(LocalizationEntry text) {
        return this.setText((Component)text.getComponent());
    }

    public SFMButtonBuilder setText(Component text) {
        this.text = text;
        return this;
    }

    public SFMButtonBuilder setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public SFMButtonBuilder setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public SFMButtonBuilder setOnPress(Button.OnPress onPress) {
        this.onPress = onPress;
        return this;
    }

    public SFMButtonBuilder setTooltip(Screen screen, Font font, LocalizationEntry tooltip) {
        return this.setTooltip(screen, font, (Component)tooltip.getComponent());
    }

    @MCVersionDependentBehaviour
    public SFMButtonBuilder setTooltip(Screen screen, Font font, Component tooltip) {
        this.tooltip = Tooltip.create((Component)tooltip);
        return this;
    }

    public Button build() {
        if (this.text == null) {
            throw new IllegalArgumentException("Text must be set");
        }
        if (this.onPress == null) {
            throw new IllegalArgumentException("OnPress must be set");
        }
        if (this.tooltip != null) {
            return new SFMExtendedButtonWithTooltip(this.x, this.y, this.width, this.height, this.text, this.onPress, this.tooltip);
        }
        return new SFMExtendedButton(this.x, this.y, this.width, this.height, this.text, this.onPress);
    }
}

