/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.gui.screen.ExampleEditScreen;
import ca.teamdman.sfm.client.gui.screen.ExampleEditScreenOpenContext;
import ca.teamdman.sfm.client.gui.screen.ExamplesScreen;
import ca.teamdman.sfm.client.gui.screen.LabelGunScreen;
import ca.teamdman.sfm.client.gui.screen.LogsScreen;
import ca.teamdman.sfm.client.gui.screen.ProgramEditScreenOpenContext;
import ca.teamdman.sfm.client.gui.screen.ProgramEditorScreen;
import ca.teamdman.sfm.client.gui.screen.TomlEditScreen;
import ca.teamdman.sfm.client.gui.screen.TomlEditScreenOpenContext;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundManagerLogDesireUpdatePacket;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.registry.SFMPackets;
import java.io.BufferedReader;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class SFMScreenChangeHelpers {
    public static void setOrPushScreen(Screen screen) {
        if (Minecraft.getInstance().screen == null) {
            Minecraft.getInstance().setScreen(screen);
        } else {
            Minecraft.getInstance().pushGuiLayer(screen);
        }
    }

    public static void popScreen() {
        Minecraft.getInstance().popGuiLayer();
    }

    public static void showLabelGunScreen(ItemStack stack, InteractionHand hand) {
        SFMScreenChangeHelpers.setOrPushScreen(new LabelGunScreen(stack, hand));
    }

    public static void showProgramEditScreen(ProgramEditScreenOpenContext context) {
        ProgramEditorScreen screen = new ProgramEditorScreen(context);
        SFMScreenChangeHelpers.setOrPushScreen(screen);
        screen.scrollToTop();
    }

    public static void showTomlEditScreen(TomlEditScreenOpenContext context) {
        TomlEditScreen screen = new TomlEditScreen(context);
        SFMScreenChangeHelpers.setOrPushScreen(screen);
        screen.scrollToTop();
    }

    public static void showProgramEditScreen(String initialContent) {
        ProgramEditScreenOpenContext openContext = new ProgramEditScreenOpenContext(initialContent, LabelPositionHolder.empty(), x -> {});
        SFMScreenChangeHelpers.showProgramEditScreen(openContext);
    }

    public static void showExampleListScreen(String diskProgramString, LabelPositionHolder labelPositionHolder, Consumer<String> saveCallback) {
        SFMScreenChangeHelpers.setOrPushScreen(new ExamplesScreen((chosenTemplate, templates) -> {
            ExampleEditScreen screen = new ExampleEditScreen(new ExampleEditScreenOpenContext((String)chosenTemplate, diskProgramString, (Map<String, String>)templates, labelPositionHolder, saveCallback));
            SFMScreenChangeHelpers.setOrPushScreen(screen);
            screen.scrollToTop();
        }));
    }

    public static void showLogsScreen(ManagerContainerMenu menu) {
        LogsScreen screen = new LogsScreen(menu);
        SFMScreenChangeHelpers.setOrPushScreen(screen);
        screen.scrollToBottom();
        SFMPackets.sendToServer(new ServerboundManagerLogDesireUpdatePacket(menu.containerId, menu.MANAGER_POSITION, true));
    }

    public static void showItemInspectorScreen(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        stack.save((HolderLookup.Provider)level.registryAccess(), (Tag)tag);
        if (!tag.isEmpty()) {
            String content = tag.toString();
            Minecraft minecraft = Minecraft.getInstance();
            minecraft.keyboardHandler.setClipboard(content);
            SFM.LOGGER.info("Copied {} characters to clipboard", (Object)content.length());
            assert (minecraft.player != null);
            minecraft.player.sendSystemMessage((Component)LocalizationKeys.ITEM_INSPECTOR_COPIED_TO_CLIPBOARD.getComponent(Component.literal((String)String.valueOf(content.length())).withStyle(ChatFormatting.AQUA)));
        }
    }

    public static void showChangelog() {
        String changelog = null;
        ResourceManager irm = Minecraft.getInstance().getResourceManager();
        Map found = irm.listResources("template_programs", path -> path.getPath().endsWith(".sfml") || path.getPath().endsWith(".sfm"));
        for (Map.Entry entry : found.entrySet()) {
            if (!((ResourceLocation)entry.getKey()).getPath().equals("template_programs/changelog.sfml")) continue;
            try (BufferedReader reader = ((Resource)entry.getValue()).openAsReader();){
                changelog = reader.lines().collect(Collectors.joining("\n"));
                break;
            }
            catch (Exception e) {
                SFM.LOGGER.error("Failed to read changelog", (Throwable)e);
            }
        }
        if (changelog == null) {
            SFM.LOGGER.error("Failed to find changelog");
            return;
        }
        ExampleEditScreen screen = new ExampleEditScreen(new ExampleEditScreenOpenContext(changelog, changelog, Map.of("changelog.sfml", changelog), LabelPositionHolder.empty(), newContent -> {}));
        SFMScreenChangeHelpers.setOrPushScreen(screen);
        screen.scrollToTop();
    }
}

