/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.gui.screen.ProgramEditScreenOpenContext;
import ca.teamdman.sfm.client.gui.screen.SFMFontUtils;
import ca.teamdman.sfm.client.gui.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.client.gui.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.command.ConfigCommandBehaviourInput;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.diagnostics.SFMDiagnostics;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.ServerboundManagerFixPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerProgramPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerRebuildPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerResetPacket;
import ca.teamdman.sfm.common.net.ServerboundServerConfigRequestPacket;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Level;
import org.joml.Matrix4f;

public class ManagerScreen
extends AbstractContainerScreen<ManagerContainerMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"sfm", (String)"textures/gui/container/manager.png");
    private final float STATUS_DURATION = 40.0f;
    private Component status = Component.empty();
    private float statusCountdown = 0.0f;
    private Button diagButton;
    private Button clipboardPasteButton;
    private Button clipboardCopyButton;
    private Button discordButton;
    private Button resetButton;
    private Button editButton;
    private Button examplesButton;
    private Button logsButton;
    private Button rebuildButton;
    private Button serverConfigButton;

    public ManagerScreen(ManagerContainerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
    }

    public List<Button> getButtonsForJEIExclusionZones() {
        return List.of(this.clipboardPasteButton, this.editButton, this.examplesButton, this.clipboardCopyButton, this.logsButton, this.rebuildButton, this.serverConfigButton);
    }

    public boolean isReadOnly() {
        LocalPlayer player = Minecraft.getInstance().player;
        return player == null || player.isSpectator();
    }

    public void updateVisibilities() {
        boolean diskPresent = ((ManagerContainerMenu)this.menu).getSlot(0).hasItem();
        this.diagButton.visible = this.shouldShowDiagButton();
        this.clipboardCopyButton.visible = diskPresent;
        this.logsButton.visible = diskPresent;
        this.rebuildButton.visible = diskPresent && !this.isReadOnly();
        this.clipboardPasteButton.visible = diskPresent && !this.isReadOnly();
        this.resetButton.visible = diskPresent && !this.isReadOnly();
        this.editButton.visible = diskPresent && !this.isReadOnly();
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (Screen.isPaste((int)pKeyCode) && this.clipboardPasteButton.visible) {
            this.onClipboardPasteButtonClicked();
            return true;
        }
        if (Screen.isCopy((int)pKeyCode) && this.clipboardCopyButton.visible) {
            this.onClipboardCopyButtonClicked();
            return true;
        }
        if (pKeyCode == 69 && Screen.hasControlDown() && Screen.hasShiftDown() && this.examplesButton.visible) {
            this.onExamplesButtonClicked();
            return true;
        }
        if (pKeyCode == 69 && Screen.hasControlDown() && this.editButton.visible) {
            this.onEditButtonClicked();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public ChatFormatting getMillisecondColour(float ms) {
        if (ms <= 5.0f) {
            return ChatFormatting.GREEN;
        }
        if (ms <= 15.0f) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.RED;
    }

    public void render(GuiGraphics graphics, int mx, int my, float partialTicks) {
        this.renderTransparentBackground(graphics);
        super.render(graphics, mx, my, partialTicks);
        this.renderTooltip(graphics, mx, my);
        this.updateVisibilities();
        this.statusCountdown -= partialTicks;
    }

    protected void init() {
        super.init();
        int buttonWidth = 120;
        int buttonHeight = 16;
        this.clipboardPasteButton = (Button)this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition((this.width - this.imageWidth) / 2 - buttonWidth, (this.height - this.imageHeight) / 2 + 16).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.MANAGER_GUI_PASTE_FROM_CLIPBOARD_BUTTON).setOnPress(button -> this.onClipboardPasteButtonClicked()).setTooltip((Screen)this, this.font, LocalizationKeys.MANAGER_GUI_PASTE_FROM_CLIPBOARD_BUTTON_TOOLTIP).build());
        this.editButton = (Button)this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition((this.width - this.imageWidth) / 2 - buttonWidth, (this.height - this.imageHeight) / 2 + 16 + 50).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.MANAGER_GUI_EDIT_BUTTON).setOnPress(button -> this.onEditButtonClicked()).setTooltip((Screen)this, this.font, LocalizationKeys.MANAGER_GUI_EDIT_BUTTON_TOOLTIP).build());
        this.examplesButton = (Button)this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition((this.width - this.imageWidth) / 2 - buttonWidth, (this.height - this.imageHeight) / 2 + 32 + 50).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.MANAGER_GUI_VIEW_EXAMPLES_BUTTON).setOnPress(button -> this.onExamplesButtonClicked()).setTooltip((Screen)this, this.font, LocalizationKeys.MANAGER_GUI_VIEW_EXAMPLES_BUTTON_TOOLTIP).build());
        this.discordButton = (Button)this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition((this.width - this.imageWidth) / 2 - buttonWidth, (this.height - this.imageHeight) / 2 + 112).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.MANAGER_GUI_DISCORD_BUTTON).setOnPress(button -> this.onDiscordButtonClicked()).build());
        this.clipboardCopyButton = (Button)this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition((this.width - this.imageWidth) / 2 - buttonWidth, (this.height - this.imageHeight) / 2 + 128).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.MANAGER_GUI_COPY_TO_CLIPBOARD_BUTTON).setOnPress(button -> this.onClipboardCopyButtonClicked()).build());
        this.logsButton = (Button)this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition((this.width - this.imageWidth) / 2 - buttonWidth, (this.height - this.imageHeight) / 2 + 144).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.MANAGER_GUI_VIEW_LOGS_BUTTON).setOnPress(button -> this.onLogsButtonClicked()).build());
        this.rebuildButton = (Button)this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition((this.width - this.imageWidth) / 2 - buttonWidth, (this.height - this.imageHeight) / 2 + 160).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.MANAGER_GUI_REBUILD_BUTTON).setOnPress(button -> this.onRebuildButtonClicked()).build());
        this.serverConfigButton = (Button)this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition((this.width - this.imageWidth) / 2 - buttonWidth, (this.height - this.imageHeight) / 2 + 176).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.MANAGER_GUI_SERVER_CONFIG_BUTTON).setOnPress(button -> this.onServerConfigButtonClicked()).build());
        this.resetButton = (Button)this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition((this.width - this.imageWidth) / 2 + 120, (this.height - this.imageHeight) / 2 + 10).setSize(50, 12).setText(LocalizationKeys.MANAGER_GUI_RESET_BUTTON).setOnPress(button -> this.onResetButtonClicked()).setTooltip((Screen)this, this.font, LocalizationKeys.MANAGER_GUI_RESET_BUTTON_TOOLTIP).build());
        this.diagButton = (Button)this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition((this.width - this.imageWidth) / 2 + 35, (this.height - this.imageHeight) / 2 + 48).setSize(12, 14).setText((Component)Component.literal((String)"!")).setOnPress(button -> this.onDiagButtonClicked()).setTooltip((Screen)this, this.font, this.isReadOnly() ? LocalizationKeys.MANAGER_GUI_WARNING_BUTTON_TOOLTIP_READ_ONLY : LocalizationKeys.MANAGER_GUI_WARNING_BUTTON_TOOLTIP).build());
        this.updateVisibilities();
    }

    private void onDiagButtonClicked() {
        if (Screen.hasShiftDown() && !this.isReadOnly()) {
            this.sendAttemptFix();
        } else {
            this.onSaveDiagnosticsToClipboard();
        }
    }

    private String getProgram() {
        return ((ManagerContainerMenu)this.menu).program;
    }

    private void onEditButtonClicked() {
        SFMScreenChangeHelpers.showProgramEditScreen(new ProgramEditScreenOpenContext(this.getProgram(), LabelPositionHolder.from(((ManagerContainerMenu)this.menu).getDisk()), this::sendProgram));
    }

    private void onExamplesButtonClicked() {
        SFMScreenChangeHelpers.showExampleListScreen(this.getProgram(), LabelPositionHolder.from(((ManagerContainerMenu)this.menu).getDisk()), this::sendProgram);
    }

    private void onLogsButtonClicked() {
        SFMScreenChangeHelpers.showLogsScreen((ManagerContainerMenu)this.menu);
    }

    private void performReset() {
        SFMPackets.sendToServer(new ServerboundManagerResetPacket(((ManagerContainerMenu)this.menu).containerId, ((ManagerContainerMenu)this.menu).MANAGER_POSITION));
        this.status = LocalizationKeys.MANAGER_GUI_STATUS_RESET.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void onResetButtonClicked() {
        if (this.getProgram().isBlank() && LabelPositionHolder.from(((ManagerContainerMenu)this.menu).getDisk()).isEmpty()) {
            this.performReset();
            return;
        }
        ConfirmScreen confirmScreen = new ConfirmScreen(proceed -> {
            SFMScreenChangeHelpers.popScreen();
            if (proceed) {
                this.performReset();
            }
        }, (Component)LocalizationKeys.MANAGER_RESET_CONFIRM_SCREEN_TITLE.getComponent(), (Component)LocalizationKeys.MANAGER_RESET_CONFIRM_SCREEN_MESSAGE.getComponent(), (Component)LocalizationKeys.MANAGER_RESET_CONFIRM_SCREEN_YES_BUTTON.getComponent(), (Component)LocalizationKeys.MANAGER_RESET_CONFIRM_SCREEN_NO_BUTTON.getComponent());
        SFMScreenChangeHelpers.setOrPushScreen((Screen)confirmScreen);
        confirmScreen.setDelay(20);
    }

    private void onRebuildButtonClicked() {
        SFMPackets.sendToServer(new ServerboundManagerRebuildPacket(((ManagerContainerMenu)this.menu).containerId, ((ManagerContainerMenu)this.menu).MANAGER_POSITION));
        this.status = LocalizationKeys.MANAGER_GUI_STATUS_REBUILD.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void onServerConfigButtonClicked() {
        SFMPackets.sendToServer(new ServerboundServerConfigRequestPacket(ConfigCommandBehaviourInput.SHOW));
    }

    private void sendAttemptFix() {
        SFMPackets.sendToServer(new ServerboundManagerFixPacket(((ManagerContainerMenu)this.menu).containerId, ((ManagerContainerMenu)this.menu).MANAGER_POSITION));
        this.status = LocalizationKeys.MANAGER_GUI_STATUS_FIX.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void sendProgram(String program) {
        program = SFMPacketDaddy.truncate(program, 32367);
        SFMPackets.sendToServer(new ServerboundManagerProgramPacket(((ManagerContainerMenu)this.menu).containerId, ((ManagerContainerMenu)this.menu).MANAGER_POSITION, program));
        ((ManagerContainerMenu)this.menu).program = program;
        this.status = LocalizationKeys.MANAGER_GUI_STATUS_LOADED_CLIPBOARD.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void onDiscordButtonClicked() {
        String discordUrl = "https://discord.gg/xjXYj9MmS4";
        SFMScreenChangeHelpers.setOrPushScreen((Screen)new ConfirmLinkScreen(proceed -> {
            if (proceed) {
                Util.getPlatform().openUri(discordUrl);
            }
            SFMScreenChangeHelpers.popScreen();
        }, discordUrl, false));
    }

    private void onClipboardCopyButtonClicked() {
        try {
            Minecraft.getInstance().keyboardHandler.setClipboard(((ManagerContainerMenu)this.menu).program);
            this.status = LocalizationKeys.MANAGER_GUI_STATUS_SAVED_CLIPBOARD.getComponent();
            this.statusCountdown = 40.0f;
        }
        catch (Throwable t) {
            SFM.LOGGER.error("failed to save clipboard", t);
        }
    }

    private boolean shouldShowDiagButton() {
        ItemStack disk = ((ManagerContainerMenu)this.menu).getDisk();
        if (!(disk.getItem() instanceof DiskItem)) {
            return false;
        }
        List<Component> errors = DiskItem.getErrors(disk);
        List<Component> warnings = DiskItem.getWarnings(disk);
        return !errors.isEmpty() || !warnings.isEmpty();
    }

    private void onSaveDiagnosticsToClipboard() {
        try {
            ItemStack disk = ((ManagerContainerMenu)this.menu).CONTAINER.getItem(0);
            if (!(disk.getItem() instanceof DiskItem)) {
                return;
            }
            String diagnosticInfo = SFMDiagnostics.getDiagnosticsSummary(disk);
            Minecraft.getInstance().keyboardHandler.setClipboard(diagnosticInfo);
            this.status = LocalizationKeys.MANAGER_GUI_STATUS_SAVED_CLIPBOARD.getComponent();
            this.statusCountdown = 40.0f;
        }
        catch (Throwable t) {
            SFM.LOGGER.error("failed saving clipboard", t);
        }
    }

    private void onClipboardPasteButtonClicked() {
        boolean shouldConfirm;
        String clipboardContents;
        try {
            clipboardContents = Minecraft.getInstance().keyboardHandler.getClipboard();
        }
        catch (Throwable t) {
            SFM.LOGGER.error("failed loading clipboard", t);
            return;
        }
        String existingProgram = this.getProgram();
        boolean bl = shouldConfirm = !existingProgram.isBlank() && !existingProgram.equals(clipboardContents);
        if (!shouldConfirm) {
            this.sendProgram(clipboardContents);
            return;
        }
        ConfirmScreen confirmScreen = new ConfirmScreen(proceed -> {
            SFMScreenChangeHelpers.popScreen();
            if (proceed) {
                this.sendProgram(clipboardContents);
            }
        }, (Component)LocalizationKeys.MANAGER_PASTE_CONFIRM_SCREEN_TITLE.getComponent(), (Component)LocalizationKeys.MANAGER_PASTE_CONFIRM_SCREEN_MESSAGE.getComponent(), (Component)LocalizationKeys.MANAGER_PASTE_CONFIRM_SCREEN_YES_BUTTON.getComponent(), (Component)LocalizationKeys.MANAGER_PASTE_CONFIRM_SCREEN_NO_BUTTON.getComponent());
        SFMScreenChangeHelpers.setOrPushScreen((Screen)confirmScreen);
        confirmScreen.setDelay(20);
    }

    @MCVersionDependentBehaviour
    private void disableTexture() {
    }

    protected void renderLabels(GuiGraphics graphics, int mx, int my) {
        PoseStack poseStack = graphics.pose();
        super.renderLabels(graphics, mx, my);
        ManagerBlockEntity.State state = ((ManagerContainerMenu)this.menu).state;
        SFMFontUtils.draw(graphics, this.font, (Component)LocalizationKeys.MANAGER_GUI_STATE.getComponent(state.LOC.getComponent().withStyle(state.COLOR)), this.titleLabelX, 20, 0, false);
        if (!((ManagerContainerMenu)this.menu).logLevel.equals(Level.OFF.name())) {
            poseStack.pushPose();
            double d = this.titleLabelX;
            Objects.requireNonNull(this.font);
            poseStack.translate(d, 9.0 * 1.5, 0.0);
            poseStack.scale(0.5f, 0.5f, 1.0f);
            SFMFontUtils.draw(graphics, this.font, (Component)Component.literal((String)((ManagerContainerMenu)this.menu).logLevel), 0, 0, 0, false);
            poseStack.popPose();
        }
        if (this.statusCountdown > 0.0f) {
            SFMFontUtils.draw(graphics, this.font, this.status, this.inventoryLabelX + this.font.width(this.playerInventoryTitle.getString()) + 5, this.inventoryLabelY, 0, false);
        }
        long peakTickTimeNanoseconds = 0L;
        for (int i = 0; i < ((ManagerContainerMenu)this.menu).tickTimeNanos.length; ++i) {
            peakTickTimeNanoseconds = Long.max(peakTickTimeNanoseconds, ((ManagerContainerMenu)this.menu).tickTimeNanos[i]);
        }
        long yMax = Long.max(peakTickTimeNanoseconds, 50000000L);
        int plotX = this.titleLabelX + 45;
        int plotY = 40;
        int spaceBetweenPoints = 6;
        int plotWidth = 6 * (((ManagerContainerMenu)this.menu).tickTimeNanos.length - 1);
        int plotHeight = 30;
        this.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        Matrix4f pose = graphics.pose().last().pose();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        bufferbuilder.addVertex(pose, (float)plotX, 40.0f, 0.0f).setColor(0.0f, 0.0f, 0.0f, 0.5f);
        bufferbuilder.addVertex(pose, (float)(plotX + plotWidth), 40.0f, 0.0f).setColor(0.0f, 0.0f, 0.0f, 0.5f);
        bufferbuilder.addVertex(pose, (float)(plotX + plotWidth), 70.0f, 0.0f).setColor(0.0f, 0.0f, 0.0f, 0.5f);
        bufferbuilder.addVertex(pose, (float)plotX, 70.0f, 0.0f).setColor(0.0f, 0.0f, 0.0f, 0.5f);
        bufferbuilder.addVertex(pose, (float)plotX, 40.0f, 0.0f).setColor(0.0f, 0.0f, 0.0f, 0.5f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        bufferbuilder = tesselator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        int mouseTickTimeIndex = -1;
        for (int i = 0; i < ((ManagerContainerMenu)this.menu).tickTimeNanos.length; ++i) {
            long y = ((ManagerContainerMenu)this.menu).tickTimeNanos[i];
            float normalizedTickTime = y == 0L ? 0.0f : (float)(Math.log10(y) / Math.log10(yMax));
            int plotPosY = 70 - (int)(normalizedTickTime * 30.0f);
            int plotPosX = plotX + 6 * i;
            ChatFormatting c = this.getMillisecondColour((float)y / 1000000.0f);
            float red = (float)(c.getColor() >> 16 & 0xFF) / 255.0f;
            float green = (float)(c.getColor() >> 8 & 0xFF) / 255.0f;
            float blue = (float)(c.getColor() & 0xFF) / 255.0f;
            bufferbuilder.addVertex(pose, (float)plotPosX, (float)plotPosY, this.getBlitOffsetGood()).setColor(red, green, blue, 1.0f);
            if (mx - this.leftPos < plotPosX - 3 || mx - this.leftPos > plotPosX + 3 || my - this.topPos < 38 || my - this.topPos > 72) continue;
            mouseTickTimeIndex = i;
        }
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        DecimalFormat format = new DecimalFormat("0.000");
        if (mouseTickTimeIndex != -1) {
            long hoveredTickTimeNanoseconds = ((ManagerContainerMenu)this.menu).tickTimeNanos[mouseTickTimeIndex];
            float hoveredTickTimeMilliseconds = (float)hoveredTickTimeNanoseconds / 1000000.0f;
            String formattedMillis = format.format(hoveredTickTimeMilliseconds);
            ChatFormatting lagColor = this.getMillisecondColour(hoveredTickTimeMilliseconds);
            MutableComponent milliseconds = Component.literal((String)formattedMillis).withStyle(lagColor);
            MutableComponent mutableComponent = LocalizationKeys.MANAGER_GUI_HOVERED_TICK_TIME_MS.getComponent(milliseconds);
            Objects.requireNonNull(this.font);
            SFMFontUtils.draw(graphics, this.font, (Component)mutableComponent, this.titleLabelX, 20 + 9, 0, false);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            tesselator = Tesselator.getInstance();
            bufferbuilder = tesselator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            pose = graphics.pose().last().pose();
            int x = plotX + 6 * mouseTickTimeIndex;
            bufferbuilder.addVertex(pose, (float)x, 40.0f, this.getBlitOffsetGood()).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            bufferbuilder.addVertex(pose, (float)x, 70.0f, this.getBlitOffsetGood()).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        } else {
            float peakTickTimeMilliseconds = (float)peakTickTimeNanoseconds / 1000000.0f;
            String formattedMillis = format.format(peakTickTimeMilliseconds);
            ChatFormatting lagColor = this.getMillisecondColour(peakTickTimeMilliseconds);
            MutableComponent milliseconds = Component.literal((String)formattedMillis).withStyle(lagColor);
            MutableComponent mutableComponent = LocalizationKeys.MANAGER_GUI_PEAK_TICK_TIME_MS.getComponent(milliseconds);
            Objects.requireNonNull(this.font);
            SFMFontUtils.draw(graphics, this.font, (Component)mutableComponent, this.titleLabelX, 20 + 9, 0, false);
        }
        RenderSystem.disableBlend();
        this.enableTexture();
    }

    @MCVersionDependentBehaviour
    private void enableTexture() {
    }

    @MCVersionDependentBehaviour
    public float getBlitOffsetGood() {
        return 0.0f;
    }

    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        if (Minecraft.getInstance().screen != this) {
            this.renderables.stream().filter(AbstractWidget.class::isInstance).map(AbstractWidget.class::cast).forEach(w -> w.setFocused(false));
            return;
        }
        this.drawChildTooltips(pGuiGraphics, pX, pY);
        super.renderTooltip(pGuiGraphics, pX, pY);
    }

    @MCVersionDependentBehaviour
    private void drawChildTooltips(GuiGraphics guiGraphics, int mx, int my) {
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mx, int my) {
        if (!((ManagerContainerMenu)this.menu).logLevel.equals(Level.OFF.name())) {
            RenderSystem.setShaderColor((float)0.2f, (float)0.8f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        graphics.blit(BACKGROUND_TEXTURE_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
    }
}

