/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.fluid;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.fluid.FluidHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecs;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract sealed class FluidIngredient
implements Predicate<FluidStack> {
    public static final FluidIngredient EMPTY = new FluidStackIngredient();
    public static final Codec<FluidIngredient> CODEC = Type.CODEC.dispatch(FluidIngredient::getType, type -> type.codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidIngredient> STREAM_CODEC = Type.STREAM_CODEC.dispatch(FluidIngredient::getType, type -> type.streamCodec);
    public List<FluidStack> matchingFluidStacks;
    protected int amountRequired;

    public static FluidIngredient fromTag(TagKey<Fluid> tag, int amount) {
        return new FluidTagIngredient(tag, amount);
    }

    public static FluidIngredient fromFluid(Fluid fluid, int amount) {
        FluidStackIngredient ingredient = new FluidStackIngredient(fluid, amount);
        ingredient.fixFlowing();
        return ingredient;
    }

    public static FluidIngredient fromFluidStack(FluidStack fluidStack) {
        FluidStackIngredient ingredient = new FluidStackIngredient(fluidStack.getFluid(), fluidStack.getAmount());
        ingredient.fixFlowing();
        if (!fluidStack.isComponentsPatchEmpty()) {
            ingredient.components = fluidStack.getComponentsPatch();
        }
        return ingredient;
    }

    public int getRequiredAmount() {
        return this.amountRequired;
    }

    protected abstract boolean testInternal(FluidStack var1);

    protected abstract void readInternal(RegistryFriendlyByteBuf var1);

    protected abstract void writeInternal(RegistryFriendlyByteBuf var1);

    protected abstract List<FluidStack> determineMatchingFluidStacks();

    protected abstract Type getType();

    public List<FluidStack> getMatchingFluidStacks() {
        if (this.matchingFluidStacks != null) {
            return this.matchingFluidStacks;
        }
        this.matchingFluidStacks = this.determineMatchingFluidStacks();
        return this.matchingFluidStacks;
    }

    @Override
    public boolean test(FluidStack t) {
        if (t == null) {
            throw new IllegalArgumentException("FluidStack cannot be null");
        }
        return this.testInternal(t);
    }

    public static void write(RegistryFriendlyByteBuf buffer, FluidIngredient ingredient) {
        buffer.writeBoolean(ingredient instanceof FluidTagIngredient);
        buffer.writeVarInt(ingredient.amountRequired);
        ingredient.writeInternal(buffer);
    }

    public static FluidIngredient read(RegistryFriendlyByteBuf buffer) {
        boolean isTagIngredient = buffer.readBoolean();
        FluidIngredient ingredient = isTagIngredient ? new FluidTagIngredient() : new FluidStackIngredient();
        ingredient.amountRequired = buffer.readVarInt();
        ingredient.readInternal(buffer);
        return ingredient;
    }

    public static final class FluidTagIngredient
    extends FluidIngredient {
        public static final MapCodec<FluidTagIngredient> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)TagKey.codec((ResourceKey)Registries.FLUID).fieldOf("fluid_tag").forGetter(fti -> fti.tag), (App)Codec.INT.fieldOf("amount").forGetter(fti -> fti.amountRequired)).apply((Applicative)i, FluidTagIngredient::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidTagIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, i -> i.tag.location(), (StreamCodec)ByteBufCodecs.VAR_INT, i -> i.amountRequired, (tag, amount) -> new FluidTagIngredient((TagKey<Fluid>)TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)tag), (int)amount));
        private TagKey<Fluid> tag;

        public FluidTagIngredient() {
        }

        public FluidTagIngredient(TagKey<Fluid> tag, int amountRequired) {
            this.tag = tag;
            this.amountRequired = amountRequired;
        }

        @Override
        protected boolean testInternal(FluidStack t) {
            if (this.tag != null) {
                return FluidHelper.isTag(t, this.tag);
            }
            for (FluidStack accepted : this.getMatchingFluidStacks()) {
                if (!FluidHelper.isSame(accepted, t)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void readInternal(RegistryFriendlyByteBuf buffer) {
            this.matchingFluidStacks = (List)FluidStack.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)buffer);
        }

        @Override
        protected void writeInternal(RegistryFriendlyByteBuf buffer) {
            FluidStack.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)buffer, this.getMatchingFluidStacks());
        }

        @Override
        protected List<FluidStack> determineMatchingFluidStacks() {
            ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
            for (Holder holder : BuiltInRegistries.FLUID.getTagOrEmpty(this.tag)) {
                Fluid f = (Fluid)holder.value();
                if (f instanceof FlowingFluid) {
                    FlowingFluid flowing = (FlowingFluid)f;
                    f = flowing.getSource();
                }
                stacks.add(new FluidStack(f, this.amountRequired));
            }
            return stacks;
        }

        @Override
        protected Type getType() {
            return Type.FLUID_TAG;
        }
    }

    public static final class FluidStackIngredient
    extends FluidIngredient {
        private static final Codec<Fluid> FLUID_NON_AIR_CODEC = BuiltInRegistries.FLUID.byNameCodec().validate(fluid -> fluid == Fluids.EMPTY ? DataResult.error(() -> "Fluid must not be minecraft:empty") : DataResult.success((Object)fluid));
        public static final MapCodec<FluidStackIngredient> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)FLUID_NON_AIR_CODEC.fieldOf("fluid").forGetter(fsi -> fsi.fluid), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(fsi -> fsi.components), (App)Codec.INT.fieldOf("amount").forGetter(fti -> fti.amountRequired)).apply((Applicative)i, FluidStackIngredient::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidStackIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)CatnipStreamCodecs.FLUID, i -> i.fluid, (StreamCodec)DataComponentPatch.STREAM_CODEC, i -> i.components, (StreamCodec)ByteBufCodecs.VAR_INT, i -> i.amountRequired, FluidStackIngredient::new);
        private Fluid fluid;
        private DataComponentPatch components;

        public FluidStackIngredient() {
            this.components = DataComponentPatch.EMPTY;
        }

        public FluidStackIngredient(Fluid fluid, DataComponentPatch tagToMatch, int amountRequired) {
            this.fluid = fluid;
            this.components = tagToMatch;
            this.amountRequired = amountRequired;
        }

        public FluidStackIngredient(Fluid fluid, int amountRequired) {
            this.fluid = fluid;
            this.components = DataComponentPatch.EMPTY;
            this.amountRequired = amountRequired;
        }

        void fixFlowing() {
            Fluid fluid = this.fluid;
            if (fluid instanceof FlowingFluid) {
                FlowingFluid flowingFluid = (FlowingFluid)fluid;
                this.fluid = flowingFluid.getSource();
            }
        }

        @Override
        protected boolean testInternal(FluidStack t) {
            if (!FluidHelper.isSame(t, this.fluid)) {
                return false;
            }
            if (this.components.isEmpty()) {
                return true;
            }
            DataComponentPatch tag = t.getComponentsPatch();
            HashSet referenceSet = new HashSet(tag.entrySet());
            referenceSet.addAll(this.components.entrySet());
            return referenceSet.equals(tag.entrySet());
        }

        @Override
        protected void readInternal(RegistryFriendlyByteBuf buffer) {
            this.fluid = (Fluid)ByteBufCodecs.registry((ResourceKey)Registries.FLUID).decode((Object)buffer);
            this.components = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode((Object)buffer);
        }

        @Override
        protected void writeInternal(RegistryFriendlyByteBuf buffer) {
            ByteBufCodecs.registry((ResourceKey)Registries.FLUID).encode((Object)buffer, (Object)this.fluid);
            DataComponentPatch.STREAM_CODEC.encode((Object)buffer, (Object)this.components);
        }

        @Override
        protected List<FluidStack> determineMatchingFluidStacks() {
            return ImmutableList.of((Object)(this.components.isEmpty() ? new FluidStack(this.fluid, this.amountRequired) : new FluidStack(BuiltInRegistries.FLUID.wrapAsHolder((Object)this.fluid), this.amountRequired, this.components)));
        }

        @Override
        protected Type getType() {
            return Type.FLUID_STACK;
        }
    }

    protected static enum Type implements StringRepresentable
    {
        FLUID_STACK(FluidStackIngredient.CODEC, FluidStackIngredient.STREAM_CODEC),
        FLUID_TAG(FluidTagIngredient.CODEC, FluidTagIngredient.STREAM_CODEC);

        public static final Codec<Type> CODEC;
        public static final StreamCodec<RegistryFriendlyByteBuf, Type> STREAM_CODEC;
        private final MapCodec<? extends FluidIngredient> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, ? extends FluidIngredient> streamCodec;

        private Type(MapCodec<? extends FluidIngredient> codec, StreamCodec<RegistryFriendlyByteBuf, ? extends FluidIngredient> streamCodec) {
            this.codec = codec;
            this.streamCodec = streamCodec;
        }

        @NotNull
        public String getSerializedName() {
            return Lang.asId((String)this.name());
        }

        static {
            CODEC = StringRepresentable.fromValues(Type::values);
            STREAM_CODEC = CatnipStreamCodecBuilders.ofEnum(Type.class);
        }
    }
}

