/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.block;

import codechicken.lib.render.block.CCBlockRendererDispatcher;
import codechicken.lib.render.block.ICCBlockRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class BlockRenderingRegistry {
    private static boolean initialized = false;
    private static final Map<Block, ICCBlockRenderer> blockRenderers = new HashMap<Block, ICCBlockRenderer>();
    private static final Map<Fluid, ICCBlockRenderer> fluidRenderers = new HashMap<Fluid, ICCBlockRenderer>();
    private static final List<ICCBlockRenderer> globalRenderers = new ArrayList<ICCBlockRenderer>();

    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        if (!initialized) {
            Minecraft mc = Minecraft.getInstance();
            BlockRenderDispatcher parentDispatcher = mc.getBlockRenderer();
            mc.blockRenderer = new CCBlockRendererDispatcher(parentDispatcher, mc.getBlockColors());
            initialized = true;
        }
    }

    public static synchronized void registerRenderer(Block block, ICCBlockRenderer renderer) {
        ICCBlockRenderer prev = blockRenderers.get(block);
        if (prev != null) {
            throw new IllegalArgumentException("Renderer already registered for block. " + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)block)));
        }
        blockRenderers.put(block, renderer);
    }

    public static synchronized void registerRenderer(Fluid fluid, ICCBlockRenderer renderer) {
        ICCBlockRenderer prev = fluidRenderers.get(fluid);
        if (prev != null) {
            throw new IllegalArgumentException("Renderer already registered for fluid. " + String.valueOf(BuiltInRegistries.FLUID.getKey((Object)fluid)));
        }
        fluidRenderers.put(fluid, renderer);
    }

    public static synchronized void registerGlobalRenderer(ICCBlockRenderer renderer) {
        globalRenderers.add(renderer);
    }

    @Nullable
    static ICCBlockRenderer findFor(Block block, Predicate<ICCBlockRenderer> pred) {
        for (ICCBlockRenderer renderer : globalRenderers) {
            if (!pred.test(renderer)) continue;
            return renderer;
        }
        ICCBlockRenderer found = blockRenderers.get(block);
        if (found != null && pred.test(found)) {
            return found;
        }
        return null;
    }

    @Nullable
    static ICCBlockRenderer findFor(Fluid fluid, Predicate<ICCBlockRenderer> pred) {
        for (ICCBlockRenderer renderer : globalRenderers) {
            if (!pred.test(renderer)) continue;
            return renderer;
        }
        ICCBlockRenderer found = fluidRenderers.get(fluid);
        if (found != null && pred.test(found)) {
            return found;
        }
        return null;
    }
}

