/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;

public class RenderUtils {
    private static final Vector3[] vectors = new Vector3[8];

    public static RenderType getFluidRenderType() {
        return RenderType.create((String)"ccl:fluid_render", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderType.POSITION_COLOR_TEX_LIGHTMAP_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderType.BLOCK_SHEET).setTransparencyState(RenderType.TRANSLUCENT_TRANSPARENCY).setLightmapState(RenderType.LIGHTMAP).createCompositeState(false));
    }

    public static void renderFluidCuboid(CCRenderState ccrs, Matrix4 mat, RenderType renderType, MultiBufferSource source, FluidStack stack, Cuboid6 bound, double capacity, double res) {
        if (stack.isEmpty()) {
            return;
        }
        int alpha = 255;
        FluidType type = stack.getFluid().getFluidType();
        if (type.isLighterThanAir()) {
            alpha = (int)(Math.pow(capacity, 0.4) * 255.0);
        } else {
            bound.max.y = bound.min.y + (bound.max.y - bound.min.y) * capacity;
        }
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((FluidType)type);
        Material material = ClientHooks.getBlockMaterial((ResourceLocation)props.getStillTexture(stack));
        ccrs.bind(renderType, source);
        ccrs.baseColour = props.getTintColor(stack) << 8 | alpha;
        RenderUtils.makeFluidModel(bound, material.sprite(), res).render(ccrs, mat);
    }

    public static CCModel makeFluidModel(Cuboid6 bound, TextureAtlasSprite tex, double res) {
        CCModel model = CCModel.newModel(VertexFormat.Mode.QUADS);
        ArrayList<Vertex5> verts = new ArrayList<Vertex5>();
        RenderUtils.makeFluidCuboid(verts, bound, tex, res);
        model.verts = verts.toArray(new Vertex5[0]);
        return model;
    }

    public static void makeFluidCuboid(List<Vertex5> vertices, Cuboid6 bound, TextureAtlasSprite tex, double res) {
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), tex, res);
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), tex, res);
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.max.x, bound.max.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), tex, res);
    }

    public static void makeFluidQuadVertices(List<Vertex5> vertices, Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4, TextureAtlasSprite icon, double res) {
        RenderUtils.makeFluidQuadVertices(vertices, point2, vectors[0].set(point4).subtract(point1), vectors[1].set(point1).subtract(point2), icon, res);
    }

    public static void makeFluidQuadVertices(List<Vertex5> vertices, Vector3 base, Vector3 wide, Vector3 high, TextureAtlasSprite icon, double res) {
        double rx;
        Vector3 a = new Vector3();
        Vector3 b = new Vector3();
        Vector3 c = new Vector3();
        Vector3 d = new Vector3();
        double u1 = icon.getU0();
        double du = icon.getU1() - icon.getU0();
        double v2 = icon.getV1();
        double dv = icon.getV1() - icon.getV0();
        double wlen = wide.mag();
        double hlen = high.mag();
        for (double x = 0.0; x < wlen; x += rx) {
            double ry;
            rx = wlen - x;
            if (rx > res) {
                rx = res;
            }
            for (double y = 0.0; y < hlen; y += ry) {
                ry = hlen - y;
                if (ry > res) {
                    ry = res;
                }
                Vector3 dx1 = a.set(wide).multiply(x / wlen);
                Vector3 dx2 = b.set(wide).multiply((x + rx) / wlen);
                Vector3 dy1 = c.set(high).multiply(y / hlen);
                Vector3 dy2 = d.set(high).multiply((y + ry) / hlen);
                vertices.add(new Vertex5(base.x + dx1.x + dy2.x, base.y + dx1.y + dy2.y, base.z + dx1.z + dy2.z, u1, v2 - ry / res * dv));
                vertices.add(new Vertex5(base.x + dx1.x + dy1.x, base.y + dx1.y + dy1.y, base.z + dx1.z + dy1.z, u1, v2));
                vertices.add(new Vertex5(base.x + dx2.x + dy1.x, base.y + dx2.y + dy1.y, base.z + dx2.z + dy1.z, u1 + rx / res * du, v2));
                vertices.add(new Vertex5(base.x + dx2.x + dy2.x, base.y + dx2.y + dy2.y, base.z + dx2.z + dy2.z, u1 + rx / res * du, v2 - ry / res * dv));
            }
        }
    }

    public static void bufferCuboidSolid(VertexConsumer builder, Cuboid6 c, float r, float g, float b, float a) {
        builder.addVertex((float)c.min.x, (float)c.max.y, (float)c.min.z).setColor(r, g, b, a);
        builder.addVertex((float)c.max.x, (float)c.max.y, (float)c.min.z).setColor(r, g, b, a);
        builder.addVertex((float)c.max.x, (float)c.min.y, (float)c.min.z).setColor(r, g, b, a);
        builder.addVertex((float)c.min.x, (float)c.min.y, (float)c.min.z).setColor(r, g, b, a);
        builder.addVertex((float)c.min.x, (float)c.min.y, (float)c.max.z).setColor(r, g, b, a);
        builder.addVertex((float)c.max.x, (float)c.min.y, (float)c.max.z).setColor(r, g, b, a);
        builder.addVertex((float)c.max.x, (float)c.max.y, (float)c.max.z).setColor(r, g, b, a);
        builder.addVertex((float)c.min.x, (float)c.max.y, (float)c.max.z).setColor(r, g, b, a);
        builder.addVertex((float)c.min.x, (float)c.min.y, (float)c.min.z).setColor(r, g, b, a);
        builder.addVertex((float)c.max.x, (float)c.min.y, (float)c.min.z).setColor(r, g, b, a);
        builder.addVertex((float)c.max.x, (float)c.min.y, (float)c.max.z).setColor(r, g, b, a);
        builder.addVertex((float)c.min.x, (float)c.min.y, (float)c.max.z).setColor(r, g, b, a);
        builder.addVertex((float)c.min.x, (float)c.max.y, (float)c.max.z).setColor(r, g, b, a);
        builder.addVertex((float)c.max.x, (float)c.max.y, (float)c.max.z).setColor(r, g, b, a);
        builder.addVertex((float)c.max.x, (float)c.max.y, (float)c.min.z).setColor(r, g, b, a);
        builder.addVertex((float)c.min.x, (float)c.max.y, (float)c.min.z).setColor(r, g, b, a);
        builder.addVertex((float)c.min.x, (float)c.min.y, (float)c.max.z).setColor(r, g, b, a);
        builder.addVertex((float)c.min.x, (float)c.max.y, (float)c.max.z).setColor(r, g, b, a);
        builder.addVertex((float)c.min.x, (float)c.max.y, (float)c.min.z).setColor(r, g, b, a);
        builder.addVertex((float)c.min.x, (float)c.min.y, (float)c.min.z).setColor(r, g, b, a);
        builder.addVertex((float)c.max.x, (float)c.min.y, (float)c.min.z).setColor(r, g, b, a);
        builder.addVertex((float)c.max.x, (float)c.max.y, (float)c.min.z).setColor(r, g, b, a);
        builder.addVertex((float)c.max.x, (float)c.max.y, (float)c.max.z).setColor(r, g, b, a);
        builder.addVertex((float)c.max.x, (float)c.min.y, (float)c.max.z).setColor(r, g, b, a);
    }

    public static void bufferHitbox(Matrix4 mat, MultiBufferSource getter, Camera renderInfo, Cuboid6 cuboid) {
        Vec3 projectedView = renderInfo.getPosition();
        RenderUtils.bufferHitBox(mat.copy().translate(-projectedView.x, -projectedView.y, -projectedView.z), getter, cuboid);
    }

    public static void bufferHitBox(Matrix4 mat, MultiBufferSource getter, Cuboid6 cuboid) {
        TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.getBuffer(RenderType.lines()), mat);
        RenderUtils.bufferCuboidOutline(builder, cuboid.copy().expand(0.002f), 0.0f, 0.0f, 0.0f, 0.4f);
    }

    public static void bufferCuboidOutline(VertexConsumer builder, Cuboid6 c, float r, float g, float b, float a) {
        RenderUtils.bufferLinePair(builder, c.min.x, c.min.y, c.min.z, c.max.x, c.min.y, c.min.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.max.x, c.min.y, c.min.z, c.max.x, c.min.y, c.max.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.max.x, c.min.y, c.max.z, c.min.x, c.min.y, c.max.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.min.x, c.min.y, c.max.z, c.min.x, c.min.y, c.min.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.min.x, c.max.y, c.min.z, c.max.x, c.max.y, c.min.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.max.x, c.max.y, c.min.z, c.max.x, c.max.y, c.max.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.max.x, c.max.y, c.max.z, c.min.x, c.max.y, c.max.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.min.x, c.max.y, c.max.z, c.min.x, c.max.y, c.min.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.min.x, c.min.y, c.min.z, c.min.x, c.max.y, c.min.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.max.x, c.min.y, c.min.z, c.max.x, c.max.y, c.min.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.max.x, c.min.y, c.max.z, c.max.x, c.max.y, c.max.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.min.x, c.min.y, c.max.z, c.min.x, c.max.y, c.max.z, r, g, b, a);
    }

    public static void bufferShapeHitBox(Matrix4 mat, MultiBufferSource buffers, Camera renderInfo, VoxelShape shape) {
        Vec3 projectedView = renderInfo.getPosition();
        RenderUtils.bufferShapeHitBox(mat.copy().translate(-projectedView.x, -projectedView.y, -projectedView.z), buffers, shape);
    }

    public static void bufferShapeHitBox(Matrix4 mat, MultiBufferSource buffers, VoxelShape shape) {
        TransformingVertexConsumer builder = new TransformingVertexConsumer(buffers.getBuffer(RenderType.lines()), mat);
        RenderUtils.bufferShapeOutline(builder, shape, 0.0f, 0.0f, 0.0f, 0.4f);
    }

    public static void bufferShapeOutline(VertexConsumer builder, VoxelShape shape, float r, float g, float b, float a) {
        shape.forAllEdges((x1, y1, z1, x2, y2, z2) -> RenderUtils.bufferLinePair(builder, x1, y1, z1, x2, y2, z2, r, g, b, a));
    }

    private static void bufferLinePair(VertexConsumer builder, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a) {
        Vector3 v1 = vectors[0].set(x1, y1, z1).subtract(x2, y2, z2);
        double d = v1.mag();
        v1.divide(d);
        builder.addVertex((float)x1, (float)y1, (float)z1).setColor(r, g, b, a).setNormal((float)v1.x, (float)v1.y, (float)v1.z);
        builder.addVertex((float)x2, (float)y2, (float)z2).setColor(r, g, b, a).setNormal((float)v1.x, (float)v1.y, (float)v1.z);
    }

    public static Matrix4 getMatrix(Matrix4 in, Vector3 translation, Rotation rotation, double scale) {
        return in.translate(translation).scale(scale).rotate(rotation);
    }

    @Deprecated
    public static Matrix4 getMatrix(Vector3 translation, Rotation rotation, double scale) {
        return RenderUtils.getMatrix(new Matrix4(), translation, rotation, scale);
    }

    public static float getPearlBob(double time) {
        return (float)Math.sin(time / 25.0 * 3.141593) * 0.1f;
    }

    public static int getTimeOffset(BlockPos pos) {
        return RenderUtils.getTimeOffset(pos.getX(), pos.getY(), pos.getZ());
    }

    public static int getTimeOffset(int x, int y, int z) {
        return x * 3 + y * 5 + z * 9;
    }

    static {
        for (int i = 0; i < vectors.length; ++i) {
            RenderUtils.vectors[i] = new Vector3();
        }
    }
}

