/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config;

import codechicken.lib.config.AbstractConfigTag;
import codechicken.lib.config.ConfigCategoryImpl;
import codechicken.lib.config.ConfigValueImpl;
import codechicken.lib.config.ConfigValueList;
import codechicken.lib.config.ListRestriction;
import codechicken.lib.config.ValueType;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanLists;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleLists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigValueListImpl
extends AbstractConfigTag<ConfigValueList>
implements ConfigValueList {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigValueListImpl.class);
    @Nullable
    private List<?> defaultValue = null;
    @Nullable
    private List<?> value = null;
    @Nullable
    private List<?> networkValue = null;
    private ValueType type = ValueType.UNKNOWN;
    @Nullable
    private ListRestriction restriction;

    public ConfigValueListImpl(String name, @Nullable ConfigCategoryImpl parent) {
        super(name, parent);
    }

    static ConfigValueList proxy(List<?> value, ValueType type) {
        ConfigValueListImpl list = new ConfigValueListImpl("proxy", null);
        list.setKnownType(type);
        list.setValue(value);
        return list;
    }

    @Override
    public ValueType getType() {
        return this.type;
    }

    @Override
    public BooleanList getBooleans() {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.BOOLEAN;
        }
        if (this.type != ValueType.BOOLEAN) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.networkValue != null) {
            return BooleanLists.unmodifiable((BooleanList)((BooleanList)SneakyUtils.unsafeCast(this.networkValue)));
        }
        this.value = this.tryConvert(this.value, this.type);
        if (this.value == null) {
            return this.getDefaultBooleans();
        }
        return BooleanLists.unmodifiable((BooleanList)((BooleanList)SneakyUtils.unsafeCast(this.value)));
    }

    @Override
    public List<String> getStrings() {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.STRING;
        }
        if (this.type != ValueType.STRING) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.networkValue != null) {
            return Collections.unmodifiableList((List)SneakyUtils.unsafeCast(this.networkValue));
        }
        this.value = this.tryConvert(this.value, this.type);
        if (this.value == null) {
            return this.getDefaultStrings();
        }
        return Collections.unmodifiableList((List)SneakyUtils.unsafeCast(this.value));
    }

    @Override
    public IntList getInts() {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.INT;
        }
        if (this.type != ValueType.INT) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.networkValue != null) {
            return IntLists.unmodifiable((IntList)((IntList)SneakyUtils.unsafeCast(this.networkValue)));
        }
        this.value = this.tryConvert(this.value, this.type);
        if (this.value == null) {
            return this.getDefaultInts();
        }
        return IntLists.unmodifiable((IntList)((IntList)SneakyUtils.unsafeCast(this.value)));
    }

    @Override
    public LongList getLongs() {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.LONG;
        }
        if (this.type != ValueType.LONG) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.networkValue != null) {
            return LongLists.unmodifiable((LongList)((LongList)SneakyUtils.unsafeCast(this.networkValue)));
        }
        this.value = this.tryConvert(this.value, this.type);
        if (this.value == null) {
            return this.getDefaultLongs();
        }
        return LongLists.unmodifiable((LongList)((LongList)SneakyUtils.unsafeCast(this.value)));
    }

    @Override
    public IntList getHexs() {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.HEX;
        }
        if (this.type != ValueType.HEX) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.networkValue != null) {
            return IntLists.unmodifiable((IntList)((IntList)SneakyUtils.unsafeCast(this.networkValue)));
        }
        this.value = this.tryConvert(this.value, this.type);
        if (this.value == null) {
            return this.getDefaultHexs();
        }
        return IntLists.unmodifiable((IntList)((IntList)SneakyUtils.unsafeCast(this.value)));
    }

    @Override
    public DoubleList getDoubles() {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.DOUBLE;
        }
        if (this.type != ValueType.DOUBLE) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.networkValue != null) {
            return DoubleLists.unmodifiable((DoubleList)((DoubleList)SneakyUtils.unsafeCast(this.networkValue)));
        }
        this.value = this.tryConvert(this.value, this.type);
        if (this.value == null) {
            return this.getDefaultDoubles();
        }
        return DoubleLists.unmodifiable((DoubleList)((DoubleList)SneakyUtils.unsafeCast(this.value)));
    }

    @Override
    public ConfigValueList setBooleans(List<Boolean> values) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.BOOLEAN;
        }
        if (this.type != ValueType.BOOLEAN) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setValue(values);
    }

    @Override
    public ConfigValueList setStrings(List<String> values) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.STRING;
        }
        if (this.type != ValueType.STRING) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setValue(values);
    }

    @Override
    public ConfigValueList setInts(List<Integer> values) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.INT;
        }
        if (this.type != ValueType.INT) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setValue(values);
    }

    @Override
    public ConfigValueList setLongs(List<Long> values) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.LONG;
        }
        if (this.type != ValueType.LONG) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setValue(values);
    }

    @Override
    public ConfigValueList setHexs(List<Integer> values) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.HEX;
        }
        if (this.type != ValueType.HEX) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setValue(values);
    }

    @Override
    public ConfigValueList setDoubles(List<Double> values) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.DOUBLE;
        }
        if (this.type != ValueType.DOUBLE) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setValue(values);
    }

    @Override
    public BooleanList getDefaultBooleans() {
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tag does not have a type assigned yet.");
        }
        if (this.type != ValueType.BOOLEAN) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.defaultValue == null) {
            throw new IllegalStateException("No default value is set.");
        }
        return BooleanLists.unmodifiable((BooleanList)((BooleanList)SneakyUtils.unsafeCast(this.defaultValue)));
    }

    @Override
    public List<String> getDefaultStrings() {
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tag does not have a type assigned yet.");
        }
        if (this.type != ValueType.STRING) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.defaultValue == null) {
            throw new IllegalStateException("No default value is set.");
        }
        return Collections.unmodifiableList((List)SneakyUtils.unsafeCast(this.defaultValue));
    }

    @Override
    public IntList getDefaultInts() {
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tag does not have a type assigned yet.");
        }
        if (this.type != ValueType.INT) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.defaultValue == null) {
            throw new IllegalStateException("No default value is set.");
        }
        return IntLists.unmodifiable((IntList)((IntList)SneakyUtils.unsafeCast(this.defaultValue)));
    }

    @Override
    public LongList getDefaultLongs() {
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tag does not have a type assigned yet.");
        }
        if (this.type != ValueType.LONG) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.defaultValue == null) {
            throw new IllegalStateException("No default value is set.");
        }
        return LongLists.unmodifiable((LongList)((LongList)SneakyUtils.unsafeCast(this.defaultValue)));
    }

    @Override
    public IntList getDefaultHexs() {
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tag does not have a type assigned yet.");
        }
        if (this.type != ValueType.HEX) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.defaultValue == null) {
            throw new IllegalStateException("No default value is set.");
        }
        return IntLists.unmodifiable((IntList)((IntList)SneakyUtils.unsafeCast(this.defaultValue)));
    }

    @Override
    public DoubleList getDefaultDoubles() {
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tag does not have a type assigned yet.");
        }
        if (this.type != ValueType.DOUBLE) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        if (this.defaultValue == null) {
            throw new IllegalStateException("No default value is set.");
        }
        return DoubleLists.unmodifiable((DoubleList)((DoubleList)SneakyUtils.unsafeCast(this.defaultValue)));
    }

    @Override
    public ConfigValueList setDefaultBooleans(List<Boolean> values) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.BOOLEAN;
        }
        if (this.type != ValueType.BOOLEAN) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setDefaultValue((List<?>)new BooleanArrayList(values));
    }

    @Override
    public ConfigValueList setDefaultStrings(List<String> values) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.STRING;
        }
        if (this.type != ValueType.STRING) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setDefaultValue(new StringList((Collection<? extends String>)values));
    }

    @Override
    public ConfigValueList setDefaultInts(List<Integer> values) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.INT;
        }
        if (this.type != ValueType.INT) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setDefaultValue((List<?>)new IntArrayList(values));
    }

    @Override
    public ConfigValueList setDefaultLongs(List<Long> values) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.LONG;
        }
        if (this.type != ValueType.LONG) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setDefaultValue((List<?>)new LongArrayList(values));
    }

    @Override
    public ConfigValueList setDefaultHexs(List<Integer> values) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.HEX;
        }
        if (this.type != ValueType.HEX) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setDefaultValue((List<?>)new IntArrayList(values));
    }

    @Override
    public ConfigValueList setDefaultDoubles(List<Double> values) {
        if (this.type == ValueType.UNKNOWN) {
            this.type = ValueType.DOUBLE;
        }
        if (this.type != ValueType.DOUBLE) {
            throw new IllegalStateException("Tag has incompatible type: " + String.valueOf((Object)this.type));
        }
        return this.setDefaultValue((List<?>)new DoubleArrayList(values));
    }

    @Override
    public ConfigValueList setRestriction(ListRestriction restriction) {
        Optional<ListRestriction.Failure> failureOpt;
        this.restriction = restriction;
        if (this.defaultValue != null && (failureOpt = restriction.test(ConfigValueListImpl.proxy(this.defaultValue, this.type))).isPresent()) {
            ListRestriction.Failure failure = failureOpt.get();
            throw new IllegalStateException("Default list value at index " + failure.index() + " with value " + String.valueOf(failure.value()) + " was not accepted by Restriction.");
        }
        return this;
    }

    @Override
    @Nullable
    public ListRestriction getRestriction() {
        return this.restriction;
    }

    @Override
    public void reset() {
        if (this.defaultValue != null) {
            this.value = null;
            this.dirty = true;
        }
    }

    @Override
    public AbstractConfigTag<ConfigValueList> copy(@Nullable ConfigCategoryImpl parent) {
        ConfigValueListImpl clone = new ConfigValueListImpl(this.getName(), parent);
        clone.comment = List.copyOf(this.comment);
        clone.defaultValue = this.defaultValue != null ? List.copyOf(this.defaultValue) : null;
        clone.value = this.value != null ? List.copyOf(this.value) : null;
        clone.type = this.type;
        return clone;
    }

    @Override
    public void write(MCDataOutput out) {
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tried to write UNKNOWN tag to network");
        }
        out.writeEnum(this.type);
        switch (this.type) {
            case STRING: {
                List<String> values = this.getStrings();
                out.writeVarInt(values.size());
                for (String s : values) {
                    out.writeString(s);
                }
                break;
            }
            case BOOLEAN: {
                out.writeBooleans(this.getBooleans().toBooleanArray());
                break;
            }
            case INT: {
                out.writeInts(this.getInts().toIntArray());
                break;
            }
            case LONG: {
                out.writeLongs(this.getLongs().toLongArray());
                break;
            }
            case HEX: {
                out.writeInts(this.getHexs().toIntArray());
                break;
            }
            case DOUBLE: {
                out.writeDoubles(this.getDoubles().toDoubleArray());
            }
        }
    }

    @Override
    public void read(MCDataInput in) {
        ValueType netType = in.readEnum(ValueType.class);
        if (this.networkSynthetic) {
            this.type = netType;
        }
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tried to read into an UNKNOWN tag from the network");
        }
        if (netType != this.type) {
            throw new IllegalStateException("Tried to read a " + String.valueOf((Object)netType) + " tag from the network into a " + String.valueOf((Object)this.type) + " tag");
        }
        switch (this.type) {
            case STRING: {
                this.networkValue = this.readStringList(in);
                break;
            }
            case BOOLEAN: {
                this.networkValue = new BooleanArrayList(in.readBooleans());
                break;
            }
            case INT: 
            case HEX: {
                this.networkValue = new IntArrayList(in.readInts());
                break;
            }
            case LONG: {
                this.networkValue = new LongArrayList(in.readLongs());
                break;
            }
            case DOUBLE: {
                this.networkValue = new DoubleArrayList(in.readDoubles());
            }
        }
    }

    @Override
    public void resetFromNetwork() {
        this.networkValue = null;
    }

    private List<String> readStringList(MCDataInput in) {
        int len = in.readVarInt();
        ArrayList<String> values = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            values.add(in.readString());
        }
        return values;
    }

    public ConfigValueList setValue(List<?> value) {
        this.value = value;
        if (this.type != ValueType.UNKNOWN) {
            this.value = this.tryConvert(this.value, this.type);
        }
        this.dirty = true;
        return this;
    }

    public List<?> getRawValue() {
        if (this.type == ValueType.UNKNOWN) {
            throw new IllegalStateException("Tag does not have a type assigned yet.");
        }
        this.value = this.tryConvert(this.value, this.type);
        return this.getRealRawValue();
    }

    @VisibleForTesting
    List<?> getRealRawValue() {
        if (this.value == null) {
            if (this.defaultValue == null) {
                throw new IllegalStateException("Default value not set.");
            }
            return this.defaultValue;
        }
        return this.value;
    }

    public ConfigValueList setDefaultValue(List<?> value) {
        Optional<ListRestriction.Failure> failureOpt;
        if (this.restriction != null && (failureOpt = this.restriction.test(ConfigValueListImpl.proxy(value, this.type))).isPresent()) {
            ListRestriction.Failure failure = failureOpt.get();
            throw new IllegalStateException("Default list value at index " + failure.index() + " with value " + String.valueOf(failure.value()) + " was not accepted by Restriction.");
        }
        this.defaultValue = value;
        this.dirty = true;
        return this;
    }

    public void setKnownType(ValueType type) {
        this.type = type;
    }

    @Nullable
    List<?> tryConvert(@Nullable List<?> list, ValueType type) {
        Optional<ListRestriction.Failure> failureOpt;
        if (list == null) {
            return null;
        }
        try {
            list = ConfigValueListImpl.convert(list, type);
        }
        catch (IllegalStateException ex) {
            LOGGER.error("Failed to convert config list tag {} to {}. Resetting to default.", new Object[]{this.getDesc(), type, ex});
            this.dirty = true;
            return null;
        }
        if (this.restriction != null && (failureOpt = this.restriction.test(ConfigValueListImpl.proxy(list, type))).isPresent()) {
            ListRestriction.Failure failure = failureOpt.get();
            LOGGER.error("List violates restriction. Resetting to default. Tag {}, Index {} Value {}, Restriction {}, All values, {}", new Object[]{this.getDesc(), failure.index(), failure.value(), this.restriction.describe(), list});
            this.dirty = true;
            return null;
        }
        return list;
    }

    static List<?> convert(List<?> list, ValueType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ValueType.UNKNOWN -> throw new AssertionError((Object)"Impossible to reach this branch.");
            case ValueType.BOOLEAN -> ConfigValueListImpl.convertToBooleans(list);
            case ValueType.STRING -> ConfigValueListImpl.convertToStrings(list);
            case ValueType.INT -> ConfigValueListImpl.convertToInts(list);
            case ValueType.LONG -> ConfigValueListImpl.convertToLongs(list);
            case ValueType.HEX -> ConfigValueListImpl.convertToHexs(list);
            case ValueType.DOUBLE -> ConfigValueListImpl.convertToDoubles(list);
        };
    }

    private static BooleanList convertToBooleans(List<?> list) {
        if (list instanceof BooleanList) {
            BooleanList bList = (BooleanList)list;
            return bList;
        }
        BooleanArrayList bList = new BooleanArrayList(list.size());
        for (Object o : list) {
            bList.add(ConfigValueImpl.convertToBoolean(o).booleanValue());
        }
        return bList;
    }

    private static List<String> convertToStrings(List<?> list) {
        if (list instanceof StringList) {
            StringList sList = (StringList)list;
            return sList;
        }
        return new StringList((Collection<? extends String>)FastStream.of(list).map(Object::toString).toList());
    }

    private static IntList convertToInts(List<?> list) {
        if (list instanceof IntList) {
            IntList iList = (IntList)list;
            return iList;
        }
        IntArrayList iList = new IntArrayList(list.size());
        for (Object o : list) {
            iList.add(ConfigValueImpl.convertToInteger(o).intValue());
        }
        return iList;
    }

    private static LongList convertToLongs(List<?> list) {
        if (list instanceof LongList) {
            LongList lList = (LongList)list;
            return lList;
        }
        LongArrayList lList = new LongArrayList(list.size());
        for (Object o : list) {
            lList.add(ConfigValueImpl.convertToLong(o).longValue());
        }
        return lList;
    }

    private static IntList convertToHexs(List<?> list) {
        if (list instanceof IntList) {
            IntList iList = (IntList)list;
            return iList;
        }
        IntArrayList iList = new IntArrayList(list.size()){};
        for (Object o : list) {
            iList.add(ConfigValueImpl.convertToHex(o).intValue());
        }
        return iList;
    }

    private static DoubleList convertToDoubles(List<?> list) {
        if (list instanceof DoubleList) {
            DoubleList dList = (DoubleList)list;
            return dList;
        }
        DoubleArrayList iList = new DoubleArrayList(list.size()){};
        for (Object o : list) {
            iList.add(ConfigValueImpl.convertToDouble(o).doubleValue());
        }
        return iList;
    }

    static class StringList
    extends ArrayList<String> {
        public StringList(Collection<? extends String> c) {
            super(c);
        }
    }
}

