/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.DyenamicsAndFriends;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedcore.crafting.StorageDyeRecipeBase;

public class SophisticatedBackpacksCompat {
    public static final DeferredHolder<RecipeSerializer<?>, SimpleCraftingRecipeSerializer<?>> BACKPACK_DYE_RECIPE_SERIALIZER = DyenamicsAndFriends.RECIPE_SERIALIZERS.register("sophisticated_backpackdye", () -> new SimpleCraftingRecipeSerializer(BackpackDyeRecipe::new));
    public static final DeferredHolder<RecipeType<?>, RecipeType<BackpackDyeRecipe>> BACKPACK_DYE_RECIPE_TYPE = DyenamicsAndFriends.RECIPE_TYPES.register("sophisticated_backpackdye", () -> new RecipeType<BackpackDyeRecipe>(){});

    public static void postRegister() {
    }

    static class ColorHelper {
        ColorHelper() {
        }

        public static int calculateColor(int baseColor, int defaultColor, List<DyenamicDyeColor> dyes) {
            if (dyes.isEmpty()) {
                return baseColor;
            }
            int[] rgb = new int[3];
            int sumMaxComponent = 0;
            int numberOfColors = 0;
            if (baseColor != defaultColor) {
                float baseRed = baseColor >> 16 & 0xFF;
                float baseGreen = baseColor >> 8 & 0xFF;
                float baseBlue = baseColor & 0xFF;
                sumMaxComponent = (int)((float)sumMaxComponent + Math.max(baseRed, Math.max(baseGreen, baseBlue)));
                rgb[0] = (int)((float)rgb[0] + baseRed);
                rgb[1] = (int)((float)rgb[1] + baseGreen);
                rgb[2] = (int)((float)rgb[2] + baseBlue);
                ++numberOfColors;
            }
            for (DyenamicDyeColor dye : dyes) {
                int dyeRgb = dye.getColorValue();
                int dyeRed = dyeRgb >> 16 & 0xFF;
                int dyeGreen = dyeRgb >> 8 & 0xFF;
                int dyeBlue = dyeRgb & 0xFF;
                sumMaxComponent += Math.max(dyeRed, Math.max(dyeGreen, dyeBlue));
                rgb[0] = rgb[0] + dyeRed;
                rgb[1] = rgb[1] + dyeGreen;
                rgb[2] = rgb[2] + dyeBlue;
                ++numberOfColors;
            }
            int avgRed = rgb[0] / numberOfColors;
            int avgGreen = rgb[1] / numberOfColors;
            int avgBlue = rgb[2] / numberOfColors;
            float avgMaxComponent = (float)sumMaxComponent / (float)numberOfColors;
            float maxAvgComponent = Math.max(avgRed, Math.max(avgGreen, avgBlue));
            avgRed = (int)((float)avgRed * avgMaxComponent / maxAvgComponent);
            avgGreen = (int)((float)avgGreen * avgMaxComponent / maxAvgComponent);
            avgBlue = (int)((float)avgBlue * avgMaxComponent / maxAvgComponent);
            int finalColor = (avgRed << 8) + avgGreen;
            finalColor = (finalColor << 8) + avgBlue;
            return 0xFF000000 | finalColor;
        }
    }

    public static class BackpackDyeRecipe
    extends StorageDyeRecipeBase {
        public BackpackDyeRecipe(CraftingBookCategory category) {
            super(category);
        }

        public RecipeSerializer<?> getSerializer() {
            return (RecipeSerializer)BACKPACK_DYE_RECIPE_SERIALIZER.get();
        }

        protected boolean isDyeableStorageItem(ItemStack stack) {
            return stack.getItem() instanceof BackpackItem;
        }

        public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
            HashMap<Integer, List<DyenamicDyeColor>> columnDyes = new HashMap<Integer, List<DyenamicDyeColor>>();
            Tuple columnStorage = null;
            for (int slot = 0; slot < inv.size(); ++slot) {
                ItemStack slotStack = inv.getItem(slot);
                if (slotStack.isEmpty()) continue;
                int column = slot % inv.width();
                if (this.isDyeableStorageItem(slotStack)) {
                    if (columnStorage != null) {
                        return ItemStack.EMPTY;
                    }
                    columnStorage = new Tuple((Object)column, (Object)slotStack);
                    continue;
                }
                if (slotStack.is(Tags.Items.DYES)) {
                    DyenamicDyeColor dyeColor = DyenamicDyeColor.getColor((ItemStack)slotStack);
                    if (dyeColor == null) {
                        return ItemStack.EMPTY;
                    }
                    columnDyes.computeIfAbsent(column, c -> new ArrayList()).add(dyeColor);
                    continue;
                }
                return ItemStack.EMPTY;
            }
            if (columnStorage == null) {
                return ItemStack.EMPTY;
            }
            ItemStack coloredStorage = ((ItemStack)columnStorage.getB()).copy();
            coloredStorage.setCount(1);
            int storageColumn = (Integer)columnStorage.getA();
            this.applyTintColors(columnDyes, coloredStorage, storageColumn);
            return coloredStorage;
        }

        private void applyTintColors(Map<Integer, List<DyenamicDyeColor>> columnDyes, ItemStack coloredStorage, int storageColumn) {
            ArrayList<DyenamicDyeColor> mainDyes = new ArrayList<DyenamicDyeColor>();
            ArrayList<DyenamicDyeColor> trimDyes = new ArrayList<DyenamicDyeColor>();
            for (Map.Entry<Integer, List<DyenamicDyeColor>> entry : columnDyes.entrySet()) {
                if (entry.getKey() <= storageColumn) {
                    mainDyes.addAll((Collection<DyenamicDyeColor>)entry.getValue());
                }
                if (entry.getKey() < storageColumn) continue;
                trimDyes.addAll((Collection<DyenamicDyeColor>)entry.getValue());
            }
            this.applyDyenamicColors(coloredStorage, mainDyes, trimDyes);
        }

        private void applyDyenamicColors(ItemStack coloredStorage, List<DyenamicDyeColor> mainDyes, List<DyenamicDyeColor> trimDyes) {
            IBackpackWrapper coloredWrapper = BackpackWrapper.fromStack((ItemStack)coloredStorage);
            coloredWrapper.setColors(ColorHelper.calculateColor(coloredWrapper.getMainColor(), -3382982, mainDyes), ColorHelper.calculateColor(coloredWrapper.getAccentColor(), -10342886, trimDyes));
        }

        protected void applyColors(ItemStack itemStack, List<DyeColor> list, List<DyeColor> list1) {
        }
    }
}

