/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import cy.jdkdigital.dyenamics.common.block.DyenamicCarpetBlock;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.client.render.furnish.DyenamicsPlateRenderer;
import cy.jdkdigital.dyenamicsandfriends.client.render.furnish.DyenamicsShowcaseRenderer;
import cy.jdkdigital.dyenamicsandfriends.common.block.entity.furnish.DyenamicsAmphoraBlockEntity;
import cy.jdkdigital.dyenamicsandfriends.common.block.entity.furnish.DyenamicsPlateBlockEntity;
import cy.jdkdigital.dyenamicsandfriends.common.block.entity.furnish.DyenamicsShowcaseBlockEntity;
import cy.jdkdigital.dyenamicsandfriends.common.block.furnish.DyenamicsAmphora;
import cy.jdkdigital.dyenamicsandfriends.common.block.furnish.DyenamicsCarpetOnStairs;
import cy.jdkdigital.dyenamicsandfriends.common.block.furnish.DyenamicsCarpetOnTrapdoor;
import cy.jdkdigital.dyenamicsandfriends.common.block.furnish.DyenamicsPlate;
import cy.jdkdigital.dyenamicsandfriends.common.block.furnish.DyenamicsShowcase;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import io.github.wouink.furnish.block.Awning;
import io.github.wouink.furnish.block.CarpetOnTrapdoor;
import io.github.wouink.furnish.block.Curtain;
import io.github.wouink.furnish.block.PaperLamp;
import io.github.wouink.furnish.block.Sofa;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class FurnishCompat {
    private static final Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> SOFAS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    private static final Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> AWNINGS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    private static final Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> CURTAINS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    private static final Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> SHOWCASES = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    private static final Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> AMPHORAS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    private static final Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> PLATES = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    private static final Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> PAPER_LAMPS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static final Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> CARPET_ON_STAIRS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static final Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> CARPET_ON_TRAPDOOR = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static Supplier<BlockEntityType<DyenamicsAmphoraBlockEntity>> AMPHORA_BLOCK_ENTITY;
    public static Supplier<BlockEntityType<DyenamicsPlateBlockEntity>> PLATE_BLOCK_ENTITY;
    public static Supplier<BlockEntityType<DyenamicsShowcaseBlockEntity>> SHOWCASE_BLOCK_ENTITY;

    public static void registerBlocks(DyenamicDyeColor color) {
        String prefix = "furnish_" + color.getSerializedName();
        BlockBehaviour.Properties carpetProps = BlockBehaviour.Properties.of().mapColor(color.getMapColor()).strength(0.1f).sound(SoundType.WOOL).lightLevel(state -> color.getLightValue());
        CARPET_ON_STAIRS.put(color, DyenamicRegistry.registerBlock(prefix + "_carpet_on_stairs", () -> new DyenamicsCarpetOnStairs(carpetProps, color), false));
        CARPET_ON_TRAPDOOR.put(color, DyenamicRegistry.registerBlock(prefix + "_carpet_on_trapdoor", () -> new DyenamicsCarpetOnTrapdoor(carpetProps, color), false));
        AWNINGS.put(color, DyenamicRegistry.registerBlock(prefix + "_awning", () -> new Awning(carpetProps), true));
        CURTAINS.put(color, DyenamicRegistry.registerBlock(prefix + "_curtain", () -> new Curtain(carpetProps), true));
        BlockBehaviour.Properties woolProps = BlockBehaviour.Properties.of().mapColor(color.getMapColor()).strength(0.8f).sound(SoundType.WOOL).lightLevel(state -> color.getLightValue());
        SOFAS.put(color, DyenamicRegistry.registerBlock(prefix + "_sofa", () -> new Sofa(woolProps), true));
        SHOWCASES.put(color, DyenamicRegistry.registerBlock(prefix + "_showcase", () -> new DyenamicsShowcase(woolProps), true));
        BlockBehaviour.Properties terracottaProps = BlockBehaviour.Properties.of().mapColor(color.getMapColor()).strength(1.25f, 4.2f).lightLevel(state -> color.getLightValue());
        AMPHORAS.put(color, DyenamicRegistry.registerBlock(prefix + "_amphora", () -> new DyenamicsAmphora(terracottaProps), true));
        PLATES.put(color, DyenamicRegistry.registerBlock(prefix + "_plate", () -> new DyenamicsPlate(terracottaProps), true));
        PAPER_LAMPS.put(color, DyenamicRegistry.registerBlock(prefix + "_paper_lamp", PaperLamp::new, true));
        AMPHORA_BLOCK_ENTITY = DyenamicRegistry.registerBlockEntity(prefix + "_amphora", () -> DyenamicRegistry.createBlockEntityType(DyenamicsAmphoraBlockEntity::new, AMPHORAS.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0])));
        PLATE_BLOCK_ENTITY = DyenamicRegistry.registerBlockEntity(prefix + "_plate", () -> DyenamicRegistry.createBlockEntityType(DyenamicsPlateBlockEntity::new, PLATES.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0])));
        SHOWCASE_BLOCK_ENTITY = DyenamicRegistry.registerBlockEntity(prefix + "_showcase", () -> DyenamicRegistry.createBlockEntityType(DyenamicsShowcaseBlockEntity::new, SHOWCASES.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0])));
    }

    public static void entityPlace(BlockEvent.EntityPlaceEvent event) {
        if (event.getPlacedBlock().getBlock() instanceof DyenamicCarpetBlock) {
            if (!BuiltInRegistries.BLOCK.getKey((Object)event.getPlacedBlock().getBlock()).getNamespace().equals("dyenamics")) {
                return;
            }
            BlockState stateBelow = event.getLevel().getBlockState(event.getPos().below());
            if (stateBelow.getBlock() instanceof StairBlock && !event.getEntity().isShiftKeyDown()) {
                if (stateBelow.getValue((Property)StairBlock.HALF) == Half.BOTTOM && stateBelow.getValue((Property)StairBlock.SHAPE) == StairsShape.STRAIGHT) {
                    DyenamicDyeColor color = ((DyenamicCarpetBlock)event.getPlacedBlock().getBlock()).getDyenamicColor();
                    event.getLevel().setBlock(event.getPos(), (BlockState)((Block)CARPET_ON_STAIRS.get(color).get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)stateBelow.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))), 3);
                }
            } else if (stateBelow.getBlock() instanceof TrapDoorBlock && stateBelow.getValue((Property)TrapDoorBlock.HALF) == Half.TOP) {
                DyenamicDyeColor color = ((DyenamicCarpetBlock)event.getPlacedBlock().getBlock()).getDyenamicColor();
                event.getLevel().setBlock(event.getPos(), (BlockState)((BlockState)((Block)CARPET_ON_TRAPDOOR.get(color).get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)stateBelow.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)CarpetOnTrapdoor.OPEN, (Comparable)((Boolean)stateBelow.getValue((Property)TrapDoorBlock.OPEN))), 3);
            }
        }
    }

    public static void buildTabContents(BuildCreativeModeTabContentsEvent event) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.parse((String)"furnish:furnish"));
        if (event.getTabKey().equals(key)) {
            SOFAS.forEach((dyenamicDyeColor, registryObject) -> event.accept((ItemLike)registryObject.get()));
            AWNINGS.forEach((dyenamicDyeColor, registryObject) -> event.accept((ItemLike)registryObject.get()));
            CURTAINS.forEach((dyenamicDyeColor, registryObject) -> event.accept((ItemLike)registryObject.get()));
            SHOWCASES.forEach((dyenamicDyeColor, registryObject) -> event.accept((ItemLike)registryObject.get()));
            AMPHORAS.forEach((dyenamicDyeColor, registryObject) -> event.accept((ItemLike)registryObject.get()));
            PLATES.forEach((dyenamicDyeColor, registryObject) -> event.accept((ItemLike)registryObject.get()));
            PAPER_LAMPS.forEach((dyenamicDyeColor, registryObject) -> event.accept((ItemLike)registryObject.get()));
        }
    }

    public static class Client {
        public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            SHOWCASES.values().forEach(registryObject -> {
                if (registryObject.get() instanceof DyenamicsShowcase) {
                    event.registerBlockEntityRenderer(SHOWCASE_BLOCK_ENTITY.get(), DyenamicsShowcaseRenderer::new);
                }
            });
            PLATES.values().forEach(registryObject -> {
                if (registryObject.get() instanceof DyenamicsPlate) {
                    event.registerBlockEntityRenderer(PLATE_BLOCK_ENTITY.get(), DyenamicsPlateRenderer::new);
                }
            });
        }
    }
}

