/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import cy.jdkdigital.dyenamics.common.item.DyenamicDyeItem;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.DyenamicsAndFriends;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.block.BaseKitchenBlock;
import net.blay09.mods.cookingforblockheads.block.CabinetBlock;
import net.blay09.mods.cookingforblockheads.block.CookingTableBlock;
import net.blay09.mods.cookingforblockheads.block.CounterBlock;
import net.blay09.mods.cookingforblockheads.block.DyedConnectorBlock;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.block.SinkBlock;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.block.entity.util.TransferableBlockEntity;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CookingForBlockheadsCompat {
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> OVENS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> FRIDGES = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> CONNECTORS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> KITCHEN_FLOORS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> COOKING_TABLES = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> COUNTERS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> CABINETS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> SINKS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();

    public static void registerBlocks(DyenamicDyeColor color) {
        String prefix = "cookingforblockheads_" + color.getSerializedName();
        OVENS.put(color, DyenamicRegistry.registerBlock(prefix + "_oven", () -> new OvenBlock(color.getAnalogue(), BlockBehaviour.Properties.of().lightLevel(state -> color.getLightValue())), true));
        FRIDGES.put(color, DyenamicRegistry.registerBlock(prefix + "_fridge", () -> new FridgeBlock(color.getAnalogue(), BlockBehaviour.Properties.of().lightLevel(state -> color.getLightValue())), true));
        CONNECTORS.put(color, DyenamicRegistry.registerBlock(prefix + "_connector", () -> new DyedConnectorBlock(color.getAnalogue(), BlockBehaviour.Properties.of().lightLevel(state -> color.getLightValue())){}, true));
        KITCHEN_FLOORS.put(color, DyenamicRegistry.registerBlock(prefix + "_kitchen_floor", () -> new Block(BlockBehaviour.Properties.of().lightLevel(state -> color.getLightValue())), true));
        COOKING_TABLES.put(color, DyenamicRegistry.registerBlock(prefix + "_cooking_table", () -> new CookingTableBlock(color.getAnalogue(), BlockBehaviour.Properties.of().lightLevel(state -> color.getLightValue())), true));
        COUNTERS.put(color, DyenamicRegistry.registerBlock(prefix + "_counter", () -> new CounterBlock(color.getAnalogue(), BlockBehaviour.Properties.of().lightLevel(state -> color.getLightValue())), true));
        CABINETS.put(color, DyenamicRegistry.registerBlock(prefix + "_cabinet", () -> new CabinetBlock(color.getAnalogue(), BlockBehaviour.Properties.of().lightLevel(state -> color.getLightValue())), true));
        SINKS.put(color, DyenamicRegistry.registerBlock(prefix + "_sink", () -> new SinkBlock(color.getAnalogue(), BlockBehaviour.Properties.of().lightLevel(state -> color.getLightValue())), true));
    }

    public static void buildTabContents(BuildCreativeModeTabContentsEvent event) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.parse((String)"cookingforblockheads:cookingforblockheads"));
        if (event.getTabKey().equals(key)) {
            Arrays.stream(DyenamicDyeColor.dyenamicValues()).forEach(dyenamicDyeColor -> {
                event.accept((ItemLike)OVENS.get(dyenamicDyeColor).get());
                event.accept((ItemLike)FRIDGES.get(dyenamicDyeColor).get());
                event.accept((ItemLike)CONNECTORS.get(dyenamicDyeColor).get());
                event.accept((ItemLike)KITCHEN_FLOORS.get(dyenamicDyeColor).get());
                event.accept((ItemLike)COOKING_TABLES.get(dyenamicDyeColor).get());
                event.accept((ItemLike)COUNTERS.get(dyenamicDyeColor).get());
                event.accept((ItemLike)CABINETS.get(dyenamicDyeColor).get());
                event.accept((ItemLike)SINKS.get(dyenamicDyeColor).get());
            });
        }
    }

    public static void addBlocks(BlockEntityTypeAddBlocksEvent event) {
        event.modify((BlockEntityType)ModBlockEntities.oven.get(), OVENS.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0]));
        event.modify((BlockEntityType)ModBlockEntities.fridge.get(), FRIDGES.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0]));
        event.modify((BlockEntityType)ModBlockEntities.cookingTable.get(), COOKING_TABLES.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0]));
        event.modify((BlockEntityType)ModBlockEntities.counter.get(), COUNTERS.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0]));
        event.modify((BlockEntityType)ModBlockEntities.cabinet.get(), CABINETS.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0]));
        event.modify((BlockEntityType)ModBlockEntities.sink.get(), SINKS.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0]));
    }

    public static void playerRightClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemStack = event.getItemStack();
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            Item item;
            ServerLevel level2 = (ServerLevel)level;
            if (!itemStack.isEmpty() && (item = itemStack.getItem()) instanceof DyenamicDyeItem) {
                BlockState newState;
                DyenamicDyeItem dyeItem = (DyenamicDyeItem)item;
                BlockState state = level2.getBlockState(event.getPos());
                if (state.getBlock() instanceof BaseKitchenBlock && (newState = CookingForBlockheadsCompat.recolorBlock(state, dyeItem.getDyeColor())) != null && !newState.is(state.getBlock())) {
                    BlockEntity blockEntity = level2.getBlockEntity(event.getPos());
                    Object transferData = null;
                    if (blockEntity instanceof TransferableBlockEntity) {
                        TransferableBlockEntity transferableBlockEntity = (TransferableBlockEntity)blockEntity;
                        transferData = transferableBlockEntity.snapshotDataForTransfer();
                    }
                    level2.setBlockAndUpdate(event.getPos(), newState);
                    BlockEntity newBlockEntity = level2.getBlockEntity(event.getPos());
                    if (transferData != null && newBlockEntity instanceof TransferableBlockEntity) {
                        TransferableBlockEntity transferableBlockEntity = (TransferableBlockEntity)newBlockEntity;
                        transferableBlockEntity.restoreFromTransferSnapshot(transferData);
                    }
                    if (!event.getEntity().isCreative()) {
                        itemStack.shrink(1);
                    }
                    event.getEntity().swing(event.getHand());
                    event.setCanceled(true);
                }
            }
        }
    }

    @Nullable
    private static BlockState recolorBlock(BlockState state, DyenamicDyeColor color) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        BlockState newState = null;
        DyenamicsAndFriends.LOGGER.info("recolor block " + String.valueOf(key));
        if (key.getPath().contains("_oven")) {
            newState = ((Block)OVENS.get(color).get()).defaultBlockState();
        } else if (key.getPath().contains("_fridge")) {
            newState = ((Block)FRIDGES.get(color).get()).defaultBlockState();
        } else if (key.getPath().contains("_connector")) {
            newState = ((Block)CONNECTORS.get(color).get()).defaultBlockState();
        } else if (key.getPath().contains("_cooking_table")) {
            newState = ((Block)COOKING_TABLES.get(color).get()).defaultBlockState();
        } else if (key.getPath().contains("_counter")) {
            newState = ((Block)COUNTERS.get(color).get()).defaultBlockState();
        } else if (key.getPath().contains("_cabinet")) {
            newState = ((Block)CABINETS.get(color).get()).defaultBlockState();
        } else if (key.getPath().contains("_sink")) {
            newState = ((Block)SINKS.get(color).get()).defaultBlockState();
        }
        if (newState != null) {
            for (Property property : state.getProperties()) {
                if (!newState.hasProperty(property)) continue;
                newState = (BlockState)newState.setValue(property, state.getValue(property));
            }
            if (newState.hasProperty((Property)BaseKitchenBlock.COLOR) && newState.hasProperty((Property)BaseKitchenBlock.HAS_COLOR)) {
                newState = (BlockState)((BlockState)newState.setValue((Property)BaseKitchenBlock.HAS_COLOR, (Comparable)Boolean.valueOf(true))).setValue((Property)BaseKitchenBlock.COLOR, (Comparable)color.getAnalogue());
            }
        }
        return newState;
    }

    public static class Client {
        public static void register() {
        }

        public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
            event.register((blockState, blockAndTintGetter, blockPos, i) -> 4159204, (Block[])SINKS.values().stream().map(DeferredHolder::get).toArray(Block[]::new));
        }
    }
}

