/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.silentchaos512.lib.util.DimPos;
import net.silentchaos512.lib.util.DimensionId;

public class TeleportUtils {
    public static void teleport(Player player, DimPos pos, @Nullable Direction direction) {
        TeleportUtils.teleport(player, pos.getDimensionId(), (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, direction);
    }

    public static void teleport(Player player, DimensionId dimension, double destX, double destY, double destZ, @Nullable Direction direction) {
        DimensionId oldId = DimensionId.fromWorld(player.getCommandSenderWorld());
        float rotationYaw = player.getYRot();
        float rotationPitch = player.getXRot();
        if (!oldId.equals(dimension)) {
            TeleportUtils.teleportToDimension(player, dimension, destX, destY, destZ);
        }
        if (direction != null) {
            TeleportUtils.fixOrientation((Entity)player, destX, destY, destZ, direction);
        } else {
            player.setYRot(rotationYaw);
            player.setXRot(rotationPitch);
        }
        player.teleportTo(destX, destY, destZ);
    }

    public static void teleportToDimension(Player player, DimensionId dimension, double x, double y, double z) {
        ServerLevel world = dimension.loadWorld(player.getCommandSenderWorld());
        DimensionTransition dimensionTransition = new DimensionTransition(world, new Vec3(x, y, z), Vec3.ZERO, player.getYRot(), player.getXRot(), DimensionTransition.PLAY_PORTAL_SOUND);
        player.changeDimension(dimensionTransition);
    }

    private static void facePosition(Entity entity, double newX, double newY, double newZ, BlockPos dest) {
        double d0 = (double)dest.getX() - newX;
        double d1 = (double)dest.getY() - (newY + (double)entity.getEyeHeight());
        double d2 = (double)dest.getZ() - newZ;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(Mth.atan2((double)d1, (double)d3) * 57.29577951308232));
        entity.setXRot(TeleportUtils.updateRotation(entity.getXRot(), f1));
        entity.setYRot(TeleportUtils.updateRotation(entity.getYRot(), f));
    }

    private static float updateRotation(float angle, float targetAngle) {
        float f = Mth.wrapDegrees((float)(targetAngle - angle));
        return angle + f;
    }

    @Nullable
    public static Entity teleportEntity(Entity entity, DimPos pos, @Nullable Direction facing) {
        return TeleportUtils.teleportEntity(entity, (Level)pos.getDimensionId().getWorld(), (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, facing);
    }

    @Nullable
    public static Entity teleportEntity(Entity entity, Level destWorld, double newX, double newY, double newZ, @Nullable Direction facing) {
        Level world = entity.getCommandSenderWorld();
        if (DimensionId.fromWorld(world).equals(DimensionId.fromWorld(destWorld))) {
            if (facing != null) {
                TeleportUtils.fixOrientation(entity, newX, newY, newZ, facing);
            }
            entity.moveTo(newX, newY, newZ, entity.getYRot(), entity.getXRot());
            ((ServerLevel)destWorld).tickNonPassenger(entity);
            return entity;
        }
        DimensionTransition dimensionTransition = new DimensionTransition((ServerLevel)destWorld, new Vec3(newX, newY, newZ), Vec3.ZERO, entity.getYRot(), entity.getXRot(), DimensionTransition.DO_NOTHING);
        return entity.changeDimension(dimensionTransition);
    }

    private static void fixOrientation(Entity entity, double newX, double newY, double newZ, Direction facing) {
        if (facing != Direction.DOWN && facing != Direction.UP) {
            TeleportUtils.facePosition(entity, newX, newY, newZ, new BlockPos(new Vec3i((int)newX, (int)newY, (int)newZ)).relative(facing, 4));
        }
    }
}

