/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.config.integration;

import com.christofmeg.justenoughbreeding.CommonConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GreekFantasyIntegration {
    static final String MOD = "greekfantasy";
    static final List<String> animalNames = new ArrayList<String>();
    static final Map<String, String> ingredients = new HashMap<String, String>();
    static final Map<String, Integer> breedingCooldown = new HashMap<String, Integer>();
    static final Map<String, Boolean> needsToBeTamed = new HashMap<String, Boolean>();

    public static void init() {
        GreekFantasyIntegration.addAnimalTamed("orthus", "#greekfantasy:orthus_food");
        for (String animal : animalNames) {
            String animalIngredients = ingredients.get(animal);
            String animalSpawnEgg = animal + "_spawn_egg";
            CommonConstants.breedingIngredients.put("greekfantasy_" + animal, animalIngredients);
            CommonConstants.sharedGetSpawnEggFromEntity.put("greekfantasy_" + animal, animalSpawnEgg);
            if (needsToBeTamed.get(animal) != null) {
                CommonConstants.breedingNeedsToBeTamed.put("greekfantasy_" + animal, true);
            }
            if (breedingCooldown.get(animal) == null) continue;
            Integer animalBreedingCooldown = breedingCooldown.get(animal);
            CommonConstants.breedingCooldown.put("greekfantasy_" + animal, animalBreedingCooldown);
        }
    }

    private static void addAnimal(String name, String ingredient) {
        animalNames.add(name);
        ingredients.put(name, ingredient);
        breedingCooldown.put(name, 6000);
    }

    private static void addAnimalTamed(String name, String ingredient) {
        GreekFantasyIntegration.addAnimal(name, ingredient);
        needsToBeTamed.put(name, true);
    }
}

