/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.common.fishing.net;

import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import plus.dragons.createintegratedfarming.common.fishing.net.FishingNetFakePlayer;
import plus.dragons.createintegratedfarming.config.CIFConfig;

public abstract class AbstractFishingNetContext<T extends FishingHook> {
    protected final FishingNetFakePlayer player;
    protected final ItemStack fishingRod;
    protected final T fishingHook;
    protected final Set<BlockPos> visitedBlocks;
    public int timeUntilCatch;

    public AbstractFishingNetContext(ServerLevel level, ItemStack fishingRod) {
        this.visitedBlocks = new HashSet<BlockPos>(Math.min(16, (Integer)CIFConfig.server().fishingNetMaxRecordedBlocks.get()));
        this.player = new FishingNetFakePlayer(level);
        this.fishingRod = fishingRod;
        this.fishingHook = this.createFishingHook(level);
        this.fishingHook.setOwner((Entity)this.player);
        this.reset(level);
    }

    protected abstract T createFishingHook(ServerLevel var1);

    protected abstract boolean isPosValidForFishing(ServerLevel var1, BlockPos var2);

    public abstract LootTable getLootTable(ServerLevel var1, BlockPos var2);

    public FishingNetFakePlayer getPlayer() {
        return this.player;
    }

    public T getFishingHook() {
        return this.fishingHook;
    }

    public ItemStack getFishingRod() {
        return this.fishingRod;
    }

    public void reset(ServerLevel level) {
        this.visitedBlocks.clear();
        int lureSpeed = (int)(EnchantmentHelper.getFishingTimeReduction((ServerLevel)level, (ItemStack)this.fishingRod, this.fishingHook) * 20.0f);
        this.timeUntilCatch = (Mth.nextInt((RandomSource)this.fishingHook.getRandom(), (int)100, (int)600) - lureSpeed) * (Integer)CIFConfig.server().fishingNetCooldownMultiplier.get();
    }

    public boolean visitNewPositon(ServerLevel level, BlockPos pos) {
        if (this.isPosValidForFishing(level, pos)) {
            if (this.visitedBlocks.size() < (Integer)CIFConfig.server().fishingNetMaxRecordedBlocks.get()) {
                this.visitedBlocks.add(pos);
            }
            return true;
        }
        return false;
    }

    public LootParams buildCaptureLootContext(MovementContext context, ServerLevel level, LivingEntity entity) {
        this.player.setPos(context.position);
        return new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)context.position).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)level.damageSources().playerAttack((Player)this.player)).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)this.player).withParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, this.fishingHook).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)this.player).create(LootContextParamSets.ENTITY);
    }

    public LootParams buildFishingLootContext(MovementContext context, ServerLevel level, BlockPos pos) {
        this.fishingHook.setPos(context.position);
        this.player.setPos(context.position);
        return new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)context.position).withParameter(LootContextParams.TOOL, (Object)this.fishingRod).withParameter(LootContextParams.THIS_ENTITY, this.fishingHook).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)this.player).withLuck((float)EnchantmentHelper.getFishingLuckBonus((ServerLevel)level, (ItemStack)this.fishingRod, (Entity)this.player)).create(LootContextParamSets.FISHING);
    }

    public boolean canCatch() {
        int maxRecorded = (Integer)CIFConfig.server().fishingNetMaxRecordedBlocks.get();
        if (maxRecorded == 0) {
            return true;
        }
        return this.fishingHook.getRandom().nextInt(maxRecorded) < this.visitedBlocks.size();
    }

    public void invalidate(ServerLevel level) {
        this.fishingHook.discard();
        this.player.discard();
    }
}

