/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.neoforge.storage.diskinterface;

import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.neoforge.support.render.DiskModelBaker;
import com.refinedmods.refinedstorage.neoforge.support.render.RotationTranslationModelBaker;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import com.ultramega.cabletiers.neoforge.storage.diskinterface.TieredDiskInterfaceBakedModel;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;

public class TieredDiskInterfaceUnbakedGeometry
implements IUnbakedGeometry<TieredDiskInterfaceUnbakedGeometry> {
    private static final ResourceLocation LED_INACTIVE_MODEL = IdentifierUtil.createIdentifier((String)"block/disk/led_inactive");
    private final ResourceLocation inactiveModel;
    private final ResourceLocation baseModel;

    TieredDiskInterfaceUnbakedGeometry(DyeColor color, CableTiers tier) {
        this.baseModel = CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + tier.toString().toLowerCase() + "_disk_interface/base_" + color.getName());
        this.inactiveModel = CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + tier.toString().toLowerCase() + "_disk_interface/inactive");
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        modelGetter.apply(this.baseModel).resolveParents(modelGetter);
        modelGetter.apply(this.inactiveModel).resolveParents(modelGetter);
        RefinedStorageClientApi.INSTANCE.getDiskModels().forEach(diskModel -> ((UnbakedModel)modelGetter.apply((ResourceLocation)diskModel)).resolveParents(modelGetter));
        modelGetter.apply(LED_INACTIVE_MODEL).resolveParents(modelGetter);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        return new TieredDiskInterfaceBakedModel(Objects.requireNonNull(baker.bake(this.baseModel, modelState, spriteGetter)), new RotationTranslationModelBaker(modelState, baker, spriteGetter, this.inactiveModel), new RotationTranslationModelBaker(modelState, baker, spriteGetter, this.baseModel), new DiskModelBaker(modelState, baker, spriteGetter), new RotationTranslationModelBaker(modelState, baker, spriteGetter, LED_INACTIVE_MODEL));
    }
}

