/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.utils;

import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public final class ContentIds {
    private static final Map<CableTiers, Map<CableType, ResourceLocation>> CONTENT_MAP = new EnumMap<CableTiers, Map<CableType, ResourceLocation>>(CableTiers.class);

    private ContentIds() {
    }

    public static ResourceLocation getContentId(CableTiers tier, CableType type) {
        return (ResourceLocation)CONTENT_MAP.getOrDefault((Object)tier, Map.of()).get((Object)type);
    }

    static {
        for (CableTiers tier : CableTiers.values()) {
            EnumMap<CableType, ResourceLocation> map = new EnumMap<CableType, ResourceLocation>(CableType.class);
            for (CableType type : CableType.values()) {
                map.put(type, CableTiersIdentifierUtil.createCableTiersIdentifier(tier.name().toLowerCase() + "_" + type.name().toLowerCase()));
            }
            CONTENT_MAP.put(tier, map);
        }
    }
}

