/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.registry;

import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class Tags {
    private static final Map<CableTiers, Map<CableType, TagKey<Item>>> CONTENT_MAP_ITEMS = new EnumMap<CableTiers, Map<CableType, TagKey<Item>>>(CableTiers.class);
    private static final Map<CableTiers, Map<CableType, TagKey<Block>>> CONTENT_MAP_BLOCKS = new EnumMap<CableTiers, Map<CableType, TagKey<Block>>>(CableTiers.class);

    private Tags() {
    }

    public static TagKey<Item> getItemTag(CableTiers tier, CableType type) {
        return (TagKey)CONTENT_MAP_ITEMS.getOrDefault((Object)tier, Map.of()).get((Object)type);
    }

    public static TagKey<Block> getBlockTag(CableTiers tier, CableType type) {
        return (TagKey)CONTENT_MAP_BLOCKS.getOrDefault((Object)tier, Map.of()).get((Object)type);
    }

    private static <T> TagKey<T> createTag(ResourceKey<? extends Registry<T>> registry, String id) {
        return TagKey.create(registry, (ResourceLocation)CableTiersIdentifierUtil.createCableTiersIdentifier(id));
    }

    static {
        for (CableTiers tier : CableTiers.values()) {
            EnumMap itemsMap = new EnumMap(CableType.class);
            EnumMap blocksMap = new EnumMap(CableType.class);
            for (CableType type : CableType.values()) {
                String id = tier.name().toLowerCase() + "_" + type.name().toLowerCase() + "s";
                itemsMap.put(type, Tags.createTag(Registries.ITEM, id));
                blocksMap.put(type, Tags.createTag(Registries.BLOCK, id));
            }
            CONTENT_MAP_ITEMS.put(tier, itemsMap);
            CONTENT_MAP_BLOCKS.put(tier, blocksMap);
        }
    }
}

