/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.item;

import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import net.untitledduckmod.common.entity.WaterfowlEggEntity;
import net.untitledduckmod.common.entity.WaterfowlEntity;

public class WaterfowlEggItem
extends Item
implements ProjectileItem {
    private final Supplier<EntityType<? extends ThrowableItemProjectile>> thrownEntityType;
    private final Supplier<EntityType<? extends WaterfowlEntity>> mobEntityType;

    public WaterfowlEggItem(Item.Properties settings, Supplier<EntityType<? extends ThrowableItemProjectile>> entityType, Supplier<EntityType<? extends WaterfowlEntity>> mobEntityType) {
        super(settings);
        this.thrownEntityType = entityType;
        this.mobEntityType = mobEntityType;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        world.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.EGG_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!world.isClientSide) {
            WaterfowlEggEntity eggEntity = new WaterfowlEggEntity(this.thrownEntityType.get(), world, (LivingEntity)user, this.mobEntityType.get());
            eggEntity.setItem(itemStack);
            eggEntity.shootFromRotation((Entity)user, user.getXRot(), user.getYRot(), 0.0f, 1.5f, 1.0f);
            world.addFreshEntity((Entity)eggEntity);
        }
        user.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!user.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }

    public Projectile asProjectile(Level world, Position pos, ItemStack stack, Direction direction) {
        WaterfowlEggEntity eggEntity = new WaterfowlEggEntity(this.thrownEntityType.get(), world, pos.x(), pos.y(), pos.z(), this.mobEntityType.get());
        eggEntity.setItem(stack);
        return eggEntity;
    }
}

