/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Astrological.mixin;

import com.Apothic0n.Astrological.api.AstrologicalJsonReader;
import com.Apothic0n.Astrological.api.AstrologicalMath;
import com.Apothic0n.Astrological.core.objects.AstrologicalBlocks;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Unique
    private static ResourceLocation END_SUN_LOCATION = ResourceLocation.tryBuild((String)"astrological", (String)"textures/environment/end_sun.png");
    @Unique
    private static ResourceLocation SATURN_PHASES_LOCATION = ResourceLocation.tryBuild((String)"astrological", (String)"textures/environment/saturn_phases.png");
    @Unique
    private static int sleepSoundDelay = 19;
    @Unique
    private static int soundDelay = 40;

    @Overwrite
    private void renderEndSky(PoseStack poseStack) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            float time;
            RenderSystem.enableBlend();
            RenderSystem.depthMask((boolean)false);
            Matrix4f matrix4f1 = poseStack.last().pose();
            Tesselator tesselator = Tesselator.getInstance();
            if (AstrologicalJsonReader.customEndSky) {
                RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TheEndPortalRenderer.END_PORTAL_LOCATION);
                for (int i = 0; i < 6; ++i) {
                    poseStack.pushPose();
                    if (i == 1) {
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    }
                    if (i == 2) {
                        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    }
                    if (i == 3) {
                        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    }
                    if (i == 4) {
                        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    }
                    if (i == 5) {
                        poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                    }
                    Matrix4f matrix4f = poseStack.last().pose();
                    BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
                    bufferbuilder.addVertex(matrix4f, -110.0f, -110.0f, -110.0f).setUv(0.0f, 0.0f).setColor(0, 0, 0, 100);
                    bufferbuilder.addVertex(matrix4f, -110.0f, -110.0f, 110.0f).setUv(0.0f, 4.0f).setColor(0, 0, 0, 100);
                    bufferbuilder.addVertex(matrix4f, 110.0f, -110.0f, 110.0f).setUv(4.0f, 4.0f).setColor(0, 0, 0, 100);
                    bufferbuilder.addVertex(matrix4f, 110.0f, -110.0f, -110.0f).setUv(4.0f, 0.0f).setColor(0, 0, 0, 100);
                    BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                    poseStack.popPose();
                }
            }
            if ((time = (float)level.getDayTime()) > 24000.0f) {
                time = (float)((double)time - Math.floor(time / 24000.0f) * 24000.0);
            }
            float finalTime = time;
            Block sleep = (Block)AstrologicalBlocks.SLEEP.get();
            --soundDelay;
            level.players().forEach(player -> {
                if (soundDelay <= 0 && (finalTime >= 22700.0f && finalTime <= 23750.0f || finalTime >= 12500.0f && finalTime <= 13000.0f)) {
                    soundDelay = 40;
                    level.playSound((Player)player, player.blockPosition(), SoundEvents.BEACON_AMBIENT, SoundSource.WEATHER, 0.3f, 1.69f);
                    if (finalTime == 22700.0f || finalTime == 12500.0f) {
                        level.playSound((Player)player, player.blockPosition(), SoundEvents.BEACON_ACTIVATE, SoundSource.AMBIENT, 2.0f, 1.69f);
                    } else if (finalTime == 23750.0f || finalTime == 13000.0f) {
                        level.playSound((Player)player, player.blockPosition(), SoundEvents.BEACON_DEACTIVATE, SoundSource.AMBIENT, 2.0f, 1.69f);
                    }
                }
                double speed = Math.max(player.getDeltaMovement().x(), player.getDeltaMovement().z()) + player.getDeltaMovement().y();
                if ((level.getBlockState(player.blockPosition().below()).is(sleep) || level.getBlockState(player.blockPosition()).is(sleep) || level.getBlockState(player.blockPosition().above()).is(sleep)) && !Minecraft.getInstance().isPaused() && sleepSoundDelay < 0) {
                    sleepSoundDelay = 20;
                    level.playSound((Player)player, player.blockPosition(), SoundEvents.WOOL_STEP, SoundSource.PLAYERS, Math.max((float)(speed * 4.0 + 0.1), 1.0f), Math.max((float)(speed * 8.0 + 0.1), 1.0f));
                }
                sleepSoundDelay -= (int)(speed * 5.0) + 1;
            });
            float f12 = 30.0f;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)END_SUN_LOCATION);
            BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.addVertex(matrix4f1, -f12, 110.0f, -f12).setUv(0.0f, 0.0f);
            bufferbuilder.addVertex(matrix4f1, f12, 110.0f, -f12).setUv(1.0f, 0.0f);
            bufferbuilder.addVertex(matrix4f1, f12, 110.0f, f12).setUv(1.0f, 1.0f);
            bufferbuilder.addVertex(matrix4f1, -f12, 110.0f, f12).setUv(0.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            if (time >= 22000.0f || time <= 500.0f) {
                float o16;
                float o12;
                float o8;
                float o4;
                int mid;
                f12 = 20.0f;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)SATURN_PHASES_LOCATION);
                int k = level.getMoonPhase();
                int l = k % 4;
                int i1 = k / 4 % 2;
                float f13 = (float)l / 4.0f;
                float f14 = (float)i1 / 2.0f;
                float f15 = (float)(l + 1) / 4.0f;
                float f16 = (float)(i1 + 1) / 2.0f;
                int min = 22000;
                int max = 24500;
                float extraTime = time;
                if (extraTime <= 500.0f) {
                    extraTime = 24000.0f + time;
                }
                if (extraTime < (float)(mid = (max - min) / 2 + min)) {
                    max = mid;
                    o4 = AstrologicalMath.invLerp(extraTime, 4.0f, min, max);
                    o8 = AstrologicalMath.invLerp(extraTime, 8.0f, min, max);
                    o12 = AstrologicalMath.invLerp(extraTime, 12.0f, min, max);
                    o16 = AstrologicalMath.invLerp(extraTime, 16.0f, min, max);
                } else {
                    min = mid;
                    o4 = AstrologicalMath.invLerp(extraTime, 4.0f, max, min);
                    o8 = AstrologicalMath.invLerp(extraTime, 8.0f, max, min);
                    o12 = AstrologicalMath.invLerp(extraTime, 12.0f, max, min);
                    o16 = AstrologicalMath.invLerp(extraTime, 16.0f, max, min);
                }
                bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(matrix4f1, -f12 + o8, 100.0f, -f12 + o16).setUv(f15, f16);
                bufferbuilder.addVertex(matrix4f1, f12 + o4, 100.0f, -f12 + o12).setUv(f13, f16);
                bufferbuilder.addVertex(matrix4f1, f12 + o8, 100.0f, f12 + o8).setUv(f13, f14);
                bufferbuilder.addVertex(matrix4f1, -f12 + o12, 100.0f, f12 + o12).setUv(f15, f14);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            } else if (time >= 12000.0f && time <= 13500.0f) {
                float o16;
                float o12;
                float o8;
                float o4;
                f12 = 20.0f;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)SATURN_PHASES_LOCATION);
                int k = level.getMoonPhase();
                int l = k % 4;
                int i1 = k / 4 % 2;
                float f13 = (float)l / 4.0f;
                float f14 = (float)i1 / 2.0f;
                float f15 = (float)(l + 1) / 4.0f;
                float f16 = (float)(i1 + 1) / 2.0f;
                int min = 12000;
                int max = 13500;
                int mid = (max - min) / 2 + min;
                if (time < (float)mid) {
                    max = mid;
                    o4 = AstrologicalMath.invLerp(time, 4.0f, min, max);
                    o8 = AstrologicalMath.invLerp(time, 8.0f, min, max);
                    o12 = AstrologicalMath.invLerp(time, 12.0f, min, max);
                    o16 = AstrologicalMath.invLerp(time, 16.0f, min, max);
                } else {
                    min = mid;
                    o4 = AstrologicalMath.invLerp(time, 4.0f, max, min);
                    o8 = AstrologicalMath.invLerp(time, 8.0f, max, min);
                    o12 = AstrologicalMath.invLerp(time, 12.0f, max, min);
                    o16 = AstrologicalMath.invLerp(time, 16.0f, max, min);
                }
                bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(matrix4f1, -f12 - o8, 100.0f, -f12 - o16).setUv(f15, f16);
                bufferbuilder.addVertex(matrix4f1, f12 - o4, 100.0f, -f12 - o12).setUv(f13, f16);
                bufferbuilder.addVertex(matrix4f1, f12 - o8, 100.0f, f12 - o8).setUv(f13, f14);
                bufferbuilder.addVertex(matrix4f1, -f12 - o12, 100.0f, f12 - o12).setUv(f15, f14);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            } else {
                f12 = 20.0f;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)SATURN_PHASES_LOCATION);
                int k = level.getMoonPhase();
                int l = k % 4;
                int i1 = k / 4 % 2;
                float f13 = (float)l / 4.0f;
                float f14 = (float)i1 / 2.0f;
                float f15 = (float)(l + 1) / 4.0f;
                float f16 = (float)(i1 + 1) / 2.0f;
                bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(matrix4f1, -f12, 100.0f, -f12).setUv(f15, f16);
                bufferbuilder.addVertex(matrix4f1, f12, 100.0f, -f12).setUv(f13, f16);
                bufferbuilder.addVertex(matrix4f1, f12, 100.0f, f12).setUv(f13, f14);
                bufferbuilder.addVertex(matrix4f1, -f12, 100.0f, f12).setUv(f15, f14);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
        }
    }
}

