/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Astrological.core.objects;

import com.Apothic0n.Astrological.core.objects.AstrologicalBlocks;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TendrilsBlock
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.DRIPSTONE_THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final int MAX_SEARCH_LENGTH_WHEN_CHECKING_DRIP_TYPE = 11;
    private static final int DELAY_BEFORE_FALLING = 2;
    private static final float DRIP_PROBABILITY_PER_ANIMATE_TICK = 0.02f;
    private static final float DRIP_PROBABILITY_PER_ANIMATE_TICK_IF_UNDER_LIQUID_SOURCE = 0.12f;
    private static final int MAX_SEARCH_LENGTH_BETWEEN_STALACTITE_TIP_AND_CAULDRON = 11;
    private static final float WATER_TRANSFER_PROBABILITY_PER_RANDOM_TICK = 0.17578125f;
    private static final float LAVA_TRANSFER_PROBABILITY_PER_RANDOM_TICK = 0.05859375f;
    private static final double MIN_TRIDENT_VELOCITY_TO_BREAK_DRIPSTONE = 0.6;
    private static final float STALACTITE_DAMAGE_PER_FALL_DISTANCE_AND_SIZE = 1.0f;
    private static final int STALACTITE_MAX_DAMAGE = 40;
    private static final int MAX_STALACTITE_HEIGHT_FOR_DAMAGE_CALCULATION = 6;
    private static final float STALAGMITE_FALL_DISTANCE_OFFSET = 2.0f;
    private static final int STALAGMITE_FALL_DAMAGE_MODIFIER = 2;
    private static final float AVERAGE_DAYS_PER_GROWTH = 5.0f;
    private static final float GROWTH_PROBABILITY_PER_RANDOM_TICK = 0.011377778f;
    private static final int MAX_GROWTH_LENGTH = 7;
    private static final int MAX_STALAGMITE_SEARCH_RANGE_WHEN_GROWING = 10;
    private static final float STALACTITE_DRIP_START_PIXEL = 0.6875f;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final float MAX_HORIZONTAL_OFFSET = 0.125f;
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public TendrilsBlock(BlockBehaviour.Properties p_154025_) {
        super(p_154025_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TIP_DIRECTION, (Comparable)Direction.UP)).setValue(THICKNESS, (Comparable)DripstoneThickness.TIP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_154157_) {
        p_154157_.add(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean canSurvive(BlockState p_154137_, LevelReader p_154138_, BlockPos p_154139_) {
        return TendrilsBlock.isValidPointedDripstonePlacement(p_154138_, p_154139_, (Direction)p_154137_.getValue((Property)TIP_DIRECTION));
    }

    public BlockState updateShape(BlockState p_154147_, Direction p_154148_, BlockState p_154149_, LevelAccessor p_154150_, BlockPos p_154151_, BlockPos p_154152_) {
        if (((Boolean)p_154147_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_154150_.scheduleTick(p_154151_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_154150_));
        }
        if (p_154148_ != Direction.UP && p_154148_ != Direction.DOWN) {
            return p_154147_;
        }
        Direction direction = (Direction)p_154147_.getValue((Property)TIP_DIRECTION);
        if (direction == Direction.DOWN && p_154150_.getBlockTicks().hasScheduledTick(p_154151_, (Object)this)) {
            return p_154147_;
        }
        if (p_154148_ == direction.getOpposite() && !this.canSurvive(p_154147_, (LevelReader)p_154150_, p_154151_)) {
            if (direction == Direction.DOWN) {
                p_154150_.scheduleTick(p_154151_, (Block)this, 2);
            } else {
                p_154150_.scheduleTick(p_154151_, (Block)this, 1);
            }
            return p_154147_;
        }
        boolean flag = p_154147_.getValue(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = TendrilsBlock.calculateDripstoneThickness((LevelReader)p_154150_, p_154151_, direction, flag);
        return (BlockState)p_154147_.setValue(THICKNESS, (Comparable)dripstonethickness);
    }

    public void onProjectileHit(Level p_154042_, BlockState p_154043_, BlockHitResult p_154044_, Projectile p_154045_) {
        BlockPos blockpos = p_154044_.getBlockPos();
        if (!p_154042_.isClientSide && p_154045_.mayInteract(p_154042_, blockpos) && p_154045_ instanceof ThrownTrident && p_154045_.getDeltaMovement().length() > 0.6) {
            p_154042_.destroyBlock(blockpos, true);
        }
    }

    public void fallOn(Level p_154047_, BlockState p_154048_, BlockPos p_154049_, Entity p_154050_, float p_154051_) {
        if (p_154048_.getValue((Property)TIP_DIRECTION) == Direction.UP && p_154048_.getValue(THICKNESS) == DripstoneThickness.TIP) {
            p_154050_.causeFallDamage(p_154051_ + 2.0f, 2.0f, p_154047_.damageSources().stalagmite());
        } else {
            super.fallOn(p_154047_, p_154048_, p_154049_, p_154050_, p_154051_);
        }
    }

    public void animateTick(BlockState p_221870_, Level p_221871_, BlockPos p_221872_, RandomSource p_221873_) {
        float f;
        if (TendrilsBlock.canDrip(p_221870_) && !((f = p_221873_.nextFloat()) > 0.12f)) {
            TendrilsBlock.getFluidAboveStalactite(p_221871_, p_221872_, p_221870_).filter(p_221848_ -> f < 0.02f || TendrilsBlock.canFillCauldron(p_221848_.fluid)).ifPresent(p_221881_ -> TendrilsBlock.spawnDripParticle(p_221871_, p_221872_, p_221870_, p_221881_.fluid));
        }
    }

    public void tick(BlockState p_221865_, ServerLevel p_221866_, BlockPos p_221867_, RandomSource p_221868_) {
        if (TendrilsBlock.isStalagmite(p_221865_) && !this.canSurvive(p_221865_, (LevelReader)p_221866_, p_221867_)) {
            p_221866_.destroyBlock(p_221867_, true);
        } else {
            TendrilsBlock.spawnFallingStalactite(p_221865_, p_221866_, p_221867_);
        }
    }

    public void randomTick(BlockState p_221883_, ServerLevel p_221884_, BlockPos p_221885_, RandomSource p_221886_) {
        TendrilsBlock.maybeTransferFluid(p_221883_, p_221884_, p_221885_, p_221886_.nextFloat());
        if (p_221886_.nextFloat() < 0.011377778f && TendrilsBlock.isStalactiteStartPos(p_221883_, (LevelReader)p_221884_, p_221885_)) {
            TendrilsBlock.growStalactiteOrStalagmiteIfPossible(p_221883_, p_221884_, p_221885_, p_221886_);
        }
    }

    @VisibleForTesting
    public static void maybeTransferFluid(BlockState p_221860_, ServerLevel p_221861_, BlockPos p_221862_, float p_221863_) {
        Optional<FluidInfo> optional;
        if (!(p_221863_ > 0.17578125f && p_221863_ > 0.05859375f || !TendrilsBlock.isStalactiteStartPos(p_221860_, (LevelReader)p_221861_, p_221862_) || (optional = TendrilsBlock.getFluidAboveStalactite((Level)p_221861_, p_221862_, p_221860_)).isEmpty())) {
            BlockPos blockpos;
            float f;
            Fluid fluid = optional.get().fluid;
            if (fluid == Fluids.WATER) {
                f = 0.17578125f;
            } else {
                if (fluid != Fluids.LAVA) {
                    return;
                }
                f = 0.05859375f;
            }
            if (!(p_221863_ >= f) && (blockpos = TendrilsBlock.findTip(p_221860_, (LevelAccessor)p_221861_, p_221862_, 11, false)) != null) {
                if (optional.get().sourceState.is(Blocks.END_STONE)) {
                    BlockState blockstate1 = ((Block)AstrologicalBlocks.TUMOR.get()).defaultBlockState();
                    p_221861_.setBlockAndUpdate(optional.get().pos, blockstate1);
                    Block.pushEntitiesUp((BlockState)optional.get().sourceState, (BlockState)blockstate1, (LevelAccessor)p_221861_, (BlockPos)optional.get().pos);
                    p_221861_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, optional.get().pos, GameEvent.Context.of((BlockState)blockstate1));
                    p_221861_.levelEvent(1504, blockpos, 0);
                } else {
                    BlockPos blockpos1 = TendrilsBlock.findFillableCauldronBelowStalactiteTip((Level)p_221861_, blockpos, fluid);
                    if (blockpos1 != null) {
                        p_221861_.levelEvent(1504, blockpos, 0);
                        int i = blockpos.getY() - blockpos1.getY();
                        int j = 50 + i;
                        BlockState blockstate = p_221861_.getBlockState(blockpos1);
                        p_221861_.scheduleTick(blockpos1, blockstate.getBlock(), j);
                    }
                }
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_154040_) {
        Direction direction;
        BlockPos blockpos;
        Level levelaccessor = p_154040_.getLevel();
        Direction direction1 = TendrilsBlock.calculateTipDirection((LevelReader)levelaccessor, blockpos = p_154040_.getClickedPos(), direction = p_154040_.getNearestLookingVerticalDirection().getOpposite());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !p_154040_.isSecondaryUseActive();
        DripstoneThickness dripstonethickness = TendrilsBlock.calculateDripstoneThickness((LevelReader)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)direction1)).setValue(THICKNESS, (Comparable)dripstonethickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.getFluidState(blockpos).getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState p_154235_) {
        return (Boolean)p_154235_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_154235_);
    }

    public VoxelShape getOcclusionShape(BlockState p_154170_, BlockGetter p_154171_, BlockPos p_154172_) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState p_154117_, BlockGetter p_154118_, BlockPos p_154119_, CollisionContext p_154120_) {
        DripstoneThickness dripstonethickness = (DripstoneThickness)p_154117_.getValue(THICKNESS);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (dripstonethickness == DripstoneThickness.TIP ? (p_154117_.getValue((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstonethickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (dripstonethickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3 = p_154117_.getOffset(p_154118_, p_154119_);
        return voxelshape.move(vec3.x, 0.0, vec3.z);
    }

    public boolean isCollisionShapeFullBlock(BlockState p_181235_, BlockGetter p_181236_, BlockPos p_181237_) {
        return false;
    }

    public float getMaxHorizontalOffset() {
        return 0.125f;
    }

    public void onBrokenAfterFall(Level p_154059_, BlockPos p_154060_, FallingBlockEntity p_154061_) {
        if (!p_154061_.isSilent()) {
            p_154059_.levelEvent(1045, p_154060_, 0);
        }
    }

    public DamageSource getFallDamageSource(Entity p_254432_) {
        return p_254432_.damageSources().fallingStalactite(p_254432_);
    }

    private static void spawnFallingStalactite(BlockState p_154098_, ServerLevel p_154099_, BlockPos p_154100_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_154100_.mutable();
        BlockState blockstate = p_154098_;
        while (TendrilsBlock.isStalactite(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)p_154099_, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
            if (TendrilsBlock.isTip(blockstate, true)) {
                int i = Math.max(1 + p_154100_.getY() - blockpos$mutableblockpos.getY(), 6);
                float f = 1.0f * (float)i;
                fallingblockentity.setHurtsEntities(f, 40);
                break;
            }
            blockpos$mutableblockpos.move(Direction.DOWN);
            blockstate = p_154099_.getBlockState((BlockPos)blockpos$mutableblockpos);
        }
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(BlockState p_221888_, ServerLevel p_221889_, BlockPos p_221890_, RandomSource p_221891_) {
        BlockState blockstate2;
        BlockPos blockpos;
        BlockState blockstate1;
        BlockState blockstate = p_221889_.getBlockState(p_221890_.above(1));
        if (TendrilsBlock.canGrow(blockstate, blockstate1 = p_221889_.getBlockState(p_221890_.above(2))) && (blockpos = TendrilsBlock.findTip(p_221888_, (LevelAccessor)p_221889_, p_221890_, 7, false)) != null && TendrilsBlock.canDrip(blockstate2 = p_221889_.getBlockState(blockpos)) && TendrilsBlock.canTipGrow(blockstate2, p_221889_, blockpos)) {
            if (p_221891_.nextBoolean()) {
                TendrilsBlock.grow(p_221889_, blockpos, Direction.DOWN);
            } else {
                TendrilsBlock.growStalagmiteBelow(p_221889_, blockpos);
            }
        }
    }

    private static void growStalagmiteBelow(ServerLevel p_154033_, BlockPos p_154034_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_154034_.mutable();
        for (int i = 0; i < 10; ++i) {
            blockpos$mutableblockpos.move(Direction.DOWN);
            BlockState blockstate = p_154033_.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (!blockstate.getFluidState().isEmpty()) {
                return;
            }
            if (TendrilsBlock.isUnmergedTipWithDirection(blockstate, Direction.UP) && TendrilsBlock.canTipGrow(blockstate, p_154033_, (BlockPos)blockpos$mutableblockpos)) {
                TendrilsBlock.grow(p_154033_, (BlockPos)blockpos$mutableblockpos, Direction.UP);
                return;
            }
            if (TendrilsBlock.isValidPointedDripstonePlacement((LevelReader)p_154033_, (BlockPos)blockpos$mutableblockpos, Direction.UP) && !p_154033_.isWaterAt(blockpos$mutableblockpos.below())) {
                TendrilsBlock.grow(p_154033_, blockpos$mutableblockpos.below(), Direction.UP);
                return;
            }
            if (TendrilsBlock.canDripThrough((BlockGetter)p_154033_, (BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return;
        }
    }

    private static void grow(ServerLevel p_154036_, BlockPos p_154037_, Direction p_154038_) {
        BlockPos blockpos = p_154037_.relative(p_154038_);
        BlockState blockstate = p_154036_.getBlockState(blockpos);
        if (TendrilsBlock.isUnmergedTipWithDirection(blockstate, p_154038_.getOpposite())) {
            TendrilsBlock.createMergedTips(blockstate, (LevelAccessor)p_154036_, blockpos);
        } else if (blockstate.isAir() || blockstate.is(Blocks.WATER)) {
            TendrilsBlock.createDripstone((LevelAccessor)p_154036_, blockpos, p_154038_, DripstoneThickness.TIP);
        }
    }

    private static void createDripstone(LevelAccessor p_154088_, BlockPos p_154089_, Direction p_154090_, DripstoneThickness p_154091_) {
        BlockState blockstate = (BlockState)((BlockState)((BlockState)((Block)AstrologicalBlocks.TENDRILS.get()).defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)p_154090_)).setValue(THICKNESS, (Comparable)p_154091_)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(p_154088_.getFluidState(p_154089_).getType() == Fluids.WATER));
        p_154088_.setBlock(p_154089_, blockstate, 3);
    }

    private static void createMergedTips(BlockState p_154231_, LevelAccessor p_154232_, BlockPos p_154233_) {
        BlockPos blockpos;
        BlockPos blockpos1;
        if (p_154231_.getValue((Property)TIP_DIRECTION) == Direction.UP) {
            blockpos1 = p_154233_;
            blockpos = p_154233_.above();
        } else {
            blockpos = p_154233_;
            blockpos1 = p_154233_.below();
        }
        TendrilsBlock.createDripstone(p_154232_, blockpos, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        TendrilsBlock.createDripstone(p_154232_, blockpos1, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    public static void spawnDripParticle(Level p_154063_, BlockPos p_154064_, BlockState p_154065_) {
        TendrilsBlock.getFluidAboveStalactite(p_154063_, p_154064_, p_154065_).ifPresent(p_221856_ -> TendrilsBlock.spawnDripParticle(p_154063_, p_154064_, p_154065_, p_221856_.fluid));
    }

    private static void spawnDripParticle(Level p_154072_, BlockPos p_154073_, BlockState p_154074_, Fluid p_154075_) {
        Vec3 vec3 = p_154074_.getOffset((BlockGetter)p_154072_, p_154073_);
        double d0 = 0.0625;
        double d1 = (double)p_154073_.getX() + 0.5 + vec3.x;
        double d2 = (double)((float)(p_154073_.getY() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)p_154073_.getZ() + 0.5 + vec3.z;
        Fluid fluid = TendrilsBlock.getDripFluid(p_154072_, p_154075_);
        SimpleParticleType particleoptions = fluid.is(FluidTags.LAVA) ? ParticleTypes.DRIPPING_DRIPSTONE_LAVA : ParticleTypes.DRIPPING_DRIPSTONE_WATER;
        p_154072_.addParticle((ParticleOptions)particleoptions, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPos findTip(BlockState p_154131_, LevelAccessor p_154132_, BlockPos p_154133_, int p_154134_, boolean p_154135_) {
        if (TendrilsBlock.isTip(p_154131_, p_154135_)) {
            return p_154133_;
        }
        Direction direction = (Direction)p_154131_.getValue((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202023_, p_202024_) -> p_202024_.is((Block)AstrologicalBlocks.TENDRILS.get()) && p_202024_.getValue((Property)TIP_DIRECTION) == direction;
        return TendrilsBlock.findBlockVertical(p_154132_, p_154133_, direction.getAxisDirection(), bipredicate, p_154168_ -> TendrilsBlock.isTip(p_154168_, p_154135_), p_154134_).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader p_154191_, BlockPos p_154192_, Direction p_154193_) {
        Direction direction;
        if (TendrilsBlock.isValidPointedDripstonePlacement(p_154191_, p_154192_, p_154193_)) {
            direction = p_154193_;
        } else {
            if (!TendrilsBlock.isValidPointedDripstonePlacement(p_154191_, p_154192_, p_154193_.getOpposite())) {
                return null;
            }
            direction = p_154193_.getOpposite();
        }
        return direction;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader p_154093_, BlockPos p_154094_, Direction p_154095_, boolean p_154096_) {
        Direction direction = p_154095_.getOpposite();
        BlockState blockstate = p_154093_.getBlockState(p_154094_.relative(p_154095_));
        if (TendrilsBlock.isPointedDripstoneWithDirection(blockstate, direction)) {
            return !p_154096_ && blockstate.getValue(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!TendrilsBlock.isPointedDripstoneWithDirection(blockstate, p_154095_)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)blockstate.getValue(THICKNESS);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockstate1 = p_154093_.getBlockState(p_154094_.relative(direction));
            return !TendrilsBlock.isPointedDripstoneWithDirection(blockstate1, p_154095_) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState p_154239_) {
        return TendrilsBlock.isStalactite(p_154239_) && p_154239_.getValue(THICKNESS) == DripstoneThickness.TIP && (Boolean)p_154239_.getValue((Property)WATERLOGGED) == false;
    }

    private static boolean canTipGrow(BlockState p_154195_, ServerLevel p_154196_, BlockPos p_154197_) {
        Direction direction = (Direction)p_154195_.getValue((Property)TIP_DIRECTION);
        BlockPos blockpos = p_154197_.relative(direction);
        BlockState blockstate = p_154196_.getBlockState(blockpos);
        if (!blockstate.getFluidState().isEmpty()) {
            return false;
        }
        return blockstate.isAir() ? true : TendrilsBlock.isUnmergedTipWithDirection(blockstate, direction.getOpposite());
    }

    private static Optional<BlockPos> findRootBlock(Level p_154067_, BlockPos p_154068_, BlockState p_154069_, int p_154070_) {
        Direction direction = (Direction)p_154069_.getValue((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202015_, p_202016_) -> p_202016_.is((Block)AstrologicalBlocks.TENDRILS.get()) && p_202016_.getValue((Property)TIP_DIRECTION) == direction;
        return TendrilsBlock.findBlockVertical((LevelAccessor)p_154067_, p_154068_, direction.getOpposite().getAxisDirection(), bipredicate, p_154245_ -> !p_154245_.is((Block)AstrologicalBlocks.TENDRILS.get()), p_154070_);
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader p_154222_, BlockPos p_154223_, Direction p_154224_) {
        BlockPos blockpos = p_154223_.relative(p_154224_.getOpposite());
        BlockState blockstate = p_154222_.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)p_154222_, blockpos, p_154224_) || TendrilsBlock.isPointedDripstoneWithDirection(blockstate, p_154224_);
    }

    private static boolean isTip(BlockState p_154154_, boolean p_154155_) {
        if (!p_154154_.is((Block)AstrologicalBlocks.TENDRILS.get())) {
            return false;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)p_154154_.getValue(THICKNESS);
        return dripstonethickness == DripstoneThickness.TIP || p_154155_ && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState p_154144_, Direction p_154145_) {
        return TendrilsBlock.isTip(p_154144_, false) && p_154144_.getValue((Property)TIP_DIRECTION) == p_154145_;
    }

    private static boolean isStalactite(BlockState p_154241_) {
        return TendrilsBlock.isPointedDripstoneWithDirection(p_154241_, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState p_154243_) {
        return TendrilsBlock.isPointedDripstoneWithDirection(p_154243_, Direction.UP);
    }

    private static boolean isStalactiteStartPos(BlockState p_154204_, LevelReader p_154205_, BlockPos p_154206_) {
        return TendrilsBlock.isStalactite(p_154204_) && !p_154205_.getBlockState(p_154206_.above()).is((Block)AstrologicalBlocks.TENDRILS.get());
    }

    public boolean isPathfindable(BlockState p_154112_, BlockGetter p_154113_, BlockPos p_154114_, PathComputationType p_154115_) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(BlockState p_154208_, Direction p_154209_) {
        return p_154208_.is((Block)AstrologicalBlocks.TENDRILS.get()) && p_154208_.getValue((Property)TIP_DIRECTION) == p_154209_;
    }

    @Nullable
    private static BlockPos findFillableCauldronBelowStalactiteTip(Level p_154077_, BlockPos p_154078_, Fluid p_154079_) {
        Predicate<BlockState> predicate = p_154162_ -> p_154162_.getBlock() instanceof AbstractCauldronBlock && (((AbstractCauldronBlock)p_154162_.getBlock()).equals(Blocks.WATER) || ((AbstractCauldronBlock)p_154162_.getBlock()).equals(Blocks.LAVA));
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202034_, p_202035_) -> TendrilsBlock.canDripThrough((BlockGetter)p_154077_, p_202034_, p_202035_);
        return TendrilsBlock.findBlockVertical((LevelAccessor)p_154077_, p_154078_, Direction.DOWN.getAxisDirection(), bipredicate, predicate, 11).orElse(null);
    }

    @Nullable
    public static BlockPos findStalactiteTipAboveCauldron(Level p_154056_, BlockPos p_154057_) {
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202030_, p_202031_) -> TendrilsBlock.canDripThrough((BlockGetter)p_154056_, p_202030_, p_202031_);
        return TendrilsBlock.findBlockVertical((LevelAccessor)p_154056_, p_154057_, Direction.UP.getAxisDirection(), bipredicate, TendrilsBlock::canDrip, 11).orElse(null);
    }

    public static Fluid getCauldronFillFluidType(ServerLevel p_221850_, BlockPos p_221851_) {
        return TendrilsBlock.getFluidAboveStalactite((Level)p_221850_, p_221851_, p_221850_.getBlockState(p_221851_)).map(p_221858_ -> p_221858_.fluid).filter(TendrilsBlock::canFillCauldron).orElse(Fluids.EMPTY);
    }

    private static Optional<FluidInfo> getFluidAboveStalactite(Level p_154182_, BlockPos p_154183_, BlockState p_154184_) {
        return !TendrilsBlock.isStalactite(p_154184_) ? Optional.empty() : TendrilsBlock.findRootBlock(p_154182_, p_154183_, p_154184_, 11).map(p_221876_ -> {
            BlockPos blockpos = p_221876_.above();
            BlockState blockstate = p_154182_.getBlockState(blockpos);
            Object fluid = blockstate.is(Blocks.MUD) && !p_154182_.dimensionType().ultraWarm() ? Fluids.WATER : p_154182_.getFluidState(blockpos).getType();
            return new FluidInfo(blockpos, (Fluid)fluid, blockstate);
        });
    }

    private static boolean canFillCauldron(Fluid p_154159_) {
        return p_154159_ == Fluids.LAVA || p_154159_ == Fluids.WATER;
    }

    private static boolean canGrow(BlockState p_154141_, BlockState p_154142_) {
        return p_154141_.is((Block)AstrologicalBlocks.TUMOR.get()) && p_154142_.is(Blocks.WATER) && p_154142_.getFluidState().isSource();
    }

    private static Fluid getDripFluid(Level p_154053_, Fluid p_154054_) {
        if (p_154054_.isSame(Fluids.EMPTY)) {
            return p_154053_.dimensionType().ultraWarm() ? Fluids.LAVA : Fluids.WATER;
        }
        return p_154054_;
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor p_202007_, BlockPos p_202008_, Direction.AxisDirection p_202009_, BiPredicate<BlockPos, BlockState> p_202010_, Predicate<BlockState> p_202011_, int p_202012_) {
        Direction direction = Direction.get((Direction.AxisDirection)p_202009_, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_202008_.mutable();
        for (int i = 1; i < p_202012_; ++i) {
            blockpos$mutableblockpos.move(direction);
            BlockState blockstate = p_202007_.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (p_202011_.test(blockstate)) {
                return Optional.of(blockpos$mutableblockpos.immutable());
            }
            if (!p_202007_.isOutsideBuildHeight(blockpos$mutableblockpos.getY()) && p_202010_.test((BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(BlockGetter p_202018_, BlockPos p_202019_, BlockState p_202020_) {
        if (p_202020_.isAir()) {
            return true;
        }
        if (p_202020_.isSolidRender(p_202018_, p_202019_)) {
            return false;
        }
        if (!p_202020_.getFluidState().isEmpty()) {
            return false;
        }
        VoxelShape voxelshape = p_202020_.getCollisionShape(p_202018_, p_202019_);
        return !Shapes.joinIsNotEmpty((VoxelShape)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (VoxelShape)voxelshape, (BooleanOp)BooleanOp.AND);
    }

    record FluidInfo(BlockPos pos, Fluid fluid, BlockState sourceState) {
    }
}

