/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Astrological.core.objects;

import com.Apothic0n.Astrological.core.objects.AstrologicalBlockEntities;
import com.Apothic0n.Astrological.core.objects.PrismaticBlockEntity;
import com.Apothic0n.Astrological.core.objects.PrismaticWallBlockEntity;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public class PrismaticWallBlock
extends WallBlock
implements EntityBlock {
    public PrismaticWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PrismaticBlockEntity.PRISMATIC_POWER, (Comparable)Integer.valueOf(0))).setValue((Property)PrismaticBlockEntity.USELESS_TOGGLE, (Comparable)Boolean.valueOf(false)));
        this.fixShapeMaps();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PrismaticBlockEntity.PRISMATIC_POWER, PrismaticBlockEntity.USELESS_TOGGLE});
    }

    public void onProjectileHit(Level level, BlockState blockState, BlockHitResult blockHitResult, Projectile projectile) {
        if (!level.isClientSide) {
            BlockPos blockpos = blockHitResult.getBlockPos();
            level.playSound((Player)null, blockpos, SoundEvents.AMETHYST_BLOCK_HIT, SoundSource.BLOCKS, 2.0f, 2.03f + level.random.nextFloat() * 0.02f);
            level.playSound((Player)null, blockpos, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, 2.0f, 2.03f + level.random.nextFloat() * 0.02f);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return PrismaticWallBlockEntity::tick;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)AstrologicalBlockEntities.SELENITE_WALL.get()).create(blockPos, blockState);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getFriction() {
        ClientLevel level = Minecraft.getInstance().level;
        float newFriction = this.friction;
        if (level != null) {
            float time = level.getDayTime();
            if (time > 24000.0f) {
                time = (float)((double)time - Math.floor(time / 24000.0f) * 24000.0);
            }
            if (time >= 22000.0f || time <= 500.0f || time >= 12000.0f && time <= 13500.0f) {
                newFriction = 1.15f;
            } else if (time <= 12000.0f) {
                newFriction = 0.2f;
            }
        }
        return newFriction;
    }

    private void fixShapeMaps() {
        Map<BlockState, VoxelShape> shapeByIndex = (Map<BlockState, VoxelShape>)ObfuscationReflectionHelper.getPrivateValue(WallBlock.class, (Object)((Object)this), (String)"shapeByIndex");
        shapeByIndex = PrismaticWallBlock.fixShapeMap(shapeByIndex);
        ObfuscationReflectionHelper.setPrivateValue(WallBlock.class, (Object)((Object)this), shapeByIndex, (String)"shapeByIndex");
        Map<BlockState, VoxelShape> collisionShapeByIndex = (Map<BlockState, VoxelShape>)ObfuscationReflectionHelper.getPrivateValue(WallBlock.class, (Object)((Object)this), (String)"collisionShapeByIndex");
        collisionShapeByIndex = PrismaticWallBlock.fixShapeMap(collisionShapeByIndex);
        ObfuscationReflectionHelper.setPrivateValue(WallBlock.class, (Object)((Object)this), collisionShapeByIndex, (String)"collisionShapeByIndex");
    }

    private static Map<BlockState, VoxelShape> fixShapeMap(Map<BlockState, VoxelShape> map) {
        Preconditions.checkNotNull(map, (Object)"Got a null map?!");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : map.keySet()) {
            VoxelShape shape = map.get(state);
            Iterator iterator = PrismaticBlockEntity.PRISMATIC_POWER.getPossibleValues().iterator();
            while (iterator.hasNext()) {
                int prismaticPower = (Integer)iterator.next();
                state = (BlockState)state.setValue((Property)PrismaticBlockEntity.PRISMATIC_POWER, (Comparable)Integer.valueOf(prismaticPower));
                builder.put((Object)state, (Object)shape);
                builder.put((Object)((BlockState)state.cycle((Property)PrismaticBlockEntity.USELESS_TOGGLE)), (Object)shape);
            }
        }
        return builder.build();
    }
}

