/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Astrological.core.objects;

import com.Apothic0n.Astrological.core.objects.CryingDuctBlock;
import com.Apothic0n.Astrological.core.objects.CryoFireBlock;
import com.Apothic0n.Astrological.core.objects.HalfTransparentRotatedPillarBlock;
import com.Apothic0n.Astrological.core.objects.InsomniaVentBlock;
import com.Apothic0n.Astrological.core.objects.JadeBlock;
import com.Apothic0n.Astrological.core.objects.PrismaticBlock;
import com.Apothic0n.Astrological.core.objects.PrismaticBlockEntity;
import com.Apothic0n.Astrological.core.objects.PrismaticWallBlock;
import com.Apothic0n.Astrological.core.objects.TendrilsBlock;
import com.Apothic0n.Astrological.core.objects.TriphyliteBlock;
import com.Apothic0n.Astrological.core.sounds.AstrologicalSoundTypes;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MangroveRootsBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class AstrologicalBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"astrological");
    public static final DeferredHolder<Block, Block> SLEEP = BLOCKS.register("sleep", () -> new MangroveRootsBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.BASS).strength(0.4f).randomTicks().sound(SoundType.WOOL).noOcclusion().noCollission()));
    public static final DeferredHolder<Block, Block> TENDRILS = BLOCKS.register("tendrils", () -> new TendrilsBlock(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BLUE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noOcclusion().noCollission().sound(SoundType.MUD).randomTicks().strength(0.66f, 1.5f).dynamicShape().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)));
    public static final DeferredHolder<Block, Block> TUMOR = BLOCKS.register("tumor", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_GREEN).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(SoundType.MUD).strength(0.66f, 1.5f)));
    public static final DeferredHolder<Block, Block> CRYING_DUCT = BLOCKS.register("crying_duct", () -> new CryingDuctBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).forceSolidOn().instrument(NoteBlockInstrument.HAT).requiresCorrectToolForDrops().noOcclusion().sound(AstrologicalSoundTypes.GLASSY_OBSIDIAN).randomTicks().strength(1.5f, 3.0f).dynamicShape().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)));
    public static final DeferredHolder<Block, Block> INSOMNIA_VENT = BLOCKS.register("insomnia_vent", () -> new InsomniaVentBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).randomTicks().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(SoundType.STONE).strength(1.5f, 3.0f)));
    public static final DeferredHolder<Block, Block> CRYO_FIRE = BLOCKS.register("cryo_fire", () -> new CryoFireBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).replaceable().noCollission().instabreak().lightLevel(p_152607_ -> 7).requiresCorrectToolForDrops().sound(SoundType.WOOL).pushReaction(PushReaction.DESTROY)));
    public static final DeferredHolder<Block, Block> OCHRE_SELENITE = BLOCKS.register("ochre_selenite", () -> new HalfTransparentRotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).friction(0.989f).instrument(NoteBlockInstrument.HAT).lightLevel(p_152607_ -> 15).requiresCorrectToolForDrops().strength(1.25f, 4.2f).sound(AstrologicalSoundTypes.SELENITE).noOcclusion()));
    public static final DeferredHolder<Block, Block> VERDANT_SELENITE = BLOCKS.register("verdant_selenite", () -> new HalfTransparentRotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.GLOW_LICHEN).friction(0.989f).instrument(NoteBlockInstrument.HAT).lightLevel(p_152607_ -> 15).requiresCorrectToolForDrops().strength(1.25f, 4.2f).sound(AstrologicalSoundTypes.SELENITE).noOcclusion()));
    public static final DeferredHolder<Block, Block> PEARLESCENT_SELENITE = BLOCKS.register("pearlescent_selenite", () -> new HalfTransparentRotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).friction(0.989f).instrument(NoteBlockInstrument.HAT).lightLevel(p_152607_ -> 15).requiresCorrectToolForDrops().strength(1.25f, 4.2f).sound(AstrologicalSoundTypes.SELENITE).noOcclusion()));
    public static final DeferredHolder<Block, Block> PURPURITE = BLOCKS.register("purpurite", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(0.4f).sound(SoundType.WOOD).requiresCorrectToolForDrops()));
    public static final DeferredHolder<Block, Block> SELENITE_WALL = BLOCKS.register("selenite_wall", () -> new PrismaticWallBlock(BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).friction(0.989f).instrument(NoteBlockInstrument.HAT).lightLevel(AstrologicalBlocks.prismaticEmission(15)).requiresCorrectToolForDrops().strength(1.25f, 4.2f).sound(AstrologicalSoundTypes.SELENITE)));
    public static final DeferredHolder<Block, Block> PRISMATIC_SELENITE = BLOCKS.register("prismatic_selenite", () -> new PrismaticBlock(BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).friction(0.989f).instrument(NoteBlockInstrument.HAT).lightLevel(AstrologicalBlocks.prismaticEmission(15)).requiresCorrectToolForDrops().strength(1.25f, 4.2f).sound(AstrologicalSoundTypes.SELENITE)));
    public static final DeferredHolder<Block, Block> TRIPHYLITE = BLOCKS.register("triphylite", () -> new TriphyliteBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(1.5f).sound(AstrologicalSoundTypes.TRIPHYLITE).requiresCorrectToolForDrops()));
    public static final DeferredHolder<Block, Block> JADE = BLOCKS.register("jade", () -> new JadeBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).strength(1.5f).sound(AstrologicalSoundTypes.JADE).lightLevel(p_152607_ -> 1).hasPostProcess((state, getter, pos) -> true).emissiveRendering((state, getter, pos) -> true).requiresCorrectToolForDrops()));
    public static final DeferredHolder<Block, Block> REINFORCED_JADE = BLOCKS.register("reinforced_jade", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).friction(1.1f).requiresCorrectToolForDrops().strength(1.25f, 4.2f).sound(AstrologicalSoundTypes.JADE)));
    public static final DeferredHolder<Block, Block> JADE_BRICKS = BLOCKS.register("jade_bricks", () -> new JadeBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).strength(1.5f).sound(AstrologicalSoundTypes.JADE).requiresCorrectToolForDrops()));
    public static final DeferredHolder<Block, Block> POLISHED_JADE = BLOCKS.register("polished_jade", () -> new JadeBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).strength(1.5f).sound(AstrologicalSoundTypes.JADE).requiresCorrectToolForDrops()));
    public static final DeferredHolder<Block, Block> MARBLED_JADE_SLAB = BLOCKS.register("marbled_jade_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).strength(1.5f).sound(AstrologicalSoundTypes.JADE).requiresCorrectToolForDrops()));
    public static final DeferredHolder<Block, Block> LIGHT_JADE = BLOCKS.register("light_jade", () -> new JadeBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN).strength(1.5f).sound(AstrologicalSoundTypes.JADE).lightLevel(p_152607_ -> 1).hasPostProcess((state, getter, pos) -> true).emissiveRendering((state, getter, pos) -> true).requiresCorrectToolForDrops()));
    public static final DeferredHolder<Block, Block> LIGHT_JADE_TILES = BLOCKS.register("light_jade_tiles", () -> new JadeBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).strength(1.5f).sound(AstrologicalSoundTypes.JADE).requiresCorrectToolForDrops()));
    public static final DeferredHolder<Block, Block> CRACKED_LIGHT_JADE_TILES = BLOCKS.register("cracked_light_jade_tiles", () -> new JadeBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).strength(1.5f).sound(AstrologicalSoundTypes.JADE).requiresCorrectToolForDrops()));
    public static final DeferredHolder<Block, Block> PURPURITE_TILES = BLOCKS.register("purpurite_tiles", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(0.4f).sound(SoundType.WOOD).requiresCorrectToolForDrops()));
    public static List<Pair<String, DeferredHolder<Block, Block>>> blocksWithStairsSlabsAndWalls = List.of(Pair.of((Object)"purpurite", PURPURITE), Pair.of((Object)"purpurite_tiles", PURPURITE_TILES), Pair.of((Object)"triphylite", TRIPHYLITE), Pair.of((Object)"jade", JADE), Pair.of((Object)"jade_bricks", JADE_BRICKS), Pair.of((Object)"polished_jade", POLISHED_JADE), Pair.of((Object)"reinforced_jade", REINFORCED_JADE), Pair.of((Object)"light_jade", LIGHT_JADE), Pair.of((Object)"light_jade_tiles", LIGHT_JADE_TILES), Pair.of((Object)"cracked_light_jade_tiles", CRACKED_LIGHT_JADE_TILES));
    public static final List<Pair<String, DeferredHolder<Block, Block>>> wallBlocks = new ArrayList<Pair<String, DeferredHolder<Block, Block>>>(List.of());
    public static final List<Pair<String, DeferredHolder<Block, Block>>> stairBlocks = new ArrayList<Pair<String, DeferredHolder<Block, Block>>>(List.of());
    public static final List<Pair<String, DeferredHolder<Block, Block>>> slabBlocks = new ArrayList<Pair<String, DeferredHolder<Block, Block>>>(List.of());

    private AstrologicalBlocks() {
    }

    private static ToIntFunction<BlockState> prismaticEmission(int max) {
        return blockState -> {
            int power = (Integer)blockState.getValue((Property)PrismaticBlockEntity.PRISMATIC_POWER);
            if (power > 0) {
                power /= 2;
            }
            if (power > max) {
                power = max;
            }
            return power;
        };
    }

    public static void fixBlockRenderLayers() {
        CryoFireBlock.bootStrap();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SLEEP.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OCHRE_SELENITE.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)VERDANT_SELENITE.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)PEARLESCENT_SELENITE.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TENDRILS.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CRYING_DUCT.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CRYO_FIRE.get()), (RenderType)RenderType.cutout());
    }

    public static void generateStairsSlabsWalls() {
        for (int i = 0; i < blocksWithStairsSlabsAndWalls.size(); ++i) {
            Pair<String, DeferredHolder<Block, Block>> baseBlock = blocksWithStairsSlabsAndWalls.get(i);
            wallBlocks.add(AstrologicalBlocks.createWallBlocks(baseBlock));
            stairBlocks.add(AstrologicalBlocks.createStairBlocks(baseBlock));
            slabBlocks.add(AstrologicalBlocks.createSlabBlocks(baseBlock));
        }
    }

    public static Pair<String, DeferredHolder<Block, Block>> createWallBlocks(Pair<String, DeferredHolder<Block, Block>> baseBlock) {
        String name = (String)baseBlock.getFirst() + "_wall";
        return Pair.of((Object)name, (Object)BLOCKS.register(name, () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)((DeferredHolder)baseBlock.getSecond()).get())))));
    }

    public static Pair<String, DeferredHolder<Block, Block>> createStairBlocks(Pair<String, DeferredHolder<Block, Block>> baseBlock) {
        String name = (String)baseBlock.getFirst() + "_stairs";
        return Pair.of((Object)name, (Object)BLOCKS.register(name, () -> new StairBlock(((Block)((DeferredHolder)baseBlock.getSecond()).get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)((DeferredHolder)baseBlock.getSecond()).get())))));
    }

    public static Pair<String, DeferredHolder<Block, Block>> createSlabBlocks(Pair<String, DeferredHolder<Block, Block>> baseBlock) {
        String name = (String)baseBlock.getFirst() + "_slab";
        return Pair.of((Object)name, (Object)BLOCKS.register(name, () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)((DeferredHolder)baseBlock.getSecond()).get())))));
    }
}

