/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Astrological.core.events;

import com.Apothic0n.Astrological.core.objects.AstrologicalBlocks;
import com.Apothic0n.Astrological.core.objects.AstrologicalItems;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="astrological", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModEvents {
    public static final PerlinSimplexNoise SATURATION_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(2345L)), (List)ImmutableList.of((Object)0));
    public static final PerlinSimplexNoise BRIGHTNESS_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(5432L)), (List)ImmutableList.of((Object)0));

    @SubscribeEvent
    public static void addItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tab = event.getTabKey();
        if (tab.equals(CreativeModeTabs.NATURAL_BLOCKS)) {
            event.accept((ItemLike)AstrologicalItems.SLEEP.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.TUMOR.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.CYST.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.CRYING_DUCT.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.INSOMNIA_VENT.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.OCHRE_SELENITE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.VERDANT_SELENITE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.PEARLESCENT_SELENITE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.PURPURITE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.TRIPHYLITE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.JADE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.LIGHT_JADE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (tab.equals(CreativeModeTabs.BUILDING_BLOCKS)) {
            event.accept((ItemLike)AstrologicalItems.PRISMATIC_SELENITE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.SELENITE_WALL.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.REINFORCED_JADE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.JADE_BRICKS.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.POLISHED_JADE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.MARBLED_JADE_SLAB.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.LIGHT_JADE_TILES.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.CRACKED_LIGHT_JADE_TILES.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.PURPURITE_TILES.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            List<List<DeferredHolder<Item, Item>>> buildingBlockItems = List.of(AstrologicalItems.wallItems, AstrologicalItems.stairItems, AstrologicalItems.slabItems);
            for (int i = 0; i < buildingBlockItems.size(); ++i) {
                List<DeferredHolder<Item, Item>> blockItemTypeList = buildingBlockItems.get(i);
                for (int o = 0; o < blockItemTypeList.size(); ++o) {
                    event.accept((ItemLike)blockItemTypeList.get(o).get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }
        } else if (tab.equals(CreativeModeTabs.INGREDIENTS)) {
            event.accept((ItemLike)AstrologicalItems.PURPURITE_BLOB.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.accept((ItemLike)AstrologicalItems.POPPED_PURPURITE.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    @SubscribeEvent
    public static void onBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((blockState, blockAndTintGetter, blockPos, tint) -> {
            if (blockPos != null && Minecraft.getInstance().level != null) {
                int x = blockPos.getX();
                int z = blockPos.getZ();
                int color = -328966;
                double saturate = Mth.clamp((double)(SATURATION_NOISE.getValue((double)x * 0.1, (double)z * 0.1, false) * 0.33), (double)-0.03, (double)0.03) + 1.1;
                double brighten = Mth.clamp((double)(BRIGHTNESS_NOISE.getValue((double)x * 0.025, (double)z * 0.025, false) * 0.3), (double)-0.33, (double)0.33);
                float red = (float)FastColor.ABGR32.red((int)color) / 255.0f;
                float green = (float)FastColor.ABGR32.green((int)color) / 255.0f;
                float blue = (float)FastColor.ABGR32.blue((int)color) / 255.0f;
                float gray = (float)((double)(red + green + blue) / (3.0 + brighten));
                return FastColor.ABGR32.color((int)FastColor.ABGR32.alpha((int)color), (int)((int)(Mth.clamp((double)((double)(blue + (gray - blue)) * saturate), (double)0.0, (double)1.0) * 255.0)), (int)((int)(Mth.clamp((double)((double)(green + (gray - green)) * saturate), (double)0.0, (double)1.0) * 255.0)), (int)((int)(Mth.clamp((double)((double)(red + (gray - red)) * saturate), (double)0.0, (double)1.0) * 255.0)));
            }
            return -328966;
        }, new Block[]{(Block)AstrologicalBlocks.OCHRE_SELENITE.get(), (Block)AstrologicalBlocks.VERDANT_SELENITE.get(), (Block)AstrologicalBlocks.PEARLESCENT_SELENITE.get(), (Block)AstrologicalBlocks.JADE.get(), Blocks.END_STONE, Blocks.END_STONE_BRICKS, Blocks.END_STONE_BRICK_STAIRS, Blocks.END_STONE_BRICK_SLAB, Blocks.END_STONE_BRICK_WALL});
        event.register((blockState, blockAndTintGetter, blockPos, tint) -> {
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null) {
                int color = -19457;
                float time = level.getDayTime();
                if (time > 24000.0f) {
                    time = (float)((double)time - Math.floor(time / 24000.0f) * 24000.0);
                }
                if (time >= 22000.0f || time <= 500.0f || time >= 12000.0f && time <= 13500.0f) {
                    color = -9549;
                } else if (time <= 12000.0f) {
                    color = -3670093;
                }
                return color;
            }
            return -328966;
        }, new Block[]{(Block)AstrologicalBlocks.PRISMATIC_SELENITE.get(), (Block)AstrologicalBlocks.SELENITE_WALL.get()});
    }

    @SubscribeEvent
    public static void onItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((blockAndTintGetter, tint) -> {
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null) {
                int color = -19457;
                float time = level.getDayTime();
                if (time > 24000.0f) {
                    time = (float)((double)time - Math.floor(time / 24000.0f) * 24000.0);
                }
                if (time >= 22000.0f || time <= 500.0f || time >= 12000.0f && time <= 13500.0f) {
                    color = -9549;
                } else if (time <= 12000.0f) {
                    color = -3670093;
                }
                return color;
            }
            return -328966;
        }, new ItemLike[]{(ItemLike)AstrologicalBlocks.PRISMATIC_SELENITE.get(), (ItemLike)AstrologicalBlocks.SELENITE_WALL.get()});
    }
}

