/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Astrological.api.biome.features.types;

import com.Apothic0n.Astrological.core.objects.CryingDuctUtils;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.PointedDripstoneConfiguration;

public class CryingDuctFeature
extends Feature<PointedDripstoneConfiguration> {
    public CryingDuctFeature(Codec<PointedDripstoneConfiguration> pContext) {
        super(pContext);
    }

    public boolean place(FeaturePlaceContext<PointedDripstoneConfiguration> pContext) {
        WorldGenLevel levelaccessor = pContext.level();
        BlockPos blockpos = pContext.origin();
        RandomSource random = pContext.random();
        PointedDripstoneConfiguration pointeddripstoneconfiguration = (PointedDripstoneConfiguration)pContext.config();
        Optional<Direction> optional = CryingDuctFeature.getTipDirection((LevelAccessor)levelaccessor, blockpos, random);
        if (optional.isEmpty()) {
            return false;
        }
        BlockPos blockpos1 = blockpos.relative(optional.get().getOpposite());
        CryingDuctFeature.createPatchOfDripstoneBlocks((LevelAccessor)levelaccessor, random, blockpos1, pointeddripstoneconfiguration);
        int i = (int)(pointeddripstoneconfiguration.chanceOfTallerDripstone * 10.0f);
        int randomNumber = (int)(random.nextFloat() * (float)i + 1.0f);
        CryingDuctUtils.growPointedDripstone((LevelAccessor)levelaccessor, blockpos, optional.get(), randomNumber, false);
        return true;
    }

    private static Optional<Direction> getTipDirection(LevelAccessor p_225199_, BlockPos p_225200_, RandomSource p_225201_) {
        boolean flag = CryingDuctUtils.isDripstoneBase(p_225199_.getBlockState(p_225200_.above()));
        boolean flag1 = CryingDuctUtils.isDripstoneBase(p_225199_.getBlockState(p_225200_.below()));
        if (flag && flag1) {
            return Optional.of(p_225201_.nextBoolean() ? Direction.DOWN : Direction.UP);
        }
        if (flag) {
            return Optional.of(Direction.DOWN);
        }
        return flag1 ? Optional.of(Direction.UP) : Optional.empty();
    }

    private static void createPatchOfDripstoneBlocks(LevelAccessor p_225194_, RandomSource p_225195_, BlockPos p_225196_, PointedDripstoneConfiguration p_225197_) {
        CryingDuctUtils.placeDripstoneBlockIfPossible(p_225194_, p_225196_);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (p_225195_.nextFloat() > p_225197_.chanceOfDirectionalSpread) continue;
            BlockPos blockpos = p_225196_.relative(direction);
            CryingDuctUtils.placeDripstoneBlockIfPossible(p_225194_, blockpos);
            if (p_225195_.nextFloat() > p_225197_.chanceOfSpreadRadius2) continue;
            BlockPos blockpos1 = blockpos.relative(Direction.getRandom((RandomSource)p_225195_));
            CryingDuctUtils.placeDripstoneBlockIfPossible(p_225194_, blockpos1);
            if (p_225195_.nextFloat() > p_225197_.chanceOfSpreadRadius3) continue;
            BlockPos blockpos2 = blockpos1.relative(Direction.getRandom((RandomSource)p_225195_));
            CryingDuctUtils.placeDripstoneBlockIfPossible(p_225194_, blockpos2);
        }
    }
}

