/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Astrological.api;

import com.Apothic0n.Astrological.api.AstrologicalMath;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import org.joml.SimplexNoise;

public final class AstrologicalDensityFunctions {
    public static final DeferredRegister<MapCodec<? extends DensityFunction>> DENSITY_FUNCTION_TYPES = DeferredRegister.create((ResourceKey)Registries.DENSITY_FUNCTION_TYPE, (String)"astrological");
    public static final DeferredHolder<MapCodec<? extends DensityFunction>, ?> LOWER_ISLANDS_DENSITY_FUNCTION_TYPE = DENSITY_FUNCTION_TYPES.register("lower_islands", () -> LowerIslands.CODEC.codec());

    public static void register(IEventBus eventBus) {
        DENSITY_FUNCTION_TYPES.register(eventBus);
    }

    static <O> KeyDispatchDataCodec<O> makeCodec(MapCodec<O> codec) {
        return KeyDispatchDataCodec.of(codec);
    }

    protected record LowerIslands(DensityFunction input, boolean hollow) implements DensityFunction
    {
        private static final MapCodec<LowerIslands> DATA_CODEC = RecordCodecBuilder.mapCodec(data -> data.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("input").forGetter(LowerIslands::input), (App)Codec.BOOL.fieldOf("hollow").forGetter(LowerIslands::hollow)).apply((Applicative)data, LowerIslands::new));
        public static final KeyDispatchDataCodec<LowerIslands> CODEC = AstrologicalDensityFunctions.makeCodec(DATA_CODEC);

        public double compute(@NotNull DensityFunction.FunctionContext context) {
            int x = context.blockX();
            int y = context.blockY();
            int z = context.blockZ();
            int mainOffset = (int)(SimplexNoise.noise((float)((float)x * 0.005f), (float)((float)z * 0.005f)) * 25.0f);
            int offset = -300 + mainOffset;
            int offset2 = -400 + mainOffset;
            if (y < 0) {
                double airPart = Math.abs(SimplexNoise.noise((float)((float)x * 0.02f), (float)((float)(y + mainOffset) * 0.005f), (float)((float)z * 0.02f))) * -1.0f;
                double solidPart = Math.abs(SimplexNoise.noise((float)((float)x * 0.0024f), (float)((float)(y + mainOffset) * 0.0016f), (float)((float)z * 0.0024f)));
                double floatingIsland = y > -155 ? Math.min(0.5 - (airPart + AstrologicalMath.gradient(y, 164 + offset, 292 + offset, -1.0f, 1.5f)), solidPart + (AstrologicalMath.gradient(y, 228 + offset, 356 + offset, 0.75f, 0.5f) - 2.0 * (0.1 + AstrologicalMath.gradient(y, 169 + offset, 259 + offset, 0.76f, 0.0f)))) : Math.min(0.5 - (airPart + AstrologicalMath.gradient(y, 164 + offset2, 292 + offset2, -1.0f, 1.5f)), solidPart + (AstrologicalMath.gradient(y, 228 + offset2, 356 + offset2, 0.75f, 0.5f) - 2.0 * (0.1 + AstrologicalMath.gradient(y, 169 + offset2, 259 + offset2, 0.76f, 0.0f))));
                double caves = 0.0;
                if (this.hollow()) {
                    caves = Math.min(0.0, (floatingIsland - 0.2) * -5.0);
                }
                return caves + floatingIsland + this.input().compute(context);
            }
            return this.input().compute(context);
        }

        public void fillArray(double @NotNull [] densities, DensityFunction.ContextProvider context) {
            context.fillAllDirectly(densities, (DensityFunction)this);
        }

        @NotNull
        public DensityFunction mapAll(DensityFunction.Visitor visitor) {
            return visitor.apply((DensityFunction)new LowerIslands(this.input().mapAll(visitor), this.hollow()));
        }

        public double minValue() {
            return -1875000.0;
        }

        public double maxValue() {
            return 1875000.0;
        }

        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }
}

