/*
 * Decompiled with CFR 0.152.
 */
package fuzs.dyedflames.handler;

import fuzs.dyedflames.init.ModRegistry;
import fuzs.dyedflames.world.level.block.FireType;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class EntityInsideFireHandler {
    public static EventResult onStartEntityTick(Entity entity) {
        if (!entity.level().isClientSide) {
            if (EntityInsideFireHandler.triggerIsOnFireChange(entity, false)) {
                Block block;
                LivingEntity livingEntity;
                Entity lastAttacker;
                if (entity instanceof LivingEntity && (lastAttacker = EntityInsideFireHandler.getLastAttacker(livingEntity = (LivingEntity)entity)) != null && lastAttacker.isOnFire() && (block = (Block)ModRegistry.LAST_FIRE_SOURCE_ATTACHMENT_TYPE.get((Object)lastAttacker)) != null) {
                    ModRegistry.LAST_FIRE_SOURCE_ATTACHMENT_TYPE.set((Object)entity, (Object)block);
                }
                if (entity instanceof Player) {
                    ModRegistry.WAS_PLAYER_ON_FIRE_ATTACHMENT_TYPE.set((Object)entity, (Object)true);
                }
            }
            EntityInsideFireHandler.clearLastFireSource(entity);
        }
        return EventResult.PASS;
    }

    public static void onEndEntityTick(Entity entity) {
        if (entity.isOnFire()) {
            EntityInsideFireHandler.checkInsideBlocks(entity, (BlockState blockState) -> {
                Optional<TagKey<Fluid>> fluids;
                Optional<FireType> fireType = FireType.getFireType(blockState.getBlock());
                if (fireType.isPresent() && ((fluids = fireType.get().fluid()).isEmpty() || entity.getFluidHeight(fluids.get()) > 0.0)) {
                    ModRegistry.LAST_FIRE_SOURCE_ATTACHMENT_TYPE.set((Object)entity, (Object)blockState.getBlock());
                    return true;
                }
                return false;
            });
        }
        if (entity.displayFireAnimation() && entity.getRandom().nextInt(5) == 0) {
            Block block = (Block)ModRegistry.LAST_FIRE_SOURCE_ATTACHMENT_TYPE.getOrDefault((Object)entity, (Object)Blocks.FIRE);
            FireType.getFireType(block).flatMap(FireType::particleType).ifPresent(simpleParticleType -> entity.level().addParticle((ParticleOptions)simpleParticleType, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 0.0, 0.0, 0.0));
        }
        if (!entity.level().isClientSide) {
            EntityInsideFireHandler.clearLastFireSource(entity);
        }
    }

    private static void clearLastFireSource(Entity entity) {
        if (EntityInsideFireHandler.triggerIsOnFireChange(entity, true)) {
            ModRegistry.LAST_FIRE_SOURCE_ATTACHMENT_TYPE.set((Object)entity, null);
            if (entity instanceof Player) {
                ModRegistry.WAS_PLAYER_ON_FIRE_ATTACHMENT_TYPE.set((Object)entity, (Object)false);
            }
        }
    }

    private static boolean triggerIsOnFireChange(Entity entity, boolean wasOnFire) {
        if (entity instanceof Player) {
            return wasOnFire == (Boolean)ModRegistry.WAS_PLAYER_ON_FIRE_ATTACHMENT_TYPE.getOrDefault((Object)entity, (Object)false) && wasOnFire != entity.getSharedFlag(0);
        }
        return wasOnFire == entity.wasOnFire && wasOnFire != entity.isOnFire();
    }

    @Nullable
    public static Entity getLastAttacker(LivingEntity livingEntity) {
        List combatEntries = livingEntity.getCombatTracker().entries;
        if (!combatEntries.isEmpty()) {
            CombatEntry combatEntry = (CombatEntry)combatEntries.getLast();
            return combatEntry.source().getDirectEntity();
        }
        return livingEntity.getLastHurtByMob();
    }

    private static void checkInsideBlocks(Entity entity, Predicate<BlockState> predicate) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        EntityInsideFireHandler.checkInsideBlocks(entity, positions::add);
        positions.sort(Comparator.comparingDouble(entry -> entry.distToCenterSqr(entity.getX(), entity.getY(), entity.getZ())));
        for (BlockPos blockPos : positions) {
            if (!predicate.test(entity.level().getBlockState(blockPos))) continue;
            break;
        }
    }

    private static void checkInsideBlocks(Entity entity, Consumer<BlockPos> consumer) {
        if (entity.isAlive()) {
            AABB aABB = entity.getBoundingBox();
            BlockPos blockPos = BlockPos.containing((double)(aABB.minX + 1.0E-7), (double)(aABB.minY + 1.0E-7), (double)(aABB.minZ + 1.0E-7));
            BlockPos blockPos2 = BlockPos.containing((double)(aABB.maxX - 1.0E-7), (double)(aABB.maxY - 1.0E-7), (double)(aABB.maxZ - 1.0E-7));
            if (entity.level().hasChunksAt(blockPos, blockPos2)) {
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int i = blockPos.getX(); i <= blockPos2.getX(); ++i) {
                    for (int j = blockPos.getY(); j <= blockPos2.getY(); ++j) {
                        for (int k = blockPos.getZ(); k <= blockPos2.getZ(); ++k) {
                            consumer.accept(mutableBlockPos.set(i, j, k).immutable());
                        }
                    }
                }
            }
        }
    }
}

