/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.server.slotmover;

import com.minecraftserverzone.weaponmaster.setup.configs.ConfigHolder;
import com.minecraftserverzone.weaponmaster.setup.helper.ModUtils;
import com.minecraftserverzone.weaponmaster.setup.networking.Networking;
import com.minecraftserverzone.weaponmaster.setup.networking.client.slotmover.SlotMoverCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.slotmover.SlotMoverSPacket;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static void handleData(SlotMoverSPacket data, IPayloadContext context) {
        ServerPayloadHandler.playerChanged(data, context.player());
        context.enqueueWork(() -> ServerPayloadHandler.playerChanged(data, context.player())).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"weaponmaster_ydm.networking.failed.server", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void playerChanged(SlotMoverSPacket packetdata, Player sender) {
        PlayerData data;
        assert (sender.level() != null);
        if (!sender.level().isClientSide() && (data = ((IPlayerData)sender).getPlayerData()) != null && ModUtils.stringExist(packetdata.value())) {
            data.mover = packetdata.value();
            if (!((Boolean)ConfigHolder.COMMON.CAN_CHANGE_MOVERS.get()).booleanValue() && ModUtils.stringExist((String)ConfigHolder.COMMON.slotMover.get())) {
                data.mover = (String)ConfigHolder.COMMON.slotMover.get();
            }
            for (Player sp : sender.level().players()) {
                Networking.sendToClient(new SlotMoverCPacket(data.mover, false, sender.getStringUUID()), (ServerPlayer)sp);
            }
        }
    }
}

