/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.api.control.parameters;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.control.parameters.BlockSide;
import net.minecraft.core.Direction;
import org.apache.commons.lang3.StringUtils;

public class Inventory
extends BlockSide {
    @Nullable
    private final Direction intSide;

    public Inventory(@Nullable String name, @Nonnull Direction side, @Nullable Direction intSide) {
        super(name, side);
        this.intSide = intSide;
    }

    public String serialize() {
        return "#" + (this.hasNodeName() ? this.getNodeName() : "-") + "#" + this.getSide().getSerializedName() + "#" + (this.intSide == null ? "-" : this.intSide.getSerializedName()) + "#";
    }

    public static Inventory deserialize(String s) {
        String[] splitted = StringUtils.split((String)s, (char)'#');
        return new Inventory("-".equals(splitted[0]) ? null : splitted[0], Direction.byName((String)splitted[1]), "-".equals(splitted[2]) ? null : Direction.byName((String)splitted[2]));
    }

    @Override
    @Nonnull
    public Direction getSide() {
        return super.getSide();
    }

    @Nullable
    public Direction getIntSide() {
        return this.intSide;
    }

    @Override
    public String getStringRepresentation() {
        Object s = StringUtils.left((String)this.getSide().getSerializedName().toUpperCase(), (int)1);
        if (this.getIntSide() == null) {
            s = (String)s + "/*";
        } else {
            String is = StringUtils.left((String)this.getIntSide().getSerializedName().toUpperCase(), (int)1);
            s = (String)s + "/" + is;
        }
        if (this.getNodeName() == null) {
            return s;
        }
        return StringUtils.left((String)this.getNodeName(), (int)6) + " " + (String)s;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Inventory inventory = (Inventory)o;
        return this.intSide == inventory.intSide;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.intSide != null ? this.intSide.hashCode() : 0);
        return result;
    }
}

