/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.smithingtemplateviewer.jei;

import com.buuz135.smithingtemplateviewer.Config;
import com.buuz135.smithingtemplateviewer.SmithingTrimWrapper;
import com.buuz135.smithingtemplateviewer.jei.JEIPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.TriPredicate;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class JEISmithingViewerCategory
implements IRecipeCategory<SmithingTrimWrapper> {
    public RecipeType<SmithingTrimWrapper> getRecipeType() {
        return JEIPlugin.RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"smithingviewer.category.name");
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public int getWidth() {
        return 150;
    }

    public int getHeight() {
        return 120;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SmithingTrimWrapper recipe, IFocusGroup focuses) {
        builder.addInputSlot(1, 1).addIngredients(recipe.getRecipe().template);
        builder.addInputSlot(1, 19).addIngredients(recipe.getRecipe().base);
        if (((Boolean)Config.CONFIG.displayMaterials.get()).booleanValue()) {
            builder.addInputSlot(1, 37).addIngredients(recipe.getRecipe().addition);
        } else {
            ItemStack itemStack = Items.BARRIER.getDefaultInstance();
            itemStack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"Use any item!"));
            builder.addInputSlot(1, 37).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{itemStack}));
        }
    }

    public void draw(SmithingTrimWrapper recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int armorStandX = 75;
        int armorStandY = 75;
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        Vector3f ARMOR_STAND_TRANSLATION = new Vector3f();
        Quaternionf ARMOR_STAND_ANGLE = new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI);
        ItemStack template = recipe.getRecipe().template.getItems()[0];
        Item item = template.getItem();
        if (item instanceof SmithingTemplateItem) {
            SmithingTemplateItem templateItem = (SmithingTemplateItem)item;
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)templateItem.upgradeDescription.copy().withStyle(ChatFormatting.DARK_GRAY), 20, 5, 0xFFFFFF, false);
        }
        ResourceLocation inventory = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/inventory.png");
        ResourceLocation buttons = ResourceLocation.fromNamespaceAndPath((String)"smithingtemplateviewer", (String)"textures/gui/buttons.png");
        guiGraphics.blit(inventory, armorStandX - 25, armorStandY - 57, 25, 7, 51, 72);
        guiGraphics.blit(inventory, 0, 0, 7, 83, 18, 18);
        guiGraphics.blit(inventory, 0, 18, 7, 83, 18, 18);
        guiGraphics.blit(inventory, 0, 36, 7, 83, 18, 18);
        for (int i = 0; i < 4; ++i) {
            guiGraphics.blit(buttons, armorStandX - 25 - 20, armorStandY - 57 + 2 + 18 * i, 17, 56, 15, 15);
            guiGraphics.blit(buttons, armorStandX + 25 + 6, armorStandY - 57 + 2 + 18 * i, 33, 56, 15, 15);
        }
        guiGraphics.blit(buttons, armorStandX - 24, armorStandY + 20, 17, 56, 15, 15);
        guiGraphics.blit(buttons, armorStandX + 25 - 14, armorStandY + 20, 33, 56, 15, 15);
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)armorStandX, (float)armorStandY, (float)25.0f, (Vector3f)ARMOR_STAND_TRANSLATION, (Quaternionf)ARMOR_STAND_ANGLE, null, (LivingEntity)recipe.getArmorStand());
        guiGraphics.renderItem(recipe.getRecipe().addition.getItems()[recipe.getColorIndex()], armorStandX - 24 + 17, armorStandY + 20);
    }

    public void getTooltip(ITooltipBuilder tooltip, SmithingTrimWrapper recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        super.getTooltip(tooltip, (Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, SmithingTrimWrapper recipe, IFocusGroup focuses) {
        super.createRecipeExtras(builder, (Object)recipe, focuses);
        int armorStandX = 75;
        int armorStandY = 75;
        for (int i = 0; i < 4; ++i) {
            int finalI = i;
            builder.addInputHandler(new ClickHandler<SmithingTrimWrapper>(new ScreenRectangle(armorStandX - 25 - 20, armorStandY - 57 + 2 + 18 * i, 15, 15), recipe, (TriPredicate<Double, Double, IJeiUserInput>)((TriPredicate)(mouseX, mouseY, iJeiUserInput) -> {
                if (recipe.getArmorIndex()[finalI] > 0) {
                    int[] nArray = recipe.getArmorIndex();
                    int n = finalI;
                    nArray[n] = nArray[n] - 1;
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    recipe.updateArmorStand((Level)Minecraft.getInstance().level);
                    return true;
                }
                return false;
            })));
            builder.addInputHandler(new ClickHandler<SmithingTrimWrapper>(new ScreenRectangle(armorStandX + 25 + 6, armorStandY - 57 + 2 + 18 * i, 15, 15), recipe, (TriPredicate<Double, Double, IJeiUserInput>)((TriPredicate)(mouseX, mouseY, iJeiUserInput) -> {
                if (recipe.getArmorIndex()[finalI] < recipe.getArmors().get(finalI).size()) {
                    int[] nArray = recipe.getArmorIndex();
                    int n = finalI;
                    nArray[n] = nArray[n] + 1;
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    recipe.updateArmorStand((Level)Minecraft.getInstance().level);
                    return true;
                }
                return false;
            })));
        }
        builder.addInputHandler(new ClickHandler<SmithingTrimWrapper>(new ScreenRectangle(armorStandX - 24, armorStandY + 20, 15, 15), recipe, (TriPredicate<Double, Double, IJeiUserInput>)((TriPredicate)(mouseX, mouseY, iJeiUserInput) -> {
            if (recipe.getColorIndex() > 0) {
                recipe.setColorIndex(recipe.getColorIndex() - 1);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                recipe.updateArmorStand((Level)Minecraft.getInstance().level);
                return true;
            }
            return false;
        })));
        builder.addInputHandler(new ClickHandler<SmithingTrimWrapper>(new ScreenRectangle(armorStandX + 25 - 14, armorStandY + 20, 15, 15), recipe, (TriPredicate<Double, Double, IJeiUserInput>)((TriPredicate)(mouseX, mouseY, iJeiUserInput) -> {
            if (recipe.getColorIndex() < recipe.getRecipe().addition.getItems().length - 1) {
                recipe.setColorIndex(recipe.getColorIndex() + 1);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                recipe.updateArmorStand((Level)Minecraft.getInstance().level);
                return true;
            }
            return false;
        })));
    }

    public record ClickHandler<T>(ScreenRectangle area, T recipe, TriPredicate<Double, Double, IJeiUserInput> handleInput) implements IJeiInputHandler
    {
        public ScreenRectangle getArea() {
            return this.area;
        }

        public boolean handleInput(double mouseX, double mouseY, IJeiUserInput input) {
            if (!input.isSimulate()) {
                return this.handleInput.test((Object)mouseX, (Object)mouseY, (Object)input);
            }
            return false;
        }
    }
}

