/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.me.strategy;

import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.core.localization.GuiText;
import com.google.common.primitives.Ints;
import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import gripe._90.arseng.me.key.SourceKey;
import gripe._90.arseng.me.key.SourceKeyType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;

public class SourceExternalStorageStrategy
implements ExternalStorageStrategy {
    private final BlockCapabilityCache<ISourceCap, Direction> cache;

    public SourceExternalStorageStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.cache = BlockCapabilityCache.create((BlockCapability)CapabilityRegistry.SOURCE_CAPABILITY, (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide);
    }

    @Nullable
    public MEStorage createWrapper(boolean extractableOnly, Runnable injectOrExtractCallback) {
        ISourceCap sourceTile = (ISourceCap)this.cache.getCapability();
        return sourceTile != null ? new Adaptor(sourceTile, injectOrExtractCallback) : null;
    }

    private record Adaptor(ISourceCap sourceTile, Runnable injectOrExtractCallback) implements MEStorage
    {
        public long insert(AEKey what, long amount, Actionable mode, IActionSource actionSource) {
            if (!(what instanceof SourceKey)) {
                return 0L;
            }
            int inserted = this.sourceTile.receiveSource(Ints.saturatedCast((long)amount), mode.isSimulate());
            if (inserted > 0 && mode == Actionable.MODULATE) {
                this.injectOrExtractCallback.run();
            }
            return inserted;
        }

        public long extract(AEKey what, long amount, Actionable mode, IActionSource actionSource) {
            if (!(what instanceof SourceKey)) {
                return 0L;
            }
            int extracted = this.sourceTile.extractSource(Ints.saturatedCast((long)amount), mode.isSimulate());
            if (extracted > 0 && mode == Actionable.MODULATE) {
                this.injectOrExtractCallback.run();
            }
            return extracted;
        }

        public void getAvailableStacks(KeyCounter out) {
            int currentSource = this.sourceTile.getSource();
            if (currentSource != 0) {
                out.add((AEKey)SourceKey.KEY, (long)currentSource);
            }
        }

        public Component getDescription() {
            return GuiText.ExternalStorage.text(new Object[]{SourceKeyType.TYPE.getDescription()});
        }
    }
}

