/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.util;

import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.api.EnchantmentStatBlock;
import dev.shadowsoffire.apothic_enchanting.table.EnchantingStatRegistry;
import dev.shadowsoffire.apothic_enchanting.table.EnchantmentTableStats;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public class TooltipUtil {
    public static void appendBlockStats(LevelReader level, BlockState state, BlockPos pos, Consumer<Component> tooltip) {
        Set<Holder<Enchantment>> blacklist;
        EnchantmentStatBlock enchBlock = (EnchantmentStatBlock)state.getBlock();
        float maxEterna = EnchantingStatRegistry.getMaxEterna(state, level, pos);
        float eterna = EnchantingStatRegistry.getEterna(state, level, pos);
        float quanta = EnchantingStatRegistry.getQuanta(state, level, pos);
        float arcana = EnchantingStatRegistry.getArcana(state, level, pos);
        int clues = EnchantingStatRegistry.getBonusClues(state, level, pos);
        boolean treasure = enchBlock.allowsTreasure(state, level, pos);
        boolean stable = enchBlock.providesStability(state, level, pos);
        if (eterna != 0.0f || quanta != 0.0f || arcana != 0.0f || clues != 0 || treasure || stable) {
            tooltip.accept((Component)TooltipUtil.lang("info", "ench_stats", new Object[0]).withStyle(ChatFormatting.GOLD));
        }
        if (eterna != 0.0f) {
            if (eterna > 0.0f) {
                tooltip.accept((Component)TooltipUtil.lang("info", "eterna.p", String.format("%.2f", Float.valueOf(eterna)), String.format("%.2f", Float.valueOf(maxEterna))).withStyle(ChatFormatting.GREEN));
            } else {
                tooltip.accept((Component)TooltipUtil.lang("info", "eterna", String.format("%.2f", Float.valueOf(eterna))).withStyle(ChatFormatting.GREEN));
            }
        }
        if (quanta != 0.0f) {
            tooltip.accept((Component)TooltipUtil.lang("info", "quanta" + (quanta > 0.0f ? ".p" : ""), String.format("%.2f", Float.valueOf(quanta))).withStyle(ChatFormatting.RED));
        }
        if (arcana != 0.0f) {
            tooltip.accept((Component)TooltipUtil.lang("info", "arcana" + (arcana > 0.0f ? ".p" : ""), String.format("%.2f", Float.valueOf(arcana))).withStyle(ChatFormatting.DARK_PURPLE));
        }
        if (clues != 0) {
            tooltip.accept((Component)TooltipUtil.lang("info", "clues" + (clues > 0 ? ".p" : ""), String.format("%d", clues)).withStyle(ChatFormatting.DARK_AQUA));
        }
        if (treasure) {
            tooltip.accept((Component)TooltipUtil.lang("info", "allows_treasure", new Object[0]).withStyle(ChatFormatting.GOLD));
        }
        if (stable) {
            tooltip.accept((Component)TooltipUtil.lang("info", "provides_stability", new Object[0]).withStyle(ChatFormatting.GOLD));
        }
        if ((blacklist = enchBlock.getBlacklistedEnchantments(state, level, pos)).size() > 0) {
            tooltip.accept((Component)TooltipUtil.lang("info", "filter", new Object[0]).withStyle(s -> s.withColor(5812428)));
            for (Holder<Enchantment> e : blacklist) {
                MutableComponent name = (MutableComponent)Enchantment.getFullname(e, (int)1);
                name.getSiblings().clear();
                name.withStyle(s -> s.withColor(5798058));
                tooltip.accept((Component)Component.literal((String)" - ").append((Component)name).withStyle(s -> s.withColor(5798058)));
            }
        }
    }

    public static void appendTableStats(LevelReader level, BlockPos pos, Consumer<Component> tooltip) {
        EnchantmentTableStats stats = EnchantmentTableStats.gatherStats(level, pos, 0);
        tooltip.accept((Component)TooltipUtil.lang("info", "eterna.t", String.format("%.2f", Float.valueOf(stats.eterna())), 100).withStyle(ChatFormatting.GREEN));
        tooltip.accept((Component)TooltipUtil.lang("info", "quanta.t", String.format("%.2f", Float.valueOf(Math.min(100.0f, stats.quanta())))).withStyle(ChatFormatting.RED));
        tooltip.accept((Component)TooltipUtil.lang("info", "arcana.t", String.format("%.2f", Float.valueOf(Math.min(100.0f, stats.arcana())))).withStyle(ChatFormatting.DARK_PURPLE));
        tooltip.accept((Component)TooltipUtil.lang("info", "clues.t", String.format("%d", stats.clues())).withStyle(ChatFormatting.DARK_AQUA));
    }

    public static MutableComponent lang(String type, String path, Object ... args) {
        return Component.translatable((String)(type + ".apothic_enchanting." + path), (Object[])args);
    }

    public static void applyOverMaxLevelColor(Holder<Enchantment> ench, int level, Component name) {
        if (!ench.is(EnchantmentTags.CURSE) && level > ((Enchantment)ench.value()).definition().maxLevel() && name instanceof MutableComponent) {
            MutableComponent mc = (MutableComponent)name;
            mc.setStyle(mc.getStyle().withColor((TextColor)Ench.Colors.LIGHT_BLUE_FLASH));
        }
    }
}

