/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.util;

import com.mojang.authlib.GameProfile;
import dev.shadowsoffire.apothic_enchanting.ApothEnchClient;
import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.UsernameCache;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class MiscUtil {
    public static int getExpCostForSlot(int level, int slot) {
        int cost = 0;
        for (int i = 0; i <= slot; ++i) {
            cost += EnchantmentUtils.getExperienceForLevel((int)(level - i));
        }
        return cost - 1;
    }

    public static int[] doubleUpGradient(int[] data) {
        int[] out = new int[data.length * 2];
        System.arraycopy(data, 0, out, 0, data.length);
        for (int i = data.length - 1; i >= 0; --i) {
            out[data.length * 2 - 1 - i] = data[i];
        }
        return out;
    }

    public static boolean isOnCooldown(ResourceLocation id, LivingEntity entity) {
        long cooldownEndTime = entity.getPersistentData().getLong("apothic_enchanting.cooldown." + id.toString());
        return cooldownEndTime > entity.level().getGameTime();
    }

    public static void startCooldown(ResourceLocation id, LivingEntity entity, int cooldown) {
        entity.getPersistentData().putLong("apothic_enchanting.cooldown." + id.toString(), entity.level().getGameTime() + (long)cooldown);
    }

    public static boolean breakExtraBlock(ServerLevel level, BlockPos pos, ItemStack mainhand, @Nullable UUID source) {
        FakePlayer player;
        BlockState state = level.getBlockState(pos);
        if (source != null) {
            player = FakePlayerFactory.get((ServerLevel)level, (GameProfile)new GameProfile(source, UsernameCache.getLastKnownUsername((UUID)source)));
            Player realPlayer = level.getPlayerByUUID(source);
            player.removeAllEffects();
            if (realPlayer != null) {
                player.setPos(realPlayer.position());
                for (MobEffectInstance effect : realPlayer.getActiveEffects()) {
                    player.forceAddEffect(new MobEffectInstance(effect), null);
                }
            }
        } else {
            player = FakePlayerFactory.getMinecraft((ServerLevel)level);
        }
        player.getInventory().items.set(player.getInventory().selected, (Object)mainhand);
        if (state.getDestroySpeed((BlockGetter)level, pos) < 0.0f || !state.canHarvestBlock((BlockGetter)level, pos, (Player)player)) {
            return false;
        }
        GameType type = player.getAbilities().instabuild ? GameType.CREATIVE : GameType.SURVIVAL;
        BlockEvent.BreakEvent exp = CommonHooks.fireBlockBreak((Level)level, (GameType)type, (ServerPlayer)player, (BlockPos)pos, (BlockState)state);
        if (exp.isCanceled()) {
            return false;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        Block block = state.getBlock();
        if (block instanceof GameMasterBlock && !player.canUseGameMasterBlocks()) {
            level.sendBlockUpdated(pos, state, state, 3);
            return false;
        }
        if (player.blockActionRestricted((Level)level, pos, type)) {
            return false;
        }
        BlockState newState = block.playerWillDestroy((Level)level, pos, state, (Player)player);
        if (player.getAbilities().instabuild) {
            MiscUtil.removeBlock(level, (ServerPlayer)player, pos, newState, false);
            return true;
        }
        ItemStack tool = player.getMainHandItem();
        ItemStack toolCopy = tool.copy();
        boolean canHarvest = newState.canHarvestBlock((BlockGetter)level, pos, (Player)player);
        tool.mineBlock((Level)level, newState, pos, (Player)player);
        boolean removed = MiscUtil.removeBlock(level, (ServerPlayer)player, pos, newState, canHarvest);
        if (canHarvest && removed) {
            block.playerDestroy((Level)level, (Player)player, pos, newState, blockEntity, toolCopy);
        }
        if (tool.isEmpty() && !toolCopy.isEmpty()) {
            EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)toolCopy, (InteractionHand)InteractionHand.MAIN_HAND);
        }
        return true;
    }

    public static boolean removeBlock(ServerLevel level, ServerPlayer player, BlockPos pos, BlockState state, boolean canHarvest) {
        boolean removed = state.onDestroyedByPlayer((Level)level, pos, (Player)player, canHarvest, level.getFluidState(pos));
        if (removed) {
            state.getBlock().destroy((LevelAccessor)level, pos, state);
        }
        return removed;
    }

    public static String getEnchDescKey(Holder<Enchantment> ench) {
        return ench.getKey().location().toLanguageKey("enchantment") + ".desc";
    }

    @Nullable
    public static <T> Holder<T> findHolder(ResourceKey<? extends Registry<T>> registryKey, T obj) {
        Holder<T> holder;
        LogicalSide side = EffectiveSide.get();
        Holder<T> holder2 = holder = side.isClient() ? MiscUtil.findHolderFromClient(registryKey, obj) : MiscUtil.findHolderFromServer(registryKey, obj);
        if (holder != null) {
            return holder;
        }
        return side.isClient() ? MiscUtil.findHolderFromServer(registryKey, obj) : MiscUtil.findHolderFromClient(registryKey, obj);
    }

    @Nullable
    public static <T> Holder<T> findHolderFromServer(ResourceKey<? extends Registry<T>> registryKey, T obj) {
        Holder holder;
        Registry registry;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && (registry = (Registry)server.registries().compositeAccess().registry(registryKey).orElse(null)) != null && (holder = registry.wrapAsHolder(obj)).kind() == Holder.Kind.REFERENCE) {
            return holder;
        }
        return null;
    }

    @Nullable
    public static <T> Holder<T> findHolderFromClient(ResourceKey<? extends Registry<T>> registryKey, T obj) {
        Holder holder;
        Registry registry;
        if (FMLEnvironment.dist.isClient() && (registry = ApothEnchClient.findClientRegistry(registryKey)) != null && (holder = registry.wrapAsHolder(obj)).kind() == Holder.Kind.REFERENCE) {
            return holder;
        }
        return null;
    }
}

