/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.table;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.table.ApothEnchantmentMenu;
import dev.shadowsoffire.apothic_enchanting.table.Arcana;
import dev.shadowsoffire.apothic_enchanting.table.EnchantingInfoScreen;
import dev.shadowsoffire.apothic_enchanting.table.infusion.InfusionRecipe;
import dev.shadowsoffire.apothic_enchanting.util.MiscUtil;
import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import dev.shadowsoffire.placebo.util.DrawsOnLeft;
import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;

public class ApothEnchantmentScreen
extends EnchantmentScreen
implements DrawsOnLeft {
    public static final ResourceLocation TEXTURES = ApothicEnchanting.loc("textures/gui/enchanting_table.png");
    protected final ApothEnchantmentMenu menu;
    protected final Int2ObjectMap<List<EnchantmentInstance>> clues = new Int2ObjectOpenHashMap();
    protected final IdMap<Holder<Enchantment>> enchIdMap;
    protected float eterna;
    protected float lastEterna;
    protected float quanta;
    protected float lastQuanta;
    protected float arcana;
    protected float lastArcana;
    protected boolean[] hasAllClues;

    public ApothEnchantmentScreen(EnchantmentMenu container, Inventory inv, Component title) {
        super(container, inv, title);
        this.enchIdMap = Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).asHolderIdMap();
        this.eterna = 0.0f;
        this.lastEterna = 0.0f;
        this.quanta = 0.0f;
        this.lastQuanta = 0.0f;
        this.arcana = 0.0f;
        this.lastArcana = 0.0f;
        this.hasAllClues = new boolean[]{false, false, false};
        this.menu = (ApothEnchantmentMenu)container;
        this.imageHeight = 197;
        this.clues.defaultReturnValue(new ArrayList());
    }

    protected void renderLabels(GuiGraphics gfx, int mouseX, int mouseY) {
        gfx.drawString(this.font, this.title, 12, 5, 0x404040, false);
        gfx.drawString(this.font, this.playerInventoryTitle, 7, this.imageHeight - 96 + 4, 0x404040, false);
        gfx.drawString(this.font, (Component)TooltipUtil.lang("gui", "enchant.eterna", new Object[0]), 19, 74, 4044093, false);
        gfx.drawString(this.font, (Component)TooltipUtil.lang("gui", "enchant.quanta", new Object[0]), 19, 84, 16536660, false);
        gfx.drawString(this.font, (Component)TooltipUtil.lang("gui", "enchant.arcana", new Object[0]), 19, 94, 0xA800A8, false);
    }

    public void containerTick() {
        super.containerTick();
        float current = this.menu.stats.eterna();
        if (current != this.eterna) {
            this.eterna = current > this.eterna ? (this.eterna += Math.min(current - this.eterna, Math.max(0.16f, (current - this.eterna) * 0.1f))) : Math.max(this.eterna - this.lastEterna * 0.075f, current);
        }
        if (current > 0.0f) {
            this.lastEterna = current;
        }
        if ((current = this.menu.stats.quanta()) != this.quanta) {
            this.quanta = current > this.quanta ? (this.quanta += Math.min(current - this.quanta, Math.max(0.04f, (current - this.quanta) * 0.1f))) : Math.max(this.quanta - this.lastQuanta * 0.075f, current);
        }
        if (current > 0.0f) {
            this.lastQuanta = current;
        }
        if ((current = this.menu.stats.arcana()) != this.arcana) {
            this.arcana = current > this.arcana ? (this.arcana += Math.min(current - this.arcana, Math.max(0.04f, (current - this.arcana) * 0.1f))) : Math.max(this.arcana - this.lastArcana * 0.075f, current);
        }
        if (current > 0.0f) {
            this.lastArcana = current;
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        for (int k = 0; k < 3; ++k) {
            double d0 = pMouseX - (double)(i + 60);
            double d1 = pMouseY - (double)(j + 14 + 19 * k);
            if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 108.0) || !(d1 < 19.0) || !this.menu.clickMenuButton((Player)this.minecraft.player, k)) continue;
            this.minecraft.gameMode.handleInventoryButtonClick(this.menu.containerId, k);
            return true;
        }
        if (this.menu.getSlot(0).hasItem() && this.isHovering(145, -15, 27, 15, pMouseX, pMouseY)) {
            if (Arrays.stream(this.menu.enchantClue).boxed().map(arg_0 -> this.enchIdMap.byId(arg_0)).allMatch((Predicate<Holder>)Predicates.notNull())) {
                Minecraft.getInstance().pushGuiLayer((Screen)new EnchantingInfoScreen(this));
            }
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    protected void renderBg(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        int xCenter = (this.width - this.imageWidth) / 2;
        int yCenter = (this.height - this.imageHeight) / 2;
        gfx.blit(TEXTURES, xCenter, yCenter, 0, 0, this.imageWidth, this.imageHeight);
        this.renderBook(gfx, xCenter, yCenter, partialTicks);
        EnchantmentNames.getInstance().initSeed((long)this.menu.getEnchantmentSeed());
        int lapis = this.menu.getGoldCount();
        for (int slot = 0; slot < 3; ++slot) {
            int j1 = xCenter + 60;
            int k1 = j1 + 20;
            int level = this.menu.costs[slot];
            if (level == 0) {
                gfx.blit(TEXTURES, j1, yCenter + 14 + 19 * slot, 148, 218, 108, 19);
                continue;
            }
            String s = "" + level;
            int width = 86 - this.font.width(s);
            FormattedText itextproperties = EnchantmentNames.getInstance().getRandomName(this.font, width);
            int color = 6839882;
            if ((lapis < slot + 1 || this.minecraft.player.experienceLevel < level) && !this.minecraft.player.getAbilities().instabuild || this.menu.enchantClue[slot] == -1) {
                gfx.blit(TEXTURES, j1, yCenter + 14 + 19 * slot, 148, 218, 108, 19);
                gfx.blit(TEXTURES, j1 + 1, yCenter + 15 + 19 * slot, 16 * slot, 239, 16, 16);
                gfx.drawWordWrap(this.font, itextproperties, k1, yCenter + 16 + 19 * slot, width, (color & 0xFEFEFE) >> 1);
                color = 4226832;
            } else {
                int k2 = mouseX - (xCenter + 60);
                int l2 = mouseY - (yCenter + 14 + 19 * slot);
                if (k2 >= 0 && l2 >= 0 && k2 < 108 && l2 < 19) {
                    gfx.blit(TEXTURES, j1, yCenter + 14 + 19 * slot, 148, 237, 108, 19);
                    color = 0xFFFF80;
                } else {
                    gfx.blit(TEXTURES, j1, yCenter + 14 + 19 * slot, 148, 199, 108, 19);
                }
                gfx.blit(TEXTURES, j1 + 1, yCenter + 15 + 19 * slot, 16 * slot, 223, 16, 16);
                gfx.drawWordWrap(this.font, itextproperties, k1, yCenter + 16 + 19 * slot, width, color);
                color = 8453920;
            }
            gfx.drawString(this.font, s, k1 + 86 - this.font.width(s), yCenter + 16 + 19 * slot + 7, color);
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURES);
        if (this.eterna > 0.0f) {
            gfx.blit(TEXTURES, xCenter + 59, yCenter + 75, 0, 197, ApothEnchantmentScreen.getBarLength(this.eterna), 5);
        }
        if (this.quanta > 0.0f) {
            gfx.blit(TEXTURES, xCenter + 59, yCenter + 85, 0, 202, ApothEnchantmentScreen.getBarLength(this.quanta), 5);
        }
        if (this.arcana > 0.0f) {
            gfx.blit(TEXTURES, xCenter + 59, yCenter + 95, 0, 207, ApothEnchantmentScreen.getBarLength(this.arcana), 5);
        }
        if (this.menu.getSlot(0).hasItem()) {
            if (Arrays.stream(this.menu.enchantClue).boxed().map(arg_0 -> this.enchIdMap.byId(arg_0)).allMatch((Predicate<Holder>)Predicates.notNull())) {
                int u = this.isHovering(145, -15, 27, 15, mouseX, mouseY) ? 15 : 0;
                gfx.blit(TEXTURES, xCenter + 145, yCenter - 15, this.imageWidth, u, 27, 15);
            }
        }
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        ((SuperRender)((Object)this)).apoth_superRender(gfx, mouseX, mouseY, partialTicks);
        this.renderTooltip(gfx, mouseX, mouseY);
        boolean creative = this.minecraft.player.getAbilities().instabuild;
        int lapis = this.menu.getGoldCount();
        for (int slot = 0; slot < 3; ++slot) {
            boolean isFailedInfusion;
            int level = this.menu.costs[slot];
            Holder enchantment = (Holder)this.enchIdMap.byId(this.menu.enchantClue[slot]);
            int cost = slot + 1;
            if (!this.isHovering(60, 14 + 19 * slot, 108, 18, mouseX, mouseY) || level <= 0) continue;
            ArrayList list = Lists.newArrayList();
            boolean bl = isFailedInfusion = slot == 2 && enchantment == null && InfusionRecipe.findItemMatch((Level)this.minecraft.level, this.menu.getSlot(0).getItem()) != null;
            if (enchantment != null) {
                if (!((List)this.clues.get(slot)).isEmpty()) {
                    list.add(TooltipUtil.lang("info", "runes" + (this.hasAllClues[slot] ? "_all" : ""), new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
                    for (EnchantmentInstance i : (List)this.clues.get(slot)) {
                        list.add(Enchantment.getFullname((Holder)i.enchantment, (int)i.level));
                    }
                } else {
                    list.add(TooltipUtil.lang("info", "no_clue", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.UNDERLINE}));
                }
            } else if (isFailedInfusion) {
                MutableComponent infusionName = (MutableComponent)Enchantment.getFullname((Holder)Minecraft.getInstance().level.holderOrThrow(Ench.Enchantments.INFUSION), (int)1);
                list.add(infusionName.withStyle(ChatFormatting.ITALIC));
                Collections.addAll(list, Component.literal((String)""), TooltipUtil.lang("info", "infusion_failed", new Object[0]).withStyle(ChatFormatting.RED));
            } else {
                list.add(Component.translatable((String)"container.enchant.clue", (Object[])new Object[]{""}).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                Collections.addAll(list, Component.literal((String)""), Component.translatable((String)"neoforge.container.enchant.limitedEnchantability").withStyle(ChatFormatting.RED));
            }
            if (enchantment != null && !creative) {
                list.add(Component.literal((String)""));
                if (this.minecraft.player.experienceLevel < level) {
                    list.add(Component.translatable((String)"container.enchant.level.requirement", (Object[])new Object[]{this.menu.costs[slot]}).withStyle(ChatFormatting.RED));
                } else {
                    String s = cost == 1 ? I18n.get((String)"container.enchant.lapis.one", (Object[])new Object[0]) : I18n.get((String)"container.enchant.lapis.many", (Object[])new Object[]{cost});
                    ChatFormatting textformatting = lapis >= cost ? ChatFormatting.GRAY : ChatFormatting.RED;
                    list.add(Component.literal((String)s).withStyle(textformatting));
                    s = cost == 1 ? I18n.get((String)"container.enchant.level.one", (Object[])new Object[0]) : I18n.get((String)"container.enchant.level.many", (Object[])new Object[]{cost});
                    list.add(Component.literal((String)s).withStyle(ChatFormatting.GRAY));
                }
            }
            gfx.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
            break;
        }
        if (this.isHovering(60, 76, 110, 5, mouseX, mouseY)) {
            ArrayList list = Lists.newArrayList();
            list.add(ApothEnchantmentScreen.eterna().append((Component)TooltipUtil.lang("gui", "enchant.eterna.desc", new Object[0])));
            list.add(TooltipUtil.lang("gui", "enchant.eterna.desc2", new Object[0]).withStyle(ChatFormatting.GRAY));
            if (this.menu.stats.eterna() > 0.0f) {
                list.add(Component.literal((String)""));
                list.add(TooltipUtil.lang("gui", "enchant.eterna.desc3", ApothEnchantmentScreen.f(this.menu.stats.eterna()), 100).withStyle(ChatFormatting.GRAY));
            }
            gfx.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        } else if (this.isHovering(60, 86, 110, 5, mouseX, mouseY)) {
            ArrayList list = Lists.newArrayList();
            list.add(ApothEnchantmentScreen.quanta().append((Component)TooltipUtil.lang("gui", "enchant.quanta.desc", new Object[0])));
            list.add(TooltipUtil.lang("gui", "enchant.quanta.desc2", new Object[0]).withStyle(ChatFormatting.GRAY));
            list.add(ApothEnchantmentScreen.stability().append((Component)TooltipUtil.lang("gui", "enchant.quanta.desc3", new Object[0]).withStyle(ChatFormatting.GRAY)));
            if (this.menu.stats.quanta() > 0.0f) {
                list.add(CommonComponents.EMPTY);
                list.add(TooltipUtil.lang("gui", "enchant.quanta.desc4", ApothEnchantmentScreen.f(this.menu.stats.quanta())).withStyle(ChatFormatting.GRAY));
            }
            gfx.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
            float quanta = this.menu.stats.quanta();
            if (quanta > 0.0f) {
                list.clear();
                list.add(TooltipUtil.lang("info", "quanta_buff", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.RED}));
                list.add(TooltipUtil.lang("info", "quanta_growth", ApothEnchantmentScreen.f(quanta)).withStyle(ChatFormatting.BLUE));
                this.drawOnLeft(gfx, list, this.getGuiTop() + 29);
            }
        } else if (this.isHovering(60, 96, 110, 5, mouseX, mouseY)) {
            ArrayList list = Lists.newArrayList();
            PoseStack stack = gfx.pose();
            stack.pushPose();
            stack.translate(0.0f, 0.0f, 4.0f);
            list.add(ApothEnchantmentScreen.arcana().append((Component)TooltipUtil.lang("gui", "enchant.arcana.desc", new Object[0])));
            list.add(TooltipUtil.lang("gui", "enchant.arcana.desc2", new Object[0]).withStyle(ChatFormatting.GRAY));
            list.add(TooltipUtil.lang("gui", "enchant.arcana.desc3", new Object[0]).withStyle(ChatFormatting.GRAY));
            if (this.menu.stats.arcana() > 0.0f) {
                list.add(Component.literal((String)""));
                float ench = (float)this.menu.getSlot(0).getItem().getEnchantmentValue() / 2.0f;
                list.add(TooltipUtil.lang("gui", "enchant.arcana.desc4", ApothEnchantmentScreen.f(this.menu.stats.arcana() - ench)).withStyle(ChatFormatting.GRAY));
                list.add(TooltipUtil.lang("info", "ench_bonus", ApothEnchantmentScreen.f(ench)).withStyle(ChatFormatting.YELLOW));
                list.add(TooltipUtil.lang("gui", "enchant.arcana.desc5", ApothEnchantmentScreen.f(this.menu.stats.arcana())).withStyle(ChatFormatting.GOLD));
            }
            gfx.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
            stack.popPose();
            if (this.menu.stats.arcana() > 0.0f) {
                int minEnchants;
                list.clear();
                Arcana a = Arcana.getForThreshold(this.menu.stats.arcana());
                list.add(TooltipUtil.lang("info", "arcana_bonus", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.DARK_PURPLE}));
                if (a != Arcana.EMPTY) {
                    list.add(TooltipUtil.lang("info", "weights_changed", new Object[0]).withStyle(ChatFormatting.BLUE));
                }
                int n = this.menu.stats.arcana() > 75.0f ? 3 : (minEnchants = this.menu.stats.arcana() > 25.0f ? 2 : 0);
                if (minEnchants > 0) {
                    list.add(TooltipUtil.lang("info", "min_enchants", minEnchants).withStyle(ChatFormatting.BLUE));
                }
                this.drawOnLeft(gfx, list, this.getGuiTop() + 29);
                int n2 = list.size();
                Objects.requireNonNull(this.minecraft.font);
                int offset = 20 + n2 * 9;
                list.clear();
                list.add(TooltipUtil.lang("info", "rel_weights", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.YELLOW}));
                list.add(TooltipUtil.lang("info", "weight", I18n.get((String)"rarity.enchantment.common", (Object[])new Object[0]), a.getRarities()[0]).withStyle(ChatFormatting.GRAY));
                list.add(TooltipUtil.lang("info", "weight", I18n.get((String)"rarity.enchantment.uncommon", (Object[])new Object[0]), a.getRarities()[1]).withStyle(ChatFormatting.GREEN));
                list.add(TooltipUtil.lang("info", "weight", I18n.get((String)"rarity.enchantment.rare", (Object[])new Object[0]), a.getRarities()[2]).withStyle(ChatFormatting.BLUE));
                list.add(TooltipUtil.lang("info", "weight", I18n.get((String)"rarity.enchantment.very_rare", (Object[])new Object[0]), a.getRarities()[3]).withStyle(ChatFormatting.GOLD));
                this.drawOnLeft(gfx, list, this.getGuiTop() + 29 + offset);
            }
        } else if (this.menu.getSlot(0).hasItem() && this.isHovering(145, -15, 27, 15, mouseX, mouseY)) {
            if (Arrays.stream(this.menu.enchantClue).boxed().map(arg_0 -> this.enchIdMap.byId(arg_0)).allMatch((Predicate<Holder>)Predicates.notNull())) {
                ArrayList list = Lists.newArrayList();
                list.add(TooltipUtil.lang("info", "all_available", new Object[0]).withStyle(ChatFormatting.BLUE));
                gfx.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
            }
        }
        ItemStack enchanting = this.menu.getSlot(0).getItem();
        if (!enchanting.isEmpty() && this.menu.costs[2] > 0) {
            for (int slot = 0; slot < 3; ++slot) {
                if (!this.isHovering(60, 14 + 19 * slot, 108, 18, mouseX, mouseY)) continue;
                ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
                int level = this.menu.costs[slot];
                list.add(TooltipUtil.lang("info", "ench_at", level).withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GREEN}));
                list.add(Component.literal((String)""));
                int expCost = MiscUtil.getExpCostForSlot(level, slot);
                list.add(TooltipUtil.lang("info", "xp_cost", Component.literal((String)("" + expCost)).withStyle(ChatFormatting.GREEN), Component.literal((String)("" + EnchantmentUtils.getLevelForExperience((int)expCost))).withStyle(ChatFormatting.GREEN)));
                float quanta = this.menu.stats.quanta() / 100.0f;
                int minPow = this.menu.stats.stable() ? level : Math.round(Mth.clamp((float)((float)level - (float)level * quanta), (float)1.0f, (float)200.0f));
                int maxPow = Math.round(Mth.clamp((float)((float)level + (float)level * quanta), (float)1.0f, (float)200.0f));
                list.add(TooltipUtil.lang("info", "power_range", Component.literal((String)("" + minPow)).withStyle(ChatFormatting.DARK_RED), Component.literal((String)("" + maxPow)).withStyle(ChatFormatting.BLUE)));
                list.add(TooltipUtil.lang("info", "item_ench", Component.literal((String)("" + enchanting.getEnchantmentValue())).withStyle(ChatFormatting.GREEN)));
                list.add(TooltipUtil.lang("info", "num_clues", Component.literal((String)("" + (1 + this.menu.stats.clues()))).withStyle(ChatFormatting.DARK_AQUA)));
                this.drawOnLeft(gfx, list, this.getGuiTop() + 29);
                break;
            }
        }
    }

    public ApothEnchantmentMenu getMenu() {
        return this.menu;
    }

    public void acceptClues(int slot, List<EnchantmentInstance> clues, boolean all) {
        this.clues.put(slot, clues);
        this.hasAllClues[slot] = all;
    }

    public static int getBarLength(float stat) {
        return (int)(stat / 100.0f * 110.0f);
    }

    private static MutableComponent eterna() {
        return TooltipUtil.lang("gui", "enchant.eterna", new Object[0]).withStyle(ChatFormatting.GREEN);
    }

    private static MutableComponent quanta() {
        return TooltipUtil.lang("gui", "enchant.quanta", new Object[0]).withStyle(ChatFormatting.RED);
    }

    private static MutableComponent arcana() {
        return TooltipUtil.lang("gui", "enchant.arcana", new Object[0]).withStyle(ChatFormatting.DARK_PURPLE);
    }

    private static MutableComponent stability() {
        return TooltipUtil.lang("gui", "enchant.stability", new Object[0]).withStyle(ChatFormatting.GOLD);
    }

    private static String f(float f) {
        return String.format("%.2f", Float.valueOf(f));
    }

    public static interface SuperRender {
        public void apoth_superRender(GuiGraphics var1, int var2, int var3, float var4);
    }
}

