/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.table;

import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.payloads.CluePayload;
import dev.shadowsoffire.apothic_enchanting.payloads.StatsPayload;
import dev.shadowsoffire.apothic_enchanting.table.ApothEnchantmentHelper;
import dev.shadowsoffire.apothic_enchanting.table.EnchantmentTableItemHandler;
import dev.shadowsoffire.apothic_enchanting.table.EnchantmentTableStats;
import dev.shadowsoffire.apothic_enchanting.table.infusion.InfusionRecipe;
import dev.shadowsoffire.apothic_enchanting.util.MiscUtil;
import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class ApothEnchantmentMenu
extends EnchantmentMenu {
    protected EnchantmentTableStats stats = EnchantmentTableStats.INVALID;
    protected final Player player;

    public ApothEnchantmentMenu(int id, Inventory inv) {
        super(id, inv, ContainerLevelAccess.NULL);
        this.player = inv.player;
        this.slots.clear();
        this.addSecretSlot(new Slot(this, this.enchantSlots, 0, 15, 47){

            public boolean mayPlace(ItemStack stack) {
                return true;
            }

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSecretSlot(new Slot(this, this.enchantSlots, 1, 35, 47){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(Tags.Items.ENCHANTING_FUELS);
            }
        });
        this.initCommon(inv);
    }

    public ApothEnchantmentMenu(int id, Inventory inv, ContainerLevelAccess wPos, EnchantmentTableItemHandler teInv) {
        super(id, inv, wPos);
        this.player = inv.player;
        this.slots.clear();
        this.addSecretSlot(new Slot(this, this.enchantSlots, 0, 15, 47){

            public boolean mayPlace(ItemStack stack) {
                return true;
            }

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSecretSlot((Slot)new SlotItemHandler(this, (IItemHandler)teInv, 0, 35, 47){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(Tags.Items.ENCHANTING_FUELS);
            }
        });
        this.initCommon(inv);
    }

    protected Slot addSecretSlot(Slot pSlot) {
        pSlot.index = this.slots.size();
        this.slots.add((Object)pSlot);
        return pSlot;
    }

    private void initCommon(Inventory inv) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSecretSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18 + 31));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSecretSlot(new Slot((Container)inv, k, 8 + k * 18, 173));
        }
    }

    public boolean clickMenuButton(Player player, int id) {
        int slot = id;
        int level = this.costs[slot];
        ItemStack toEnchant = this.enchantSlots.getItem(0);
        ItemStack lapis = this.getSlot(1).getItem();
        int cost = slot + 1;
        if ((lapis.isEmpty() || lapis.getCount() < cost) && !player.getAbilities().instabuild) {
            return false;
        }
        if (this.costs[slot] <= 0 || toEnchant.isEmpty() || (player.experienceLevel < cost || player.experienceLevel < this.costs[slot]) && !player.getAbilities().instabuild) {
            return false;
        }
        this.access.execute((world, pos) -> {
            float eterna = this.stats.eterna();
            float quanta = this.stats.quanta();
            float arcana = this.stats.arcana();
            boolean stable = this.stats.stable();
            List<EnchantmentInstance> list = this.getEnchantmentList(toEnchant, slot, this.costs[slot]);
            if (list.isEmpty()) return;
            EnchantmentUtils.chargeExperience((Player)player, (int)MiscUtil.getExpCostForSlot(level, slot));
            player.onEnchantmentPerformed(toEnchant, 0);
            if (list.get((int)0).enchantment.is(Ench.Enchantments.INFUSION)) {
                InfusionRecipe match = InfusionRecipe.findMatch(world, toEnchant, eterna, quanta, arcana);
                if (match == null) return;
                this.enchantSlots.setItem(0, match.assemble(toEnchant, eterna, quanta, arcana));
            } else {
                this.enchantSlots.setItem(0, toEnchant.getItem().applyEnchantments(toEnchant, list));
            }
            if (!player.getAbilities().instabuild) {
                lapis.shrink(cost);
                if (lapis.isEmpty()) {
                    this.enchantSlots.setItem(1, ItemStack.EMPTY);
                }
            }
            player.awardStat(Stats.ENCHANT_ITEM);
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                Ench.Triggers.ENCHANTED.trigger(sp, this.enchantSlots.getItem(0), level, eterna, quanta, arcana, stable);
                CriteriaTriggers.ENCHANTED_ITEM.trigger(sp, this.enchantSlots.getItem(0), level);
            }
            this.enchantSlots.setChanged();
            this.enchantmentSeed.set(player.getEnchantmentSeed());
            this.slotsChanged(this.enchantSlots);
            world.playSound((Player)null, pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, world.random.nextFloat() * 0.1f + 0.9f);
        });
        return true;
    }

    public void slotsChanged(Container inventoryIn) {
        this.access.evaluate((world, pos) -> {
            if (inventoryIn == this.enchantSlots) {
                ItemStack toEnchant = inventoryIn.getItem(0);
                this.gatherStats();
                InfusionRecipe match = InfusionRecipe.findItemMatch(world, toEnchant);
                if (toEnchant.getCount() == 1 && (match != null || toEnchant.getItem().isEnchantable(toEnchant) && ApothEnchantmentMenu.isEnchantableEnough(toEnchant))) {
                    int slot;
                    float eterna = this.stats.eterna();
                    if ((double)eterna < 1.5) {
                        eterna = 1.5f;
                    }
                    this.random.setSeed((long)this.enchantmentSeed.get());
                    for (slot = 0; slot < 3; ++slot) {
                        this.costs[slot] = ApothEnchantmentHelper.getEnchantmentCost(this.random, slot, eterna, toEnchant);
                        this.enchantClue[slot] = -1;
                        this.levelClue[slot] = -1;
                        if (this.costs[slot] < slot + 1) {
                            int n = slot;
                            this.costs[n] = this.costs[n] + 1;
                        }
                        this.costs[slot] = EventHooks.onEnchantmentLevelSet((Level)world, (BlockPos)pos, (int)slot, (int)Math.round(eterna), (ItemStack)toEnchant, (int)this.costs[slot]);
                    }
                    for (slot = 0; slot < 3; ++slot) {
                        List<EnchantmentInstance> list;
                        if (this.costs[slot] <= 0 || (list = this.getEnchantmentList(toEnchant, slot, this.costs[slot])) == null || list.isEmpty()) continue;
                        EnchantmentInstance enchantmentdata = list.remove(this.random.nextInt(list.size()));
                        this.enchantClue[slot] = this.player.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getId((Object)((Enchantment)enchantmentdata.enchantment.value()));
                        this.levelClue[slot] = enchantmentdata.level;
                        int clues = this.stats.clues();
                        ArrayList<EnchantmentInstance> clueList = new ArrayList<EnchantmentInstance>();
                        if (clues-- > 0) {
                            clueList.add(enchantmentdata);
                        }
                        while (clues-- > 0 && !list.isEmpty()) {
                            clueList.add(list.remove(this.random.nextInt(list.size())));
                        }
                        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new CluePayload(slot, clueList, list.isEmpty()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    this.broadcastChanges();
                } else {
                    for (int i = 0; i < 3; ++i) {
                        this.costs[i] = 0;
                        this.enchantClue[i] = -1;
                        this.levelClue[i] = -1;
                    }
                    this.stats = EnchantmentTableStats.INVALID;
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new StatsPayload(this.stats), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            return this;
        });
    }

    public void gatherStats() {
        this.access.evaluate((world, pos) -> {
            this.stats = EnchantmentTableStats.gatherStats((LevelReader)world, pos, this.getSlot(0).getItem().getEnchantmentValue());
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new StatsPayload(this.stats), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return this;
        }).orElse(this);
    }

    public void setStats(EnchantmentTableStats stats) {
        this.stats = stats;
    }

    public MenuType<?> getType() {
        return Ench.Menus.ENCHANTING_TABLE;
    }

    private List<EnchantmentInstance> getEnchantmentList(ItemStack stack, int enchantSlot, int level) {
        this.random.setSeed((long)(this.enchantmentSeed.get() + enchantSlot));
        List<EnchantmentInstance> list = ApothEnchantmentHelper.selectEnchantment(this.random, stack, level, this.stats, (HolderLookup.RegistryLookup<Enchantment>)this.player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT));
        InfusionRecipe match = ((Optional)this.access.evaluate((world, pos) -> Optional.ofNullable(InfusionRecipe.findMatch(world, stack, this.stats.eterna(), this.stats.quanta(), this.stats.arcana()))).get()).orElse(null);
        if (enchantSlot == 2 && match != null) {
            list.clear();
            list.add(new EnchantmentInstance(this.player.level().holderOrThrow(Ench.Enchantments.INFUSION), 1));
        }
        return list;
    }

    public static boolean isEnchantableEnough(ItemStack stack) {
        if (!stack.isEnchanted()) {
            return true;
        }
        return EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).keySet().stream().allMatch(h -> h.is(EnchantmentTags.CURSE));
    }
}

