/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.enchantments.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.table.ApothEnchantmentHelper;
import java.util.List;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.level.BlockDropsEvent;

public record BoonComponent(List<BoonData> entries) {
    public static Codec<BoonComponent> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BoonData.CODEC.listOf().fieldOf("entries").forGetter(BoonComponent::entries)).apply((Applicative)inst, BoonComponent::new));

    public static void provideBenefits(BlockDropsEvent e) {
        if (e.getBreaker() == null || e.getTool().isEmpty()) {
            return;
        }
        ItemStack stack = e.getTool();
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (ench, level) -> {
            BoonComponent comp = (BoonComponent)((Enchantment)ench.value()).effects().get(Ench.EnchantEffects.EARTHS_BOON);
            if (comp != null) {
                for (BoonData entry : comp.entries) {
                    if (!entry.matches(e.getState())) continue;
                    LootTable table = e.getLevel().getServer().reloadableRegistries().getLootTable(entry.lootTable);
                    if (table == LootTable.EMPTY) {
                        ApothicEnchanting.LOGGER.error("[Boon] Loot table '{}' not found!", (Object)entry.lootTable.location());
                        break;
                    }
                    LootContext ctx = Enchantment.blockHitContext((ServerLevel)e.getLevel(), (int)level, (Entity)e.getBreaker(), (Vec3)Vec3.atCenterOf((Vec3i)e.getPos()), (BlockState)e.getState());
                    float chance = ApothEnchantmentHelper.processValue(entry.dropChance, ctx, level, 0.0f);
                    RandomSource rand = e.getLevel().random;
                    if (!(rand.nextFloat() <= chance)) break;
                    Vec3 pos = e.getDrops().stream().findAny().map(Entity::position).orElse(Vec3.atCenterOf((Vec3i)e.getPos()));
                    table.getRandomItems(ctx, item -> e.getDrops().add(new ItemEntity((Level)e.getLevel(), pos.x, pos.y, pos.z, item)));
                    break;
                }
            }
        });
    }

    public record BoonData(HolderSet<Block> targets, ResourceKey<LootTable> lootTable, List<ConditionalEffect<EnchantmentValueEffect>> dropChance) {
        public static Codec<BoonData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("target").forGetter(BoonData::targets), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table").forGetter(BoonData::lootTable), (App)ConditionalEffect.codec((Codec)EnchantmentValueEffect.CODEC, (LootContextParamSet)LootContextParamSets.HIT_BLOCK).listOf().fieldOf("drop_chance").forGetter(BoonData::dropChance)).apply((Applicative)inst, BoonData::new));

        public boolean matches(BlockState state) {
            return this.targets.contains(state.getBlockHolder());
        }
    }
}

