/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.compat;

import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.objects.FilteringShelfBlock;
import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import java.util.ArrayList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.JadeIds;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

@WailaPlugin
public class EnchJadePlugin
implements IWailaPlugin,
IBlockComponentProvider {
    public void registerClient(IWailaClientRegistration reg) {
        reg.registerBlockComponent((IComponentProvider)this, Block.class);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        TooltipUtil.appendBlockStats((LevelReader)accessor.getLevel(), accessor.getBlockState(), accessor.getPosition(), arg_0 -> ((ITooltip)tooltip).add(arg_0));
        if (accessor.getBlock() == Blocks.ENCHANTING_TABLE) {
            TooltipUtil.appendTableStats((LevelReader)accessor.getLevel(), accessor.getPosition(), arg_0 -> ((ITooltip)tooltip).add(arg_0));
            tooltip.remove(JadeIds.MC_TOTAL_ENCHANTMENT_POWER);
        }
        if (accessor.getBlock() == Ench.Blocks.FILTERING_SHELF.value()) {
            this.handleFilteringShelf(tooltip, accessor);
        }
    }

    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        if (accessor.getBlock() == Ench.Blocks.FILTERING_SHELF.value()) {
            return IElementHelper.get().item(accessor.getPickedResult());
        }
        return currentIcon;
    }

    public ResourceLocation getUid() {
        return ApothicEnchanting.loc("ench");
    }

    public int getDefaultPriority() {
        return 1150;
    }

    public void handleFilteringShelf(ITooltip tooltip, BlockAccessor accessor) {
        tooltip.remove(JadeIds.MC_ENCHANTMENT_POWER);
        tooltip.remove(JadeIds.MC_CHISELED_BOOKSHELF);
        tooltip.remove(JadeIds.UNIVERSAL_ITEM_STORAGE);
        if (accessor.showDetails()) {
            return;
        }
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof FilteringShelfBlock.FilteringShelfTile) {
            FilteringShelfBlock.FilteringShelfTile tile = (FilteringShelfBlock.FilteringShelfTile)blockEntity;
            int slot = ((ChiseledBookShelfBlock)accessor.getBlock()).getHitSlot((BlockHitResult)accessor.getHitResult(), accessor.getBlockState()).orElse(-1);
            if (slot == -1) {
                return;
            }
            ItemStack stack = tile.getItem(slot);
            if (stack.isEmpty()) {
                return;
            }
            tooltip.add(CommonComponents.EMPTY);
            IElementHelper helper = IElementHelper.get();
            ArrayList<IElement> elements = new ArrayList<IElement>();
            elements.add(helper.smallItem(stack).clearCachedMessage());
            elements.add(helper.text((Component)Component.literal((String)" ").append((Component)Component.literal((String)IDisplayHelper.get().humanReadableNumber((double)stack.getCount(), "", false)).append("\u00d7 ").append(stack.getHoverName()))).message(null));
            tooltip.add(elements);
            ItemEnchantments enchants = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
            if (!enchants.isEmpty()) {
                ArrayList list = new ArrayList();
                enchants.addToTooltip(Item.TooltipContext.of((Level)accessor.getLevel()), list::add, ApothicAttributes.getTooltipFlag());
                for (Component c : list) {
                    tooltip.add((Component)Component.literal((String)" - ").append(c));
                }
            }
        }
    }
}

