/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.state.BlockState;

public class CodecUtils {

    public record BlockMatcher(ResourceLocation blockRL, boolean isTag, Optional<StatePropertiesPredicate> state) {
        public static final MapCodec<BlockMatcher> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("resourcelocation").forGetter(BlockMatcher::blockRL), (App)Codec.BOOL.fieldOf("is_tag").forGetter(BlockMatcher::isTag), (App)StatePropertiesPredicate.CODEC.optionalFieldOf("state").forGetter(BlockMatcher::state)).apply((Applicative)builder, BlockMatcher::new));

        public boolean blockMatched(BlockState blockState) {
            if (this.isTag() ? !blockState.is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)this.blockRL())) : !blockState.is(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)this.blockRL()))) {
                return false;
            }
            return this.state.isEmpty() || this.state.get().matches(blockState);
        }
    }
}

